/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.data;

import com.openexchange.osgi.data.AbstractModule;
import com.openexchange.osgi.data.DirModule;
import com.openexchange.osgi.data.OSGIManifest;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class SrcDirModule
extends DirModule {
    private Set<String> sourceDirs = new HashSet<String>();
    private List<String> classpathDependencies = new LinkedList<String>();
    private Set<String> requiredClasspath = new HashSet<String>();
    private Set<String> exportedClasspath = new HashSet<String>();
    private Set<String> runtimeClasspath = new HashSet<String>();
    private static final String JARS_PATTERN_DEFINITION = "^.*/jars/(.*\\.jar)$";
    private static final Pattern JARS_PATTERN = Pattern.compile("^.*/jars/(.*\\.jar)$");
    private static final String TEST_SOURCES_PATTERN = "(sim|test)";
    private static final Pattern TEST_SOURCES = Pattern.compile("(sim|test)");

    public SrcDirModule(File file) {
        super(file);
    }

    private void readFiles(File manifestFile, File classpathFile) throws IOException, JDOMException {
        if (manifestFile.exists() && manifestFile.length() != 0L) {
            this.osgiManifest = new OSGIManifest(manifestFile);
            for (String classpathEntry : this.osgiManifest.getListEntry("Bundle-ClassPath")) {
                if (classpathEntry.equals(".")) continue;
                this.runtimeClasspath.add(classpathEntry);
                if (!this.isExported(new File(this.file, classpathEntry))) continue;
                this.exportedClasspath.add(classpathEntry);
            }
        }
        if (classpathFile.exists() && classpathFile.length() != 0L) {
            Document d = new SAXBuilder().build(classpathFile);
            Element root = d.getRootElement();
            List list = root.getChildren("classpathentry");
            for (Element entry : list) {
                String path;
                if (entry.getAttributeValue("kind").equals("lib")) {
                    path = entry.getAttributeValue("path");
                    this.runtimeClasspath.add(path);
                    Matcher matcher = JARS_PATTERN.matcher(path);
                    if (matcher.matches()) {
                        this.classpathDependencies.add(matcher.group(1));
                        continue;
                    }
                    this.requiredClasspath.add(path);
                    if (!"true".equals(entry.getAttributeValue("exported"))) continue;
                    this.exportedClasspath.add(path);
                    continue;
                }
                if (!entry.getAttributeValue("kind").equals("src")) continue;
                path = entry.getAttributeValue("path");
                if (path.startsWith("/")) {
                    this.classpathDependencies.add(path.substring(1));
                    continue;
                }
                this.sourceDirs.add(entry.getAttributeValue("path"));
            }
        }
    }

    @Override
    public void readLocalFiles() throws IOException {
        try {
            this.readFiles(new File(this.file, "/META-INF/MANIFEST.MF"), new File(this.file, ".classpath"));
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void computeDependencies(Map<String, AbstractModule> projectsByName, Map<String, Set<AbstractModule>> projectsByPackage, Map<String, AbstractModule> modulesByFilename, boolean strict) throws Exception {
        block0: for (String classpathProject : this.classpathDependencies) {
            for (AbstractModule module : new AbstractModule[]{projectsByName.get(classpathProject), modulesByFilename.get(classpathProject)}) {
                if (module == null || module == this) continue;
                this.dependencies.add(module);
                continue block0;
            }
        }
        super.computeDependencies(projectsByName, projectsByPackage, modulesByFilename, strict);
    }

    @Override
    public List<String> getRequiredClasspath(boolean transitive) {
        ArrayList<String> retval = new ArrayList<String>();
        if (!this.requiredClasspath.isEmpty()) {
            for (String classpathEntry : this.requiredClasspath) {
                retval.add(this.file.getAbsolutePath() + File.separatorChar + classpathEntry);
            }
        }
        retval.addAll(super.getRequiredClasspath(transitive));
        return Collections.unmodifiableList(retval);
    }

    @Override
    protected Set<String> getExportedClasspath() {
        Set<String> retval = SrcDirModule.addBundlePath(this.file, this.exportedClasspath);
        retval.add(this.file.getAbsolutePath() + File.separatorChar + "<bin>");
        return Collections.unmodifiableSet(retval);
    }

    @Override
    protected Set<String> getRuntimeClasspath() {
        Set<String> retval = SrcDirModule.addBundlePath(this.file, this.runtimeClasspath);
        retval.add(this.file.getAbsolutePath() + File.separatorChar + "<bin>");
        return Collections.unmodifiableSet(retval);
    }

    @Override
    public Set<String> getSourceDirs() {
        HashSet<String> retval = new HashSet<String>();
        for (String sourceDir : this.sourceDirs) {
            Matcher matcher = TEST_SOURCES.matcher(sourceDir);
            if (matcher.matches()) continue;
            retval.add(this.file.getAbsolutePath() + File.separatorChar + sourceDir);
        }
        return Collections.unmodifiableSet(retval);
    }

    @Override
    public Set<String> getTestSourceDirs() {
        HashSet<String> retval = new HashSet<String>();
        for (String sourceDir : this.sourceDirs) {
            Matcher matcher = TEST_SOURCES.matcher(sourceDir);
            if (!matcher.matches()) continue;
            retval.add(this.file.getAbsolutePath() + File.separatorChar + sourceDir);
        }
        return Collections.unmodifiableSet(retval);
    }
}

