/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.obs.api;

import com.openexchange.obs.BuildFailureException;
import com.openexchange.obs.api.BuildServiceException;
import com.openexchange.obs.api.Code;
import com.openexchange.obs.api.PackageStatus;
import com.openexchange.obs.api.Result;
import com.openexchange.obs.api.State;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public final class Tools {
    private static final TransformerFactory tf = TransformerFactory.newInstance();

    private Tools() {
    }

    public static boolean isDirty(Result[] results) {
        for (Result result : results) {
            if (!result.isDirty()) continue;
            return true;
        }
        return false;
    }

    public static boolean isProjectBuilding(Result[] results) {
        boolean finished = true;
        for (Result result : results) {
            finished = finished && State.PUBLISHED == result.getState();
        }
        return !finished;
    }

    public static boolean hasSomePackageInState(PackageStatus[] statuses, Code ... codes) {
        for (PackageStatus status : statuses) {
            for (Code code : codes) {
                if (code != status.getCode()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean somePackageUnresolved(PackageStatus[] statuses) {
        for (PackageStatus status : statuses) {
            if (Code.UNRESOLVABLE != status.getCode()) continue;
            return true;
        }
        return false;
    }

    public static boolean somePackageUnresolved(Result[] results) {
        for (Result result : results) {
            if (!Tools.somePackageUnresolved(result.getStatuses())) continue;
            return true;
        }
        return false;
    }

    public static boolean allPublishedAndSomePackageUnresolved(Result[] results) {
        return Tools.allPublished(results) && Tools.somePackageUnresolved(results);
    }

    private static boolean allPublished(Result[] results) {
        for (Result result : results) {
            if (State.PUBLISHED == result.getState()) continue;
            return false;
        }
        return true;
    }

    public static PackageStatus getFirstPackageForState(PackageStatus[] statuses, Code ... codes) {
        for (PackageStatus status : statuses) {
            for (Code code : codes) {
                if (code != status.getCode()) continue;
                return status;
            }
        }
        return null;
    }

    public static Result getFirstResultWithState(Result[] results, Code ... codes) {
        for (Result result : results) {
            if (!Tools.hasSomePackageInState(result.getStatuses(), codes)) continue;
            return result;
        }
        return null;
    }

    public static String transform(Document document) throws BuildServiceException {
        StringWriter sw = new StringWriter();
        if (null == document) {
            return sw.toString();
        }
        try {
            Transformer transformer = tf.newTransformer();
            transformer.transform(new DOMSource(document), new StreamResult(sw));
        }
        catch (TransformerConfigurationException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        catch (TransformerException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        return sw.toString();
    }

    public static void transfer(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[512];
        int length = -1;
        while ((length = in.read(buffer)) != -1) {
            out.write(buffer, 0, length);
        }
        out.flush();
    }

    public static Result[] combine(Map<String, Result[]> map) {
        ArrayList<Result> retval = new ArrayList<Result>();
        for (Result[] results : map.values()) {
            retval.addAll(Arrays.asList(results));
        }
        return retval.toArray(new Result[retval.size()]);
    }

    public static int packagesToBuild(Map<String, Result[]> results) {
        int packagesLeft = 0;
        for (Map.Entry<String, Result[]> entry : results.entrySet()) {
            for (Result result : entry.getValue()) {
                block5: for (PackageStatus status : result.getStatuses()) {
                    switch (status.getCode()) {
                        case SUCCEEDED: 
                        case DISABLED: 
                        case EXCLUDED: {
                            continue block5;
                        }
                        default: {
                            ++packagesLeft;
                        }
                    }
                }
            }
        }
        return packagesLeft;
    }

    public static void checkResultsForState(Result[] results, String projectName, Code ... codes) throws BuildFailureException, BuildServiceException {
        Result result = Tools.getFirstResultWithState(results, codes);
        if (null == result) {
            return;
        }
        PackageStatus pack = Tools.getFirstPackageForState(result.getStatuses(), codes);
        if (null == pack) {
            throw new BuildServiceException("One or more packages has " + com.openexchange.build.utils.Tools.join((String)",", (Object[])((Object[])codes)) + " inside result for repository " + result.getRepository().toString() + ", but could not determine which one.");
        }
        if (!Tools.isDirty(results)) {
            throw new BuildFailureException("Build on build service failed.", projectName, result, pack);
        }
    }
}

