/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.metrics;

import java.util.Map;
import java.util.Optional;
import com.openexchange.metrics.types.Metric;

/**
 * {@link MetricRegisterer}
 *
 * @author <a href="mailto:ioannis.chouklis@open-xchange.com">Ioannis Chouklis</a>
 */
public interface MetricRegisterer {

    /**
     * Registers a new {@link Metric} or gets an already existing one
     *
     * @param descriptor The descriptor for the metric
     * @return the new or already existing one {@link Metric}
     */
    Metric register(MetricDescriptor descriptor);

    /**
     * Unregisters a {@link Metric} described with the specified {@link MetricDescriptor}
     *
     * @param descriptor The descriptor
     */
    void unregister(MetricDescriptor descriptor);

    /**
     * Gets a dotted name for given descriptor.
     *
     * @param descriptor The descriptor
     * @return The dotted name for given descriptor
     */
    default String getNameFor(MetricDescriptor descriptor) {
        StringBuilder sb = new StringBuilder(descriptor.getGroup()).append('.').append(descriptor.getName());
        Optional<Map<String, String>> optionalDimensions = descriptor.getDimensions();
        if (optionalDimensions.isPresent()) {
            for (Map.Entry<String, String> dimensionEntry : optionalDimensions.get().entrySet()) {
                sb.append('.').append(dimensionEntry.getKey()).append('-').append(dimensionEntry.getValue());
            }
        }
        return sb.toString();
    }

}
