/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.dmfs.rfc5545.DateTime;
import org.dmfs.rfc5545.Weekday;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.calendarmetrics.GregorianCalendarMetrics;
import org.dmfs.rfc5545.recur.ByDayExpander;
import org.dmfs.rfc5545.recur.ByDayFilter;
import org.dmfs.rfc5545.recur.ByExpander;
import org.dmfs.rfc5545.recur.ByFilter;
import org.dmfs.rfc5545.recur.ByHourExpander;
import org.dmfs.rfc5545.recur.ByHourFilter;
import org.dmfs.rfc5545.recur.ByMinuteExpander;
import org.dmfs.rfc5545.recur.ByMinuteFilter;
import org.dmfs.rfc5545.recur.ByMonthDayExpander;
import org.dmfs.rfc5545.recur.ByMonthDayFilter;
import org.dmfs.rfc5545.recur.ByMonthDaySkipFilter;
import org.dmfs.rfc5545.recur.ByMonthExpander;
import org.dmfs.rfc5545.recur.ByMonthFilter;
import org.dmfs.rfc5545.recur.ByMonthSkipFilter;
import org.dmfs.rfc5545.recur.BySecondExpander;
import org.dmfs.rfc5545.recur.BySecondFilter;
import org.dmfs.rfc5545.recur.BySetPosFilter;
import org.dmfs.rfc5545.recur.ByWeekNoExpander;
import org.dmfs.rfc5545.recur.ByYearDayExpander;
import org.dmfs.rfc5545.recur.ByYearDayFilter;
import org.dmfs.rfc5545.recur.CountLimiter;
import org.dmfs.rfc5545.recur.FastBirthdayIterator;
import org.dmfs.rfc5545.recur.FastWeeklyIterator;
import org.dmfs.rfc5545.recur.Freq;
import org.dmfs.rfc5545.recur.FreqIterator;
import org.dmfs.rfc5545.recur.InvalidRecurrenceRuleException;
import org.dmfs.rfc5545.recur.RecurrenceRuleIterator;
import org.dmfs.rfc5545.recur.RuleIterator;
import org.dmfs.rfc5545.recur.SanityFilter;
import org.dmfs.rfc5545.recur.SkipBuffer;
import org.dmfs.rfc5545.recur.TrivialByMonthFilter;
import org.dmfs.rfc5545.recur.UnicodeCalendarScales;
import org.dmfs.rfc5545.recur.UntilLimiter;

public final class RecurrenceRule {
    private static final Integer ONE = 1;
    private static final String FREQ_PREFIX = Part.FREQ.name() + "=";
    private static final CalendarMetrics DEFAULT_CALENDAR_SCALE = new GregorianCalendarMetrics(Weekday.MO, 4);
    private static final Skip SKIP_DEFAULT = Skip.OMIT;
    public final RfcMode mode;
    private EnumMap<Part, Object> mParts = new EnumMap(Part.class);
    private Map<String, String> mXParts = null;
    private CalendarMetrics mCalendarMetrics = DEFAULT_CALENDAR_SCALE;
    private static final ValueConverter<Void> ERROR_CONVERTER = new ValueConverter<Void>(){

        @Override
        public Void parse(String value, CalendarMetrics calScale, CalendarMetrics rScale, boolean tolerant) throws InvalidRecurrenceRuleException {
            throw new InvalidRecurrenceRuleException("part not allowed in an RRULE");
        }
    };

    public RecurrenceRule(String recur) throws InvalidRecurrenceRuleException {
        this(recur, RfcMode.RFC5545_LAX);
    }

    public RecurrenceRule(String recur, RfcMode mode) throws InvalidRecurrenceRuleException {
        this.mode = mode;
        this.parseString(recur);
    }

    public RecurrenceRule(Freq freq) {
        this(freq, RfcMode.RFC5545_STRICT);
    }

    public RecurrenceRule(Freq freq, RfcMode mode) {
        this.mode = mode;
        this.mParts.put(Part.FREQ, (Object)freq);
    }

    private void parseString(String recur) throws InvalidRecurrenceRuleException {
        String value;
        String key;
        int equals;
        boolean relaxed;
        if (recur == null) {
            throw new IllegalArgumentException("recur must not be null");
        }
        boolean bl = relaxed = this.mode == RfcMode.RFC2445_LAX || this.mode == RfcMode.RFC5545_LAX;
        if (relaxed) {
            recur = recur.trim();
        }
        recur = recur.toUpperCase(Locale.ENGLISH);
        String[] parts = recur.split(";");
        if (this.mode == RfcMode.RFC2445_STRICT && !parts[0].startsWith(FREQ_PREFIX)) {
            throw new InvalidRecurrenceRuleException("RFC 2445 requires FREQ to be the first part of the rule: " + recur);
        }
        CalendarMetrics calScale = this.mCalendarMetrics;
        CalendarMetrics rScale = DEFAULT_CALENDAR_SCALE;
        EnumMap<Part, Object> partMap = this.mParts;
        String rscaleKey = Part.RSCALE.name();
        for (String keyvalue : parts) {
            if (!keyvalue.startsWith(rscaleKey)) continue;
            equals = keyvalue.indexOf("=");
            if (equals > 0) {
                key = keyvalue.substring(0, equals);
                if (!key.equals(rscaleKey)) continue;
                value = keyvalue.substring(equals + 1);
                rScale = (CalendarMetrics)Part.RSCALE.converter.parse(value, calScale, null, relaxed);
                partMap.put(Part.RSCALE, (Object)rScale);
                break;
            }
            if (relaxed) continue;
            throw new InvalidRecurrenceRuleException("Missing '=' in part '" + keyvalue + "'");
        }
        block14: for (String keyvalue : parts) {
            equals = keyvalue.indexOf("=");
            if (equals > 0) {
                Part part;
                key = keyvalue.substring(0, equals);
                value = keyvalue.substring(equals + 1);
                try {
                    part = Part.valueOf(key);
                }
                catch (IllegalArgumentException e) {
                    if (key.length() > 2 && key.charAt(0) == 'X' && key.charAt(1) == '-') {
                        switch (this.mode) {
                            case RFC2445_LAX: 
                            case RFC2445_STRICT: {
                                this.setXPart(key, value);
                                break;
                            }
                            case RFC5545_LAX: {
                                continue block14;
                            }
                            case RFC5545_STRICT: {
                                throw new InvalidRecurrenceRuleException("invalid part " + key + " in " + recur);
                            }
                        }
                        continue;
                    }
                    if (relaxed) continue;
                    throw new InvalidRecurrenceRuleException("invalid part " + key + " in " + recur);
                }
                if (part == Part.RSCALE) continue;
                if (!relaxed && partMap.containsKey((Object)part)) {
                    throw new InvalidRecurrenceRuleException("duplicate part " + (Object)((Object)part) + " in " + recur);
                }
                try {
                    Object partValue = part.converter.parse(value, calScale, rScale, relaxed);
                    if (partValue == null || part == Part.INTERVAL && ONE.equals(partValue)) continue;
                    partMap.put(part, partValue);
                    continue;
                }
                catch (InvalidRecurrenceRuleException e) {
                    if (relaxed) continue;
                    throw e;
                }
            }
            if (relaxed) continue;
            throw new InvalidRecurrenceRuleException("Missing '=' in part '" + keyvalue + "'");
        }
        if (partMap.containsKey((Object)Part.RSCALE) && !partMap.containsKey((Object)Part.SKIP)) {
            partMap.put(Part.SKIP, (Object)SKIP_DEFAULT);
        }
        if (this.getSkip() != Skip.OMIT) {
            switch (this.getFreq()) {
                case YEARLY: {
                    this.mParts.put(Part._BYMONTHSKIP, null);
                }
                case MONTHLY: {
                    this.mParts.put(Part._BYMONTHDAYSKIP, null);
                    break;
                }
            }
        }
        this.validate();
    }

    private void checkForInvalidNumericInByDay(Freq freq) throws InvalidRecurrenceRuleException {
        EnumMap<Part, Object> partMap = this.mParts;
        if (partMap.containsKey((Object)Part.BYDAY)) {
            ArrayList values = (ArrayList)partMap.get((Object)Part.BYDAY);
            for (WeekdayNum value : values) {
                if (value.pos == 0) continue;
                if (freq != Freq.YEARLY && freq != Freq.MONTHLY) {
                    if (this.mode == RfcMode.RFC5545_STRICT) {
                        String errMsg = "The BYDAY rule part must not be specified with a numeric value when the FREQ rule part is not set to MONTHLY or YEARLY.";
                        throw new InvalidRecurrenceRuleException("The BYDAY rule part must not be specified with a numeric value when the FREQ rule part is not set to MONTHLY or YEARLY.");
                    }
                    partMap.remove((Object)Part.BYDAY);
                    continue;
                }
                if (freq != Freq.YEARLY || !partMap.containsKey((Object)Part.BYWEEKNO)) continue;
                if (this.mode == RfcMode.RFC5545_STRICT) {
                    String errMsg = "The BYDAY rule part must not be specified with a numeric value with the FREQ rule part set to YEARLY when BYWEEKNO is set";
                    throw new InvalidRecurrenceRuleException("The BYDAY rule part must not be specified with a numeric value with the FREQ rule part set to YEARLY when BYWEEKNO is set");
                }
                partMap.remove((Object)Part.BYDAY);
            }
        }
    }

    private void validate() throws InvalidRecurrenceRuleException {
        boolean strict;
        EnumMap<Part, Object> partMap = this.mParts;
        Freq freq = (Freq)((Object)partMap.get((Object)Part.FREQ));
        if (freq == null) {
            throw new InvalidRecurrenceRuleException("FREQ part is missing");
        }
        boolean bl = strict = this.mode == RfcMode.RFC2445_STRICT || this.mode == RfcMode.RFC5545_STRICT;
        if (partMap.containsKey((Object)Part.UNTIL) && partMap.containsKey((Object)Part.COUNT)) {
            throw new InvalidRecurrenceRuleException("UNTIL and COUNT must not occur in the same rule.");
        }
        if (this.getInterval() <= 0) {
            if (strict) {
                throw new InvalidRecurrenceRuleException("INTERVAL must not be <= 0");
            }
            partMap.remove((Object)Part.INTERVAL);
        }
        if (freq != Freq.YEARLY && partMap.containsKey((Object)Part.BYWEEKNO)) {
            if (strict) {
                throw new InvalidRecurrenceRuleException("BYWEEKNO is allowed in YEARLY rules only");
            }
            partMap.put(Part.FREQ, (Object)Freq.YEARLY);
        }
        if (this.mode == RfcMode.RFC5545_STRICT) {
            if ((freq == Freq.DAILY || freq == Freq.WEEKLY || freq == Freq.MONTHLY) && partMap.containsKey((Object)Part.BYYEARDAY)) {
                throw new InvalidRecurrenceRuleException("In RFC 5545, BYYEARDAY is not allowed in DAILY, WEEKLY or MONTHLY rules");
            }
            if (freq == Freq.WEEKLY && partMap.containsKey((Object)Part.BYMONTHDAY)) {
                throw new InvalidRecurrenceRuleException("In RFC 5545, BYMONTHDAY is not allowed in WEEKLY rules");
            }
        }
        if (!(!partMap.containsKey((Object)Part.BYSETPOS) || partMap.containsKey((Object)Part.BYDAY) || partMap.containsKey((Object)Part.BYMONTHDAY) || partMap.containsKey((Object)Part.BYMONTH) || partMap.containsKey((Object)Part.BYHOUR) || partMap.containsKey((Object)Part.BYMINUTE) || partMap.containsKey((Object)Part.BYSECOND) || partMap.containsKey((Object)Part.BYWEEKNO) || partMap.containsKey((Object)Part.BYYEARDAY))) {
            if (strict) {
                throw new InvalidRecurrenceRuleException("BYSETPOS must only be used in conjunction with another BYxxx rule.");
            }
            partMap.remove((Object)Part.BYSETPOS);
        }
        this.checkForInvalidNumericInByDay(freq);
    }

    private void validate(Part part, List<Integer> value) throws InvalidRecurrenceRuleException {
        Freq freq = (Freq)((Object)this.mParts.get((Object)Part.FREQ));
        if (this.mode == RfcMode.RFC5545_STRICT) {
            if (freq != Freq.YEARLY && part == Part.BYWEEKNO) {
                throw new InvalidRecurrenceRuleException("In RFC 5545, BYWEEKNO is allowed in YEARLY rules only");
            }
            if ((freq == Freq.DAILY || freq == Freq.WEEKLY || freq == Freq.MONTHLY) && part == Part.BYYEARDAY) {
                throw new InvalidRecurrenceRuleException("In RFC 5545, BYYEARDAY is not allowed in DAILY, WEEKLY or MONTHLY rules");
            }
            if (freq == Freq.WEEKLY && part == Part.BYMONTHDAY) {
                throw new InvalidRecurrenceRuleException("In RFC 5545, BYMONTHDAY is not allowed in WEEKLY rules");
            }
        }
    }

    public Freq getFreq() {
        return (Freq)((Object)this.mParts.get((Object)Part.FREQ));
    }

    public void setFreq(Freq freq, boolean silent) {
        this.mParts.put(Part.FREQ, (Object)freq);
        if (this.mode == RfcMode.RFC5545_STRICT || this.mode == RfcMode.RFC5545_LAX) {
            // empty if block
        }
    }

    public Skip getSkip() {
        Skip skip = (Skip)((Object)this.mParts.get((Object)Part.SKIP));
        return skip == null ? Skip.OMIT : skip;
    }

    public void setSkip(Skip skip) {
        if (skip == null || skip == Skip.OMIT) {
            this.mParts.remove((Object)Part.SKIP);
            this.mParts.remove((Object)Part._BYMONTHSKIP);
            this.mParts.remove((Object)Part._BYMONTHDAYSKIP);
        } else {
            Freq freq;
            this.mParts.put(Part.SKIP, (Object)skip);
            if (!this.mParts.containsKey((Object)Part.RSCALE)) {
                this.mParts.put(Part.RSCALE, (Object)DEFAULT_CALENDAR_SCALE);
            }
            if ((freq = this.getFreq()) == Freq.YEARLY || freq == Freq.MONTHLY) {
                this.mParts.put(Part._BYMONTHSKIP, null);
                this.mParts.put(Part._BYMONTHDAYSKIP, null);
            }
        }
    }

    public int getInterval() {
        Integer interval = (Integer)this.mParts.get((Object)Part.INTERVAL);
        return interval == null ? 1 : interval;
    }

    public void setInterval(int interval) {
        if (interval > 1) {
            this.mParts.put(Part.INTERVAL, (Object)interval);
        } else {
            if (interval <= 0) {
                throw new IllegalArgumentException("Interval must be a positive integer value");
            }
            this.mParts.remove((Object)Part.INTERVAL);
        }
    }

    public DateTime getUntil() {
        return (DateTime)this.mParts.get((Object)Part.UNTIL);
    }

    public void setUntil(DateTime until) {
        if (until == null) {
            this.mParts.remove((Object)Part.UNTIL);
            this.mParts.remove((Object)Part.COUNT);
        } else {
            if (!until.isFloating() && !DateTime.UTC.equals(until.getTimeZone()) || !this.mCalendarMetrics.equals((Object)until.getCalendarMetrics())) {
                this.mParts.put(Part.UNTIL, (Object)new DateTime(this.mCalendarMetrics, DateTime.UTC, until.getTimestamp()));
            } else {
                this.mParts.put(Part.UNTIL, (Object)until);
            }
            this.mParts.remove((Object)Part.COUNT);
        }
    }

    public Integer getCount() {
        return (Integer)this.mParts.get((Object)Part.COUNT);
    }

    public void setCount(int count) {
        this.mParts.put(Part.COUNT, (Object)count);
        this.mParts.remove((Object)Part.UNTIL);
    }

    public boolean isInfinite() {
        return !this.mParts.containsKey((Object)Part.UNTIL) && !this.mParts.containsKey((Object)Part.COUNT);
    }

    public boolean hasPart(Part part) {
        return this.mParts.containsKey((Object)part);
    }

    public List<Integer> getByPart(Part part) {
        switch (part) {
            case BYSECOND: 
            case BYMINUTE: 
            case BYHOUR: 
            case BYMONTHDAY: 
            case BYYEARDAY: 
            case BYWEEKNO: 
            case BYMONTH: 
            case BYSETPOS: {
                return (List)this.mParts.get((Object)part);
            }
        }
        throw new IllegalArgumentException(part.name() + " is not a list type");
    }

    public void setByPart(Part part, List<Integer> value) throws InvalidRecurrenceRuleException {
        if (value == null || value.size() == 0) {
            this.mParts.remove((Object)part);
        } else {
            switch (part) {
                case BYSECOND: 
                case BYMINUTE: 
                case BYHOUR: 
                case BYMONTHDAY: 
                case BYYEARDAY: 
                case BYWEEKNO: 
                case BYMONTH: 
                case BYSETPOS: {
                    this.validate(part, value);
                    this.mParts.put(part, value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(part.name() + " is not a list type");
                }
            }
        }
    }

    public void setByPart(Part part, Integer ... values) throws InvalidRecurrenceRuleException {
        if (values == null || values.length == 0) {
            this.mParts.remove((Object)part);
        } else {
            this.setByPart(part, Arrays.asList(values));
        }
    }

    public void setByDayPart(List<WeekdayNum> value) {
        if (value == null || value.size() == 0) {
            this.mParts.remove((Object)Part.BYDAY);
        }
        this.mParts.put(Part.BYDAY, value);
    }

    public List<WeekdayNum> getByDayPart() {
        return (List)this.mParts.get((Object)Part.BYDAY);
    }

    public Weekday getWeekStart() {
        Weekday wkst = (Weekday)this.mParts.get((Object)Part.WKST);
        return wkst == null ? Weekday.MO : wkst;
    }

    public void setWeekStart(Weekday wkst) {
        this.setWeekStart(wkst, false);
    }

    public void setWeekStart(Weekday wkst, boolean keepWkStMo) {
        if (wkst == Weekday.MO && !keepWkStMo) {
            this.mParts.remove((Object)Part.WKST);
        } else {
            this.mParts.put(Part.WKST, (Object)wkst);
        }
    }

    public void setXPart(String xname, String value) {
        if (this.mode == RfcMode.RFC5545_STRICT) {
            throw new UnsupportedOperationException("x-parts are not supported by RFC5545.");
        }
        if (value == null && this.mXParts == null || xname == null || this.mode == RfcMode.RFC5545_LAX) {
            return;
        }
        if (value == null) {
            if (this.mXParts.remove(xname) == null) {
                this.mXParts.remove(xname.toUpperCase(Locale.ENGLISH));
            }
        } else {
            if (xname.length() <= 2 || xname.charAt(0) != 'X' && xname.charAt(0) != 'x' || xname.charAt(1) != '-') {
                throw new IllegalArgumentException("invalid x-name: '" + xname + "'");
            }
            if (this.mXParts == null) {
                this.mXParts = new HashMap<String, String>(8);
            }
            this.mXParts.put(xname.toUpperCase(Locale.ENGLISH), value);
        }
    }

    public boolean hasXPart(String xname) {
        if (xname == null || this.mXParts == null || this.mode == RfcMode.RFC5545_LAX || this.mode == RfcMode.RFC5545_STRICT) {
            return false;
        }
        return this.mXParts.containsKey(xname) || this.mXParts.containsKey(xname.toUpperCase(Locale.ENGLISH));
    }

    public String getXPart(String xname) {
        if (xname == null || this.mXParts == null || this.mode == RfcMode.RFC5545_LAX || this.mode == RfcMode.RFC5545_STRICT) {
            return null;
        }
        String result = this.mXParts.get(xname);
        return result != null ? result : this.mXParts.get(xname.toUpperCase(Locale.ENGLISH));
    }

    public RecurrenceRuleIterator iterator(long start, TimeZone timezone) {
        DateTime dt = new DateTime(this.mCalendarMetrics, timezone, start);
        DateTime until = this.getUntil();
        if (until != null && until.isAllDay()) {
            dt = dt.toAllDay();
        }
        return this.iterator(dt);
    }

    public RecurrenceRuleIterator iterator(DateTime start) {
        RuleIterator iterator;
        CalendarMetrics rScaleCalendarMetrics;
        block11: {
            TimeZone startTimeZone;
            long startInstance;
            block9: {
                block10: {
                    DateTime until = this.getUntil();
                    if (until != null) {
                        if (until.isAllDay() != start.isAllDay()) {
                            throw new IllegalArgumentException("using allday start times with non-allday until values (and vice versa) is not allowed");
                        }
                        if (until.isFloating() != start.isFloating()) {
                            throw new IllegalArgumentException("using floating start times with absolute until values (and vice versa) is not allowed");
                        }
                    }
                    if ((rScaleCalendarMetrics = (CalendarMetrics)this.mParts.get((Object)Part.RSCALE)) == null) {
                        rScaleCalendarMetrics = new GregorianCalendarMetrics(this.getWeekStart(), 4);
                    }
                    startInstance = !rScaleCalendarMetrics.scaleEquals(start.getCalendarMetrics()) ? new DateTime(rScaleCalendarMetrics, start).getInstance() : start.getInstance();
                    iterator = FastBirthdayIterator.getInstance(this, rScaleCalendarMetrics, startInstance);
                    TimeZone timeZone = startTimeZone = start.isFloating() ? null : start.getTimeZone();
                    if (iterator == null) break block9;
                    iterator = new SanityFilter(iterator, rScaleCalendarMetrics, startInstance);
                    if (!this.hasPart(Part.UNTIL)) break block10;
                    iterator = Part.UNTIL.getExpander(this, iterator, rScaleCalendarMetrics, startInstance, startTimeZone);
                    break block11;
                }
                if (!this.hasPart(Part.COUNT)) break block11;
                iterator = Part.COUNT.getExpander(this, iterator, rScaleCalendarMetrics, startInstance, startTimeZone);
                break block11;
            }
            iterator = FastWeeklyIterator.getInstance(this, rScaleCalendarMetrics, startInstance);
            if (iterator != null) {
                if (this.hasPart(Part.UNTIL)) {
                    iterator = Part.UNTIL.getExpander(this, iterator, rScaleCalendarMetrics, startInstance, startTimeZone);
                }
            } else {
                this.mParts.put(Part._SANITY_FILTER, null);
                for (Part p : this.mParts.keySet()) {
                    if (p == Part.INTERVAL || p == Part.WKST || p == Part.RSCALE) continue;
                    if (p.expands(this)) {
                        RuleIterator newIterator = p.getExpander(this, iterator, rScaleCalendarMetrics, startInstance, startTimeZone);
                        iterator = newIterator == null ? iterator : newIterator;
                        continue;
                    }
                    ((ByExpander)iterator).addFilter(p.getFilter(this, rScaleCalendarMetrics));
                }
            }
        }
        return new RecurrenceRuleIterator(iterator, start, rScaleCalendarMetrics);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(160);
        boolean first = true;
        CalendarMetrics rscale = (CalendarMetrics)this.mParts.get((Object)Part.RSCALE);
        if (rscale == null) {
            rscale = DEFAULT_CALENDAR_SCALE;
        }
        for (Part part : Part.values()) {
            Object value;
            if (part == Part._BYMONTHDAYSKIP || part == Part._BYMONTHSKIP || part == Part._SANITY_FILTER || (value = this.mParts.get((Object)part)) == null) continue;
            if (first) {
                first = false;
            } else {
                result.append(";");
            }
            result.append(part.name());
            result.append("=");
            part.converter.serialize(result, value, rscale);
        }
        if ((this.mode == RfcMode.RFC2445_LAX || this.mode == RfcMode.RFC2445_STRICT) && this.mXParts != null && this.mXParts.size() != 0) {
            for (Map.Entry entry : this.mXParts.entrySet()) {
                result.append(";");
                result.append((String)entry.getKey());
                result.append("=");
                result.append((String)entry.getValue());
            }
        }
        return result.toString();
    }

    static /* synthetic */ ValueConverter access$500() {
        return ERROR_CONVERTER;
    }

    private static class SkipValueConverter
    extends ValueConverter<Skip> {
        private SkipValueConverter() {
        }

        @Override
        public Skip parse(String value, CalendarMetrics calScale, CalendarMetrics rScale, boolean tolerant) throws InvalidRecurrenceRuleException {
            try {
                return Skip.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidRecurrenceRuleException("Unknown SKIP value " + value);
            }
        }
    }

    private static class RScaleConverter
    extends ValueConverter<CalendarMetrics> {
        private RScaleConverter() {
        }

        @Override
        public CalendarMetrics parse(String value, CalendarMetrics calScale, CalendarMetrics rScale, boolean tolerant) throws InvalidRecurrenceRuleException {
            CalendarMetrics.CalendarMetricsFactory result = UnicodeCalendarScales.getCalendarMetricsForName(value);
            if (result == null) {
                throw new InvalidRecurrenceRuleException("unknown calendar scale '" + value + "'");
            }
            return result.getCalendarMetrics(Weekday.SU);
        }
    }

    private static class DateTimeConverter
    extends ValueConverter<DateTime> {
        private DateTimeConverter() {
        }

        @Override
        public DateTime parse(String value, CalendarMetrics calScale, CalendarMetrics rScale, boolean tolerant) throws InvalidRecurrenceRuleException {
            DateTime result = null;
            try {
                result = DateTime.parse((CalendarMetrics)calScale, (TimeZone)null, (String)value);
                return calScale.scaleEquals(rScale) ? result : new DateTime(rScale, result);
            }
            catch (Exception e) {
                if (tolerant && value != null && value.endsWith("ZZ")) {
                    try {
                        result = DateTime.parse((CalendarMetrics)calScale, null, (String)value.substring(0, value.length() - 1));
                        return calScale.scaleEquals(rScale) ? result : new DateTime(rScale, result);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                throw new InvalidRecurrenceRuleException("Invalid UNTIL date: " + value, e);
            }
        }
    }

    private static class FreqConverter
    extends ValueConverter<Freq> {
        private FreqConverter() {
        }

        @Override
        public Freq parse(String value, CalendarMetrics calScale, CalendarMetrics rScale, boolean tolerant) throws InvalidRecurrenceRuleException {
            try {
                return Freq.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidRecurrenceRuleException("Unknown FREQ value " + value);
            }
        }
    }

    private static class WeekdayConverter
    extends ValueConverter<Weekday> {
        private WeekdayConverter() {
        }

        @Override
        public Weekday parse(String value, CalendarMetrics calScale, CalendarMetrics rScale, boolean tolerant) throws InvalidRecurrenceRuleException {
            try {
                return Weekday.valueOf((String)value);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidRecurrenceRuleException("illegal weekday: " + value);
            }
        }
    }

    private static class WeekdayNumConverter
    extends ValueConverter<WeekdayNum> {
        private WeekdayNumConverter() {
        }

        @Override
        public WeekdayNum parse(String value, CalendarMetrics calScale, CalendarMetrics rScale, boolean tolerant) throws InvalidRecurrenceRuleException {
            return WeekdayNum.valueOf(value, tolerant);
        }
    }

    private static class IntegerConverter
    extends ValueConverter<Integer> {
        private final int mMinValue;
        private final int mMaxValue;
        private boolean mNoZero = false;

        public IntegerConverter(int min, int max) {
            this.mMaxValue = max;
            this.mMinValue = min;
        }

        public IntegerConverter noZero() {
            this.mNoZero = true;
            return this;
        }

        @Override
        public Integer parse(String value, CalendarMetrics calScale, CalendarMetrics rScale, boolean tolerant) throws InvalidRecurrenceRuleException {
            try {
                int val = Integer.parseInt(value);
                if (val < this.mMinValue || val > this.mMaxValue || this.mNoZero && val == 0) {
                    throw new InvalidRecurrenceRuleException("int value out of range: " + val);
                }
                return val;
            }
            catch (NumberFormatException e) {
                throw new InvalidRecurrenceRuleException("illegal int value: " + value);
            }
        }
    }

    private static class MonthConverter
    extends ValueConverter<Integer> {
        private MonthConverter() {
        }

        @Override
        public Integer parse(String value, CalendarMetrics calScale, CalendarMetrics rScale, boolean tolerant) throws InvalidRecurrenceRuleException {
            return rScale.packedMonth(value);
        }

        @Override
        public void serialize(StringBuilder out, Object value, CalendarMetrics rScale) {
            out.append(rScale.packedMonthToString(((Integer)value).intValue()));
        }
    }

    private static class ListValueConverter<T>
    extends ValueConverter<Collection<T>> {
        private final ValueConverter<T> mElementConverter;

        public ListValueConverter(ValueConverter<T> elementConverter) {
            this.mElementConverter = elementConverter;
        }

        @Override
        public Collection<T> parse(String value, CalendarMetrics calScale, CalendarMetrics rScale, boolean tolerant) throws InvalidRecurrenceRuleException {
            String[] values;
            ArrayList<T> result = new ArrayList<T>(32);
            for (String val : values = value.split(",")) {
                try {
                    result.add(this.mElementConverter.parse(val, calScale, rScale, tolerant));
                }
                catch (InvalidRecurrenceRuleException e) {
                    if (tolerant) continue;
                    throw e;
                }
                catch (Exception e) {
                    if (tolerant) continue;
                    throw new InvalidRecurrenceRuleException("could not parse list '" + value + "'", e);
                }
            }
            if (result.size() > 0) {
                return result;
            }
            throw new InvalidRecurrenceRuleException("empty lists are not allowed");
        }

        @Override
        public void serialize(StringBuilder out, Object value, CalendarMetrics rScale) {
            boolean first = true;
            for (Object v : (Collection)value) {
                if (first) {
                    first = false;
                } else {
                    out.append(",");
                }
                this.mElementConverter.serialize(out, v, rScale);
            }
        }
    }

    private static abstract class ValueConverter<T> {
        private ValueConverter() {
        }

        public abstract T parse(String var1, CalendarMetrics var2, CalendarMetrics var3, boolean var4) throws InvalidRecurrenceRuleException;

        public void serialize(StringBuilder out, Object value, CalendarMetrics rScale) {
            out.append(value.toString());
        }
    }

    public static class WeekdayNum {
        public final int pos;
        public final Weekday weekday;

        public WeekdayNum(int pos, Weekday weekday) {
            if (pos < -53 || pos > 53) {
                throw new IllegalArgumentException("position " + pos + " of week day out of range");
            }
            this.pos = pos;
            this.weekday = weekday;
        }

        public static WeekdayNum valueOf(String value, boolean tolerant) throws InvalidRecurrenceRuleException {
            try {
                int len = value.length();
                if (len > 2) {
                    int pos = Integer.parseInt(value.substring(value.charAt(0) == '+' ? 1 : 0, len - 2));
                    if (!(tolerant || pos != 0 && pos >= -53 && pos <= 53)) {
                        throw new InvalidRecurrenceRuleException("invalid weeknum: '" + value + "'");
                    }
                    return new WeekdayNum(pos, Weekday.valueOf((String)value.substring(len - 2)));
                }
                return new WeekdayNum(0, Weekday.valueOf((String)value));
            }
            catch (Exception e) {
                throw new InvalidRecurrenceRuleException("invalid weeknum: '" + value + "'", e);
            }
        }

        public static WeekdayNum valueOf(String value) throws InvalidRecurrenceRuleException {
            return WeekdayNum.valueOf(value, false);
        }

        public String toString() {
            return this.pos == 0 ? this.weekday.name() : Integer.valueOf(this.pos) + this.weekday.name();
        }
    }

    public static enum Part {
        FREQ((ValueConverter)new FreqConverter()){

            @Override
            RuleIterator getExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarMetrics, long start, TimeZone startTimeZone) {
                return new FreqIterator(rule, calendarMetrics, start);
            }

            @Override
            ByFilter getFilter(RecurrenceRule rule, CalendarMetrics calendarMetrics) throws UnsupportedOperationException {
                throw new UnsupportedOperationException("FREQ doesn't have a filter.");
            }

            @Override
            boolean expands(RecurrenceRule rule) {
                return true;
            }
        }
        ,
        INTERVAL((ValueConverter)new IntegerConverter(1, Integer.MAX_VALUE)){

            @Override
            RuleIterator getExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarMetrics, long start, TimeZone startTimeZone) {
                throw new UnsupportedOperationException("INTERVAL doesn't have an iterator.");
            }

            @Override
            ByFilter getFilter(RecurrenceRule rule, CalendarMetrics calendarMetrics) throws UnsupportedOperationException {
                throw new UnsupportedOperationException("INTERVAL doesn't have a filter.");
            }

            @Override
            boolean expands(RecurrenceRule rule) {
                throw new UnsupportedOperationException("INTERVAL doesn't support expansion nor filtering");
            }
        }
        ,
        RSCALE((ValueConverter)new RScaleConverter()){

            @Override
            RuleIterator getExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarMetrics, long start, TimeZone startTimeZone) throws UnsupportedOperationException {
                throw new UnsupportedOperationException("RSCALE doesn't have an expander.");
            }

            @Override
            ByFilter getFilter(RecurrenceRule rule, CalendarMetrics calendarMetrics) throws UnsupportedOperationException {
                throw new UnsupportedOperationException("RSCALE doesn't have a filter.");
            }

            @Override
            boolean expands(RecurrenceRule rule) {
                throw new UnsupportedOperationException("RSCALE doesn't support expansion nor filtering");
            }
        }
        ,
        WKST((ValueConverter)new WeekdayConverter()){

            @Override
            RuleIterator getExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarMetrics, long start, TimeZone startTimeZone) {
                throw new UnsupportedOperationException("WKST doesn't have an iterator.");
            }

            @Override
            ByFilter getFilter(RecurrenceRule rule, CalendarMetrics calendarMetrics) throws UnsupportedOperationException {
                throw new UnsupportedOperationException("WKST doesn't have a filter.");
            }

            @Override
            boolean expands(RecurrenceRule rule) {
                throw new UnsupportedOperationException("WKST doesn't support expansion nor filtering.");
            }
        }
        ,
        BYMONTH(new ListValueConverter<Integer>(new MonthConverter())){

            @Override
            RuleIterator getExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarMetrics, long start, TimeZone startTimeZone) {
                return new ByMonthExpander(rule, previous, calendarMetrics, start);
            }

            @Override
            ByFilter getFilter(RecurrenceRule rule, CalendarMetrics calendarMetrics) throws UnsupportedOperationException {
                if (rule.getFreq() == Freq.WEEKLY && (rule.hasPart(BYDAY) || rule.hasPart(BYMONTHDAY) || rule.hasPart(BYYEARDAY))) {
                    return new ByMonthFilter(rule, calendarMetrics);
                }
                return new TrivialByMonthFilter(rule);
            }

            @Override
            boolean expands(RecurrenceRule rule) {
                return rule.getFreq() == Freq.YEARLY;
            }
        }
        ,
        _BYMONTHSKIP(RecurrenceRule.access$500()){

            @Override
            RuleIterator getExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarMetrics, long start, TimeZone startTimeZone) throws UnsupportedOperationException {
                return new ByMonthSkipFilter(rule, previous, calendarMetrics, start);
            }

            @Override
            ByFilter getFilter(RecurrenceRule rule, CalendarMetrics calendarMetrics) throws UnsupportedOperationException {
                throw new UnsupportedOperationException("_BYMONTHSKIP doesn't support  filtering");
            }

            @Override
            boolean expands(RecurrenceRule rule) {
                return true;
            }
        }
        ,
        BYWEEKNO(new ListValueConverter<Integer>(new IntegerConverter(-53, 53).noZero())){

            @Override
            RuleIterator getExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarTools, long start, TimeZone startTimeZone) {
                return new ByWeekNoExpander(rule, previous, calendarTools, start);
            }

            @Override
            ByFilter getFilter(RecurrenceRule rule, CalendarMetrics calendarMetrics) throws UnsupportedOperationException {
                return null;
            }

            @Override
            boolean expands(RecurrenceRule rule) {
                return true;
            }
        }
        ,
        BYYEARDAY(new ListValueConverter<Integer>(new IntegerConverter(-366, 366).noZero())){

            @Override
            RuleIterator getExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarMetrics, long start, TimeZone startTimeZone) {
                return new ByYearDayExpander(rule, previous, calendarMetrics, start);
            }

            @Override
            ByFilter getFilter(RecurrenceRule rule, CalendarMetrics calendarMetrics) throws UnsupportedOperationException {
                return new ByYearDayFilter(rule, calendarMetrics);
            }

            @Override
            boolean expands(RecurrenceRule rule) {
                Freq freq = rule.getFreq();
                return freq == Freq.YEARLY || freq == Freq.MONTHLY || freq == Freq.WEEKLY;
            }
        }
        ,
        BYMONTHDAY(new ListValueConverter<Integer>(new IntegerConverter(-31, 31).noZero())){

            @Override
            RuleIterator getExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarMetrics, long start, TimeZone startTimeZone) {
                return new ByMonthDayExpander(rule, previous, calendarMetrics, start);
            }

            @Override
            ByFilter getFilter(RecurrenceRule rule, CalendarMetrics calendarMetrics) throws UnsupportedOperationException {
                return new ByMonthDayFilter(rule, calendarMetrics);
            }

            @Override
            boolean expands(RecurrenceRule rule) {
                Freq freq = rule.getFreq();
                return (freq == Freq.YEARLY || freq == Freq.MONTHLY || freq == Freq.WEEKLY) && !rule.hasPart(BYYEARDAY);
            }
        }
        ,
        _BYMONTHDAYSKIP(RecurrenceRule.access$500()){

            @Override
            RuleIterator getExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarMetrics, long start, TimeZone startTimeZone) throws UnsupportedOperationException {
                return new ByMonthDaySkipFilter(rule, previous, calendarMetrics, start);
            }

            @Override
            ByFilter getFilter(RecurrenceRule rule, CalendarMetrics calendarMetrics) throws UnsupportedOperationException {
                throw new UnsupportedOperationException("_BYMONTHDAYSKIP doesn't support filtering");
            }

            @Override
            boolean expands(RecurrenceRule rule) {
                return true;
            }
        }
        ,
        BYDAY(new ListValueConverter<WeekdayNum>(new WeekdayNumConverter())){

            @Override
            RuleIterator getExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarMetrics, long start, TimeZone startTimeZone) {
                return new ByDayExpander(rule, previous, calendarMetrics, start);
            }

            @Override
            ByFilter getFilter(RecurrenceRule rule, CalendarMetrics calendarMetrics) throws UnsupportedOperationException {
                return new ByDayFilter(rule, calendarMetrics);
            }

            @Override
            boolean expands(RecurrenceRule rule) {
                Freq freq = rule.getFreq();
                return (freq == Freq.YEARLY || freq == Freq.MONTHLY) && !rule.hasPart(BYYEARDAY) && !rule.hasPart(BYMONTHDAY) || freq == Freq.WEEKLY;
            }
        }
        ,
        BYHOUR(new ListValueConverter<Integer>(new IntegerConverter(0, 23))){

            @Override
            RuleIterator getExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarTools, long start, TimeZone startTimeZone) {
                return new ByHourExpander(rule, previous, calendarTools, start);
            }

            @Override
            ByFilter getFilter(RecurrenceRule rule, CalendarMetrics calendarMetrics) throws UnsupportedOperationException {
                return new ByHourFilter(rule);
            }

            @Override
            boolean expands(RecurrenceRule rule) {
                Freq freq = rule.getFreq();
                return freq != Freq.SECONDLY && freq != Freq.MINUTELY && freq != Freq.HOURLY;
            }
        }
        ,
        BYMINUTE(new ListValueConverter<Integer>(new IntegerConverter(0, 59))){

            @Override
            RuleIterator getExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarTools, long start, TimeZone startTimeZone) {
                return new ByMinuteExpander(rule, previous, calendarTools, start);
            }

            @Override
            ByFilter getFilter(RecurrenceRule rule, CalendarMetrics calendarMetrics) throws UnsupportedOperationException {
                return new ByMinuteFilter(rule);
            }

            @Override
            boolean expands(RecurrenceRule rule) {
                Freq freq = rule.getFreq();
                return freq != Freq.SECONDLY && freq != Freq.MINUTELY;
            }
        }
        ,
        BYSECOND(new ListValueConverter<Integer>(new IntegerConverter(0, 60))){

            @Override
            RuleIterator getExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarTools, long start, TimeZone startTimeZone) {
                return new BySecondExpander(rule, previous, calendarTools, start);
            }

            @Override
            ByFilter getFilter(RecurrenceRule rule, CalendarMetrics calendarMetrics) throws UnsupportedOperationException {
                return new BySecondFilter(rule);
            }

            @Override
            boolean expands(RecurrenceRule rule) {
                return rule.getFreq() != Freq.SECONDLY;
            }
        }
        ,
        SKIP((ValueConverter)new SkipValueConverter()){

            @Override
            RuleIterator getExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarMetrics, long start, TimeZone startTimeZone) {
                if (rule.getFreq() == Freq.YEARLY && rule.getSkip() == Skip.FORWARD) {
                    return new SkipBuffer(rule, previous, calendarMetrics);
                }
                return null;
            }

            @Override
            ByFilter getFilter(RecurrenceRule rule, CalendarMetrics calendarMetrics) throws UnsupportedOperationException {
                throw new UnsupportedOperationException("SKIP doesn't support  filtering");
            }

            @Override
            boolean expands(RecurrenceRule rule) {
                return true;
            }
        }
        ,
        _SANITY_FILTER(RecurrenceRule.access$500()){

            @Override
            RuleIterator getExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarMetrics, long start, TimeZone startTimeZone) throws UnsupportedOperationException {
                return new SanityFilter(previous, calendarMetrics, start);
            }

            @Override
            ByFilter getFilter(RecurrenceRule rule, CalendarMetrics calendarMetrics) throws UnsupportedOperationException {
                throw new UnsupportedOperationException("_SANITY doesn't support filtering");
            }

            @Override
            boolean expands(RecurrenceRule rule) {
                return true;
            }
        }
        ,
        BYSETPOS(new ListValueConverter<Integer>(new IntegerConverter(-500, 500).noZero())){

            @Override
            RuleIterator getExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarTools, long start, TimeZone startTimeZone) {
                return new BySetPosFilter(rule, previous, start);
            }

            @Override
            ByFilter getFilter(RecurrenceRule rule, CalendarMetrics calendarMetrics) throws UnsupportedOperationException {
                throw new UnsupportedOperationException("BYSETPOS doesn't support  filtering");
            }

            @Override
            boolean expands(RecurrenceRule rule) {
                return true;
            }
        }
        ,
        UNTIL((ValueConverter)new DateTimeConverter()){

            @Override
            RuleIterator getExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarMetrics, long start, TimeZone startTimeZone) {
                return new UntilLimiter(rule, previous, calendarMetrics, startTimeZone);
            }

            @Override
            ByFilter getFilter(RecurrenceRule rule, CalendarMetrics calendarMetrics) throws UnsupportedOperationException {
                throw new UnsupportedOperationException("UNTIL doesn't support filtering");
            }

            @Override
            boolean expands(RecurrenceRule rule) {
                return true;
            }
        }
        ,
        COUNT((ValueConverter)new IntegerConverter(1, Integer.MAX_VALUE)){

            @Override
            RuleIterator getExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarTools, long start, TimeZone startTimeZone) {
                return new CountLimiter(rule, previous);
            }

            @Override
            ByFilter getFilter(RecurrenceRule rule, CalendarMetrics calendarMetrics) throws UnsupportedOperationException {
                throw new UnsupportedOperationException("COUNT doesn't support  filtering");
            }

            @Override
            boolean expands(RecurrenceRule rule) {
                return true;
            }
        };

        final ValueConverter<?> converter;

        private Part(ValueConverter<?> converter) {
            this.converter = converter;
        }

        abstract RuleIterator getExpander(RecurrenceRule var1, RuleIterator var2, CalendarMetrics var3, long var4, TimeZone var6) throws UnsupportedOperationException;

        abstract ByFilter getFilter(RecurrenceRule var1, CalendarMetrics var2) throws UnsupportedOperationException;

        abstract boolean expands(RecurrenceRule var1);
    }

    public static enum Skip {
        OMIT,
        BACKWARD,
        FORWARD;

    }

    public static enum RfcMode {
        RFC2445_STRICT,
        RFC2445_LAX,
        RFC5545_STRICT,
        RFC5545_LAX;

    }
}

