/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import java.util.List;
import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByExpander;
import org.dmfs.rfc5545.recur.Freq;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.RuleIterator;
import org.dmfs.rfc5545.recur.StaticUtils;

final class ByDayExpander
extends ByExpander {
    private final int[] mByDay;
    private final ByExpander.Scope mScope;
    private final int[] mMonths;

    private static int packWeekday(int pos, int day) {
        return (pos << 8) + day;
    }

    private static int unpackWeekday(int packedDay) {
        return packedDay & 0xFF;
    }

    private static int unpackPos(int packedDay) {
        return packedDay >> 8;
    }

    public ByDayExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarTools, long start) {
        super(previous, calendarTools, start);
        List<RecurrenceRule.WeekdayNum> byDay = rule.getByDayPart();
        this.mByDay = new int[byDay.size()];
        int l = byDay.size();
        for (int i = 0; i < l; ++i) {
            RecurrenceRule.WeekdayNum weekdayNum = byDay.get(i);
            this.mByDay[i] = ByDayExpander.packWeekday(weekdayNum.pos, weekdayNum.weekday.ordinal());
        }
        boolean hasByMonth = rule.hasPart(RecurrenceRule.Part.BYMONTH);
        Freq freq = rule.getFreq();
        this.mScope = rule.hasPart(RecurrenceRule.Part.BYWEEKNO) || freq == Freq.WEEKLY ? (hasByMonth || freq == Freq.MONTHLY ? ByExpander.Scope.WEEKLY_AND_MONTHLY : ByExpander.Scope.WEEKLY) : (hasByMonth || freq == Freq.MONTHLY ? ByExpander.Scope.MONTHLY : ByExpander.Scope.YEARLY);
        this.mMonths = (int[])(this.mScope == ByExpander.Scope.WEEKLY_AND_MONTHLY && hasByMonth ? StaticUtils.ListToArray(rule.getByPart(RecurrenceRule.Part.BYMONTH)) : null);
    }

    @Override
    void expand(long instance, long start) {
        CalendarMetrics calendarMetrics = this.mCalendarMetrics;
        int year = Instance.year((long)instance);
        int month = Instance.month((long)instance);
        block6: for (int packedDay : this.mByDay) {
            int pos = ByDayExpander.unpackPos(packedDay);
            int day = ByDayExpander.unpackWeekday(packedDay);
            switch (this.mScope) {
                case WEEKLY: {
                    if (pos != 0 && pos != 1) continue block6;
                    this.addInstance(calendarMetrics.setDayOfWeek(instance, day));
                    continue block6;
                }
                case WEEKLY_AND_MONTHLY: {
                    if (pos != 0 && pos != 1) continue block6;
                    long newInstance = calendarMetrics.setDayOfWeek(instance, day);
                    int newMonth = Instance.month((long)newInstance);
                    if ((this.mMonths == null || StaticUtils.linearSearch(this.mMonths, newMonth) < 0) && (this.mMonths != null || newMonth != month)) continue block6;
                    this.addInstance(newInstance);
                    continue block6;
                }
                case MONTHLY: {
                    int weekDayOfFirstInMonth = calendarMetrics.getDayOfWeek(year, month, 1);
                    int monthDays = calendarMetrics.getDaysPerPackedMonth(year, month);
                    int firstDay = (day - weekDayOfFirstInMonth + 7) % 7 + 1;
                    if (pos == 0) {
                        for (int dayOfMonth = firstDay; dayOfMonth <= monthDays; dayOfMonth += 7) {
                            this.addInstance(Instance.setDayOfMonth((long)instance, (int)dayOfMonth));
                        }
                        continue block6;
                    }
                    int maxPos = 1 + (monthDays - firstDay) / 7;
                    if ((pos <= 0 || pos > maxPos) && (pos >= 0 || pos + maxPos + 1 <= 0)) continue block6;
                    this.addInstance(Instance.setDayOfMonth((long)instance, (int)(firstDay + (pos > 0 ? pos - 1 : pos + maxPos) * 7)));
                    continue block6;
                }
                case YEARLY: {
                    int dayOfYear;
                    int monthAndDay;
                    int dayOfYear2;
                    int firstWeekdayOfYear = (day - calendarMetrics.getWeekDayOfFirstYearDay(year) + 7) % 7 + 1;
                    int yearDays = calendarMetrics.getDaysPerYear(year);
                    if (pos == 0) {
                        for (dayOfYear2 = firstWeekdayOfYear; dayOfYear2 <= yearDays; dayOfYear2 += 7) {
                            monthAndDay = calendarMetrics.getMonthAndDayOfYearDay(year, dayOfYear2);
                            this.addInstance(Instance.setMonthAndDayOfMonth((long)instance, (int)CalendarMetrics.packedMonth((int)monthAndDay), (int)CalendarMetrics.dayOfMonth((int)monthAndDay)));
                        }
                        continue block6;
                    }
                    if (pos > 0) {
                        dayOfYear2 = firstWeekdayOfYear + (pos - 1) * 7;
                        if (dayOfYear2 > yearDays) continue block6;
                        monthAndDay = calendarMetrics.getMonthAndDayOfYearDay(year, dayOfYear2);
                        this.addInstance(Instance.setMonthAndDayOfMonth((long)instance, (int)CalendarMetrics.packedMonth((int)monthAndDay), (int)CalendarMetrics.dayOfMonth((int)monthAndDay)));
                        continue block6;
                    }
                    int lastWeekdayOfYear = firstWeekdayOfYear + yearDays - yearDays % 7;
                    if (lastWeekdayOfYear > yearDays) {
                        lastWeekdayOfYear -= 7;
                    }
                    if ((dayOfYear = lastWeekdayOfYear + (pos + 1) * 7) <= 0) continue block6;
                    int monthAndDay2 = calendarMetrics.getMonthAndDayOfYearDay(year, dayOfYear);
                    this.addInstance(Instance.setMonthAndDayOfMonth((long)instance, (int)CalendarMetrics.packedMonth((int)monthAndDay2), (int)CalendarMetrics.dayOfMonth((int)monthAndDay2)));
                    continue block6;
                }
            }
        }
    }
}

