/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.parser;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import net.minidev.json.parser.ContainerFactory;
import net.minidev.json.parser.JSONParserBase;
import net.minidev.json.parser.ParseException;

public class JSONParser
extends JSONParserBase {
    public static final byte EOI = 26;
    private char c;
    private String in;
    private int len;

    public JSONParser() {
        super(-1);
    }

    public JSONParser(int permissiveMode) {
        super(permissiveMode);
    }

    public Object parse(String in) throws ParseException, IOException {
        return this.parse(in, ContainerFactory.FACTORY);
    }

    public Object parse(String in, ContainerFactory containerFactory) throws ParseException, IOException {
        this.len = in.length();
        this.in = in;
        this.containerFactory = containerFactory;
        this.pos = -1;
        this.read();
        this.handler.startJSON();
        Object result = this.readMain(stopX);
        this.handler.endJSON();
        this.xs = null;
        this.xo = null;
        return result;
    }

    private final void read() {
        this.c = ++this.pos >= this.len ? (char)26 : this.in.charAt(this.pos);
    }

    private List<Object> readArray() throws ParseException, IOException {
        List<Object> obj = this.containerFactory.creatArrayContainer();
        if (this.c != '[') {
            throw new RuntimeException("Internal Error");
        }
        this.read();
        this.handler.startArray();
        block7: while (true) {
            switch (this.c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.read();
                    continue block7;
                }
                case ']': {
                    this.read();
                    this.handler.endArray();
                    return obj;
                }
                case ':': 
                case '}': {
                    throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                }
                case ',': {
                    this.read();
                    continue block7;
                }
                case '\u001a': {
                    throw new ParseException(this.pos - 1, 3, "EOF");
                }
            }
            obj.add(this.readMain(stopArray));
        }
    }

    private Object readMain(boolean[] stop) throws ParseException, IOException {
        block12: while (true) {
            switch (this.c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.read();
                    continue block12;
                }
                case ':': 
                case ']': 
                case '}': {
                    throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                }
                case '{': {
                    return this.readObject();
                }
                case '[': {
                    return this.readArray();
                }
                case '\"': 
                case '\'': {
                    this.xs = this.readString();
                    this.handler.primitive(this.xs);
                    return this.xs;
                }
                case 'n': {
                    this.xs = this.readNQString(stop);
                    if ("null".equals(this.xs)) {
                        this.handler.primitive(null);
                        return null;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    this.handler.primitive(this.xs);
                    return this.xs;
                }
                case 'f': {
                    this.xs = this.readNQString(stop);
                    if ("false".equals(this.xs)) {
                        this.handler.primitive(Boolean.FALSE);
                        return Boolean.FALSE;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    this.handler.primitive(this.xs);
                    return this.xs;
                }
                case 't': {
                    this.xs = this.readNQString(stop);
                    if ("true".equals(this.xs)) {
                        this.handler.primitive(Boolean.TRUE);
                        return Boolean.TRUE;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    this.handler.primitive(this.xs);
                    return this.xs;
                }
                case 'N': {
                    this.xs = this.readNQString(stop);
                    if (!this.acceptNaN) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    if ("NaN".equals(this.xs)) {
                        this.handler.primitive(Float.valueOf(Float.NaN));
                        return Float.valueOf(Float.NaN);
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    this.handler.primitive(this.xs);
                    return this.xs;
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.xo = this.readNumber(stop);
                    this.handler.primitive(this.xo);
                    return this.xo;
                }
            }
            break;
        }
        this.xs = this.readNQString(stop);
        if (!this.acceptNonQuote) {
            throw new ParseException(this.pos, 1, this.xs);
        }
        this.handler.primitive(this.xs);
        return this.xs;
    }

    private String readNQString(boolean[] stop) {
        int start = this.pos;
        this.skipNQString(stop);
        return this.in.substring(start, this.pos).trim();
    }

    private Object readNumber(boolean[] stop) throws ParseException {
        int start = this.pos;
        this.read();
        this.skipDigits();
        if (this.c != '.' && this.c != 'E' && this.c != 'e') {
            this.skipSpace();
            if (!stop[this.c]) {
                this.skipNQString(stop);
                this.xs = this.in.substring(start, this.pos).trim();
                if (!this.acceptNonQuote) {
                    throw new ParseException(this.pos, 1, this.xs);
                }
                return this.xs;
            }
            this.xs = this.in.substring(start, this.pos).trim();
            if (this.xs.length() > 20) {
                return new BigInteger(this.xs);
            }
            try {
                long v = Long.parseLong(this.xs);
                if (v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE) {
                    return (int)v;
                }
                return v;
            }
            catch (NumberFormatException e) {
                return new BigInteger(this.xs);
            }
        }
        if (this.c == '.') {
            this.read();
            this.skipDigits();
        }
        if (this.c != 'E' && this.c != 'e') {
            this.skipSpace();
            if (!stop[this.c]) {
                this.skipNQString(stop);
                this.xs = this.in.substring(start, this.pos).trim();
                if (!this.acceptNonQuote) {
                    throw new ParseException(this.pos, 1, this.xs);
                }
                return this.xs;
            }
            String num = this.in.substring(start, this.pos).trim();
            return Double.parseDouble(num);
        }
        this.sb.append('E');
        this.read();
        if (this.c == '+' || this.c == '-' || this.c >= '0' && this.c <= '9') {
            this.sb.append(this.c);
            this.read();
            this.skipDigits();
            this.skipSpace();
            if (!stop[this.c]) {
                this.skipNQString(stop);
                String text = this.in.substring(start, this.pos).trim();
                if (!this.acceptNonQuote) {
                    throw new ParseException(this.pos, 1, text);
                }
                return text;
            }
            return Double.parseDouble(this.in.substring(start, this.pos).trim());
        }
        this.skipNQString(stop);
        String text = this.in.substring(start, this.pos).trim();
        if (!this.acceptNonQuote) {
            throw new ParseException(this.pos, 1, text);
        }
        return text;
    }

    private Map<String, Object> readObject() throws ParseException, IOException {
        Map<String, Object> obj = this.containerFactory.createObjectContainer();
        if (this.c != '{') {
            throw new RuntimeException("Internal Error");
        }
        this.handler.startObject();
        block6: while (true) {
            String key;
            this.read();
            switch (this.c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block6;
                }
                case ':': 
                case '[': 
                case ']': 
                case '{': {
                    throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                }
                case '}': {
                    this.read();
                    this.handler.endObject();
                    return obj;
                }
                case ',': {
                    continue block6;
                }
            }
            if (this.c == '\"' || this.c == '\'') {
                key = this.readString();
            } else {
                key = this.readNQString(stopKey);
                if (!this.acceptNonQuote) {
                    throw new ParseException(this.pos, 1, key);
                }
            }
            this.handler.startObjectEntry(key);
            while (this.c != ':' && this.c != '\u001a') {
                this.read();
            }
            if (this.c == '\u001a') {
                throw new ParseException(this.pos - 1, 3, null);
            }
            this.read();
            obj.put(key, this.readMain(stopValue));
            this.handler.endObjectEntry();
            if (this.c == '}') break;
        }
        this.read();
        this.handler.endObject();
        return obj;
    }

    private String readString() throws ParseException, IOException {
        if (!this.acceptSimpleQuote && this.c == '\'') {
            throw new ParseException(this.pos, 0, Character.valueOf(this.c));
        }
        int tmpP = this.in.indexOf(this.c, this.pos + 1);
        if (tmpP == -1) {
            throw new ParseException(this.in.length(), 3, null);
        }
        this.xs = this.in.substring(this.pos + 1, tmpP);
        if (this.xs.indexOf(92) == -1) {
            this.pos = tmpP;
            this.read();
            return this.xs;
        }
        this.sb.clear();
        char sep = this.c;
        block18: while (true) {
            this.read();
            switch (this.c) {
                case '\u001a': {
                    throw new ParseException(this.pos - 1, 3, null);
                }
                case '\"': 
                case '\'': {
                    if (sep == this.c) {
                        this.read();
                        return this.sb.toString();
                    }
                    this.sb.append(this.c);
                    continue block18;
                }
                case '\\': {
                    this.read();
                    switch (this.c) {
                        case 't': {
                            this.sb.append('\t');
                            continue block18;
                        }
                        case 'n': {
                            this.sb.append('\n');
                            continue block18;
                        }
                        case 'r': {
                            this.sb.append('\r');
                            continue block18;
                        }
                        case 'f': {
                            this.sb.append('\f');
                            continue block18;
                        }
                        case 'b': {
                            this.sb.append('\b');
                            continue block18;
                        }
                        case '\\': {
                            this.sb.append('\\');
                            continue block18;
                        }
                        case '/': {
                            this.sb.append('/');
                            continue block18;
                        }
                        case '\'': {
                            this.sb.append('\'');
                            continue block18;
                        }
                        case '\"': {
                            this.sb.append('\"');
                            continue block18;
                        }
                        case 'u': {
                            this.sb.append(this.readUnicode());
                            continue block18;
                        }
                    }
                    continue block18;
                }
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': {
                    continue block18;
                }
            }
            this.sb.append(this.c);
        }
    }

    private char readUnicode() throws ParseException {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value *= 16;
            this.read();
            if (this.c >= '0' && this.c <= '9') {
                value += this.c - 48;
                continue;
            }
            if (this.c >= 'A' && this.c <= 'F') {
                value += this.c - 65 + 10;
                continue;
            }
            if (this.c >= 'a' && this.c <= 'f') {
                value += this.c - 97 + 10;
                continue;
            }
            if (this.c == '\u001a') {
                throw new ParseException(this.pos, 3, "EOF");
            }
            throw new ParseException(this.pos, 4, Character.valueOf(this.c));
        }
        return (char)value;
    }

    private void skipDigits() {
        while (this.c != '\u001a') {
            if (this.c < '0' || this.c > '9') {
                return;
            }
            this.read();
        }
        return;
    }

    private void skipNQString(boolean[] stop) {
        while (this.c != '\u001a') {
            if (this.c >= '\u0000' && this.c <= '}' && stop[this.c]) {
                return;
            }
            this.read();
        }
        return;
    }

    private void skipSpace() throws ParseException {
        while (this.c != '\u001a') {
            if (this.c != ' ' && this.c != '\r' && this.c != '\t' && this.c != '\n') {
                return;
            }
            this.read();
        }
        return;
    }
}

