/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.aac;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.Decoder;
import net.sourceforge.jaad.aac.SampleBuffer;
import org.jcodec.codecs.aac.AACUtils;
import org.jcodec.codecs.aac.ADTSParser;
import org.jcodec.common.AudioCodecMeta;
import org.jcodec.common.AudioDecoder;
import org.jcodec.common.AudioFormat;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.logging.Logger;
import org.jcodec.common.model.AudioBuffer;

public class AACDecoder
implements AudioDecoder {
    private Decoder decoder;

    public AACDecoder(ByteBuffer decoderSpecific) throws AACException {
        if (decoderSpecific.remaining() >= 7) {
            ADTSParser.Header header = ADTSParser.read(decoderSpecific);
            if (header != null) {
                decoderSpecific = AACUtils.adtsToStreamInfo(header);
            }
            Logger.info("Creating AAC decoder from ADTS header.");
        }
        this.decoder = new Decoder(NIOUtils.toArray(decoderSpecific));
    }

    @Override
    public AudioBuffer decodeFrame(ByteBuffer frame, ByteBuffer dst) throws IOException {
        ADTSParser.read(frame);
        SampleBuffer sampleBuffer = new SampleBuffer();
        this.decoder.decodeFrame(NIOUtils.toArray(frame), sampleBuffer);
        if (sampleBuffer.isBigEndian()) {
            sampleBuffer.setBigEndian(false);
        }
        return new AudioBuffer(ByteBuffer.wrap(sampleBuffer.getData()), this.toAudioFormat(sampleBuffer), 0);
    }

    private AudioFormat toAudioFormat(SampleBuffer sampleBuffer) {
        return new AudioFormat(sampleBuffer.getSampleRate(), sampleBuffer.getBitsPerSample(), sampleBuffer.getChannels(), true, sampleBuffer.isBigEndian());
    }

    @Override
    public AudioCodecMeta getCodecMeta(ByteBuffer data) throws IOException {
        SampleBuffer sampleBuffer = new SampleBuffer();
        this.decoder.decodeFrame(NIOUtils.toArray(data), sampleBuffer);
        sampleBuffer.setBigEndian(false);
        return AudioCodecMeta.fromAudioFormat(this.toAudioFormat(sampleBuffer));
    }

    public static int probe(ByteBuffer data) {
        if (data.remaining() < 7) {
            return 0;
        }
        ADTSParser.Header header = ADTSParser.read(data);
        if (header != null) {
            return 100;
        }
        return 0;
    }
}

