/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.lastsplits;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class CircularList<T>
extends AbstractList<T> {
    private final T[] elements;
    private int lastIndex;
    private int firstIndex = -1;
    private int size;

    public CircularList(int capacity) {
        this.elements = new Object[capacity];
    }

    public int getCapacity() {
        return this.elements.length;
    }

    private int convertIndex(int index) {
        return (this.lastIndex + index) % this.elements.length;
    }

    @Override
    public T get(int index) {
        return this.elements[this.convertIndex(index)];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private int incrementIndex(int index, int maxIndex) {
        int newIndex = index + 1;
        if (newIndex >= this.elements.length) {
            newIndex = maxIndex;
        }
        return newIndex;
    }

    @Override
    public boolean add(T newElement) {
        this.elements[this.lastIndex] = newElement;
        this.lastIndex = this.incrementIndex(this.lastIndex, 0);
        if (this.isEmpty()) {
            this.firstIndex = 0;
            this.size = 1;
        } else if (this.isFull()) {
            this.firstIndex = this.lastIndex;
        } else {
            this.size = this.incrementIndex(this.size, this.elements.length);
        }
        return true;
    }

    private boolean isFull() {
        return this.size == this.elements.length;
    }

    @Override
    public boolean addAll(Collection<? extends T> newElements) {
        for (T newElement : newElements) {
            this.add(newElement);
        }
        return true;
    }

    @Override
    public T removeFirst() {
        if (this.isEmpty()) {
            return null;
        }
        T firstElement = this.elements[this.firstIndex];
        this.elements[this.firstIndex] = null;
        this.firstIndex = this.incrementIndex(this.firstIndex, 0);
        return firstElement;
    }

    public T first() {
        return this.isEmpty() ? null : (T)this.elements[this.lastIndex];
    }

    public T last() {
        return this.isEmpty() ? null : (T)this.elements[this.lastIndex];
    }

    @Override
    public void clear() {
        Arrays.fill(this.elements, null);
        this.lastIndex = 0;
        this.firstIndex = -1;
        this.size = 0;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.isEmpty()) {
            return new EmptyIterator();
        }
        return new MainIterator();
    }

    private <X> void copy(X[] elementsCopy) {
        if (!this.isEmpty()) {
            if (this.firstIndex < this.lastIndex) {
                System.arraycopy(this.elements, this.firstIndex, elementsCopy, 0, this.lastIndex - this.firstIndex);
            } else {
                int firstSize = this.elements.length - this.firstIndex;
                System.arraycopy(this.elements, this.firstIndex, elementsCopy, 0, firstSize);
                System.arraycopy(this.elements, 0, elementsCopy, firstSize, this.lastIndex);
            }
        }
    }

    @Override
    public Object[] toArray() {
        Object[] elementsCopy = new Object[this.size];
        this.copy(elementsCopy);
        return elementsCopy;
    }

    @Override
    public <T> T[] toArray(T[] elementsCopy) {
        if (elementsCopy.length >= this.size) {
            this.copy(elementsCopy);
            return elementsCopy;
        }
        return this.toArray();
    }

    private class MainIterator
    implements Iterator<T> {
        private int nextIndex;
        private boolean begin;

        private MainIterator() {
            this.nextIndex = CircularList.this.firstIndex;
            this.begin = true;
        }

        @Override
        public boolean hasNext() {
            return this.begin || this.nextIndex != CircularList.this.lastIndex;
        }

        @Override
        public T next() {
            Object nextElement = CircularList.this.elements[this.nextIndex];
            this.begin = false;
            this.nextIndex = CircularList.this.incrementIndex(this.nextIndex, 0);
            return nextElement;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    private class EmptyIterator
    implements Iterator<T> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

