/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.iso.Types;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.identification.KeywordType;
import org.opengis.metadata.identification.Keywords;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Keywords_Type", propOrder={"keywords", "type", "thesaurusName"})
@XmlRootElement(name="MD_Keywords")
public class DefaultKeywords
extends ISOMetadata
implements Keywords {
    private static final long serialVersionUID = -2765705888428016211L;
    private Collection<InternationalString> keywords;
    private KeywordType type;
    private Citation thesaurusName;
    private CodeList<?> keywordClass;

    public DefaultKeywords() {
    }

    public DefaultKeywords(CharSequence ... charSequenceArray) {
        if (charSequenceArray != null) {
            for (CharSequence charSequence : charSequenceArray) {
                InternationalString internationalString = Types.toInternationalString(charSequence);
                if (this.keywords == null) {
                    this.keywords = this.singleton(internationalString, InternationalString.class);
                    continue;
                }
                this.keywords.add(internationalString);
            }
        }
    }

    public DefaultKeywords(Keywords keywords) {
        super(keywords);
        if (keywords != null) {
            this.keywords = this.copyCollection(keywords.getKeywords(), InternationalString.class);
            this.type = keywords.getType();
            this.thesaurusName = keywords.getThesaurusName();
        }
    }

    public static DefaultKeywords castOrCopy(Keywords keywords) {
        if (keywords == null || keywords instanceof DefaultKeywords) {
            return (DefaultKeywords)keywords;
        }
        return new DefaultKeywords(keywords);
    }

    @XmlElement(name="keyword", required=true)
    public Collection<InternationalString> getKeywords() {
        this.keywords = this.nonNullCollection(this.keywords, InternationalString.class);
        return this.keywords;
    }

    public void setKeywords(Collection<? extends InternationalString> collection) {
        this.keywords = this.writeCollection(collection, this.keywords, InternationalString.class);
    }

    @Override
    @XmlElement(name="type")
    public KeywordType getType() {
        return this.type;
    }

    public void setType(KeywordType keywordType) {
        this.checkWritePermission();
        this.type = keywordType;
    }

    @Override
    @XmlElement(name="thesaurusName")
    public Citation getThesaurusName() {
        return this.thesaurusName;
    }

    public void setThesaurusName(Citation citation) {
        this.checkWritePermission();
        this.thesaurusName = citation;
    }

    @UML(identifier="keywordClass", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public CodeList<?> getKeywordClass() {
        return this.keywordClass;
    }

    public void setKeywordClass(CodeList<?> codeList) {
        this.checkWritePermission();
        this.keywordClass = codeList;
    }
}

