/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.CharArrayWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ApnsPayloadBuilder {
    private String alertBody = null;
    private String localizedAlertKey = null;
    private String[] localizedAlertArguments = null;
    private String alertTitle = null;
    private String localizedAlertTitleKey = null;
    private String[] localizedAlertTitleArguments = null;
    private String alertSubtitle = null;
    private String localizedAlertSubtitleKey = null;
    private String[] localizedAlertSubtitleArguments = null;
    private String launchImageFileName = null;
    private boolean showActionButton = true;
    private String actionButtonLabel = null;
    private String localizedActionButtonKey = null;
    private Integer badgeNumber = null;
    private String soundFileName = null;
    private SoundForCriticalAlert soundForCriticalAlert = null;
    private String categoryName = null;
    private boolean contentAvailable = false;
    private boolean mutableContent = false;
    private String threadId = null;
    private String targetContentId = null;
    private String summaryArgument = null;
    private Integer summaryArgumentCount = null;
    private String[] urlArguments = null;
    private boolean preferStringRepresentationForAlerts = false;
    private final CharArrayWriter buffer = new CharArrayWriter(1024);
    private static final String APS_KEY = "aps";
    private static final String ALERT_KEY = "alert";
    private static final String BADGE_KEY = "badge";
    private static final String SOUND_KEY = "sound";
    private static final String CATEGORY_KEY = "category";
    private static final String CONTENT_AVAILABLE_KEY = "content-available";
    private static final String MUTABLE_CONTENT_KEY = "mutable-content";
    private static final String THREAD_ID_KEY = "thread-id";
    private static final String TARGET_CONTENT_ID_KEY = "target-content-id";
    private static final String SUMMARY_ARGUMENT_KEY = "summary-arg";
    private static final String SUMMARY_ARGUMENT_COUNT_KEY = "summary-arg-count";
    private static final String URL_ARGS_KEY = "url-args";
    private static final String ALERT_TITLE_KEY = "title";
    private static final String ALERT_TITLE_LOC_KEY = "title-loc-key";
    private static final String ALERT_TITLE_ARGS_KEY = "title-loc-args";
    private static final String ALERT_SUBTITLE_KEY = "subtitle";
    private static final String ALERT_SUBTITLE_LOC_KEY = "subtitle-loc-key";
    private static final String ALERT_SUBTITLE_ARGS_KEY = "subtitle-loc-args";
    private static final String ALERT_BODY_KEY = "body";
    private static final String ALERT_LOC_KEY = "loc-key";
    private static final String ALERT_ARGS_KEY = "loc-args";
    private static final String ACTION_KEY = "action";
    private static final String ACTION_LOC_KEY = "action-loc-key";
    private static final String LAUNCH_IMAGE_KEY = "launch-image";
    private static final String MDM_KEY = "mdm";
    private final HashMap<String, Object> customProperties = new HashMap();
    private static final String ABBREVIATION_SUBSTRING = "\u2026";
    private static final Gson GSON = new GsonBuilder().serializeNulls().disableHtmlEscaping().create();
    public static final String DEFAULT_SOUND_FILENAME = "default";
    public static final int DEFAULT_MAXIMUM_PAYLOAD_SIZE = 4096;

    public ApnsPayloadBuilder setPreferStringRepresentationForAlerts(boolean preferStringRepresentationForAlerts) {
        this.preferStringRepresentationForAlerts = preferStringRepresentationForAlerts;
        return this;
    }

    public ApnsPayloadBuilder setAlertBody(String alertBody) {
        this.alertBody = alertBody;
        this.localizedAlertKey = null;
        this.localizedAlertArguments = null;
        return this;
    }

    public ApnsPayloadBuilder setLocalizedAlertMessage(String localizedAlertKey, String ... alertArguments) {
        this.localizedAlertKey = localizedAlertKey;
        this.localizedAlertArguments = alertArguments != null && alertArguments.length > 0 ? alertArguments : null;
        this.alertBody = null;
        return this;
    }

    public ApnsPayloadBuilder setAlertTitle(String alertTitle) {
        this.alertTitle = alertTitle;
        this.localizedAlertTitleKey = null;
        this.localizedAlertTitleArguments = null;
        return this;
    }

    public ApnsPayloadBuilder setLocalizedAlertTitle(String localizedAlertTitleKey, String ... alertTitleArguments) {
        this.localizedAlertTitleKey = localizedAlertTitleKey;
        this.localizedAlertTitleArguments = alertTitleArguments != null && alertTitleArguments.length > 0 ? alertTitleArguments : null;
        this.alertTitle = null;
        return this;
    }

    public ApnsPayloadBuilder setAlertSubtitle(String alertSubtitle) {
        this.alertSubtitle = alertSubtitle;
        this.localizedAlertSubtitleKey = null;
        this.localizedAlertSubtitleArguments = null;
        return this;
    }

    public ApnsPayloadBuilder setLocalizedAlertSubtitle(String localizedAlertSubtitleKey, String ... alertSubtitleArguments) {
        this.localizedAlertSubtitleKey = localizedAlertSubtitleKey;
        this.localizedAlertSubtitleArguments = alertSubtitleArguments != null && alertSubtitleArguments.length > 0 ? alertSubtitleArguments : null;
        this.alertSubtitle = null;
        return this;
    }

    public ApnsPayloadBuilder setLaunchImageFileName(String launchImageFilename) {
        this.launchImageFileName = launchImageFilename;
        return this;
    }

    public ApnsPayloadBuilder setShowActionButton(boolean showActionButton) {
        this.showActionButton = showActionButton;
        return this;
    }

    public ApnsPayloadBuilder setActionButtonLabel(String action) {
        this.actionButtonLabel = action;
        this.localizedActionButtonKey = null;
        return this;
    }

    public ApnsPayloadBuilder setLocalizedActionButtonKey(String localizedActionButtonKey) {
        this.localizedActionButtonKey = localizedActionButtonKey;
        this.actionButtonLabel = null;
        return this;
    }

    public ApnsPayloadBuilder setBadgeNumber(Integer badgeNumber) {
        this.badgeNumber = badgeNumber;
        return this;
    }

    public ApnsPayloadBuilder setCategoryName(String categoryName) {
        this.categoryName = categoryName;
        return this;
    }

    @Deprecated
    public ApnsPayloadBuilder setSoundFileName(String soundFileName) {
        return this.setSound(soundFileName);
    }

    public ApnsPayloadBuilder setSound(String soundFileName) {
        this.soundFileName = soundFileName;
        this.soundForCriticalAlert = null;
        return this;
    }

    public ApnsPayloadBuilder setSound(String soundFileName, boolean isCriticalAlert, double soundVolume) {
        Objects.requireNonNull(soundFileName, "Sound file name must not be null.");
        if (soundVolume < 0.0 || soundVolume > 1.0) {
            throw new IllegalArgumentException("Sound volume must be between 0.0 and 1.0 (inclusive).");
        }
        this.soundFileName = null;
        this.soundForCriticalAlert = new SoundForCriticalAlert(soundFileName, isCriticalAlert, soundVolume);
        return this;
    }

    public ApnsPayloadBuilder setContentAvailable(boolean contentAvailable) {
        this.contentAvailable = contentAvailable;
        return this;
    }

    public ApnsPayloadBuilder setMutableContent(boolean mutableContent) {
        this.mutableContent = mutableContent;
        return this;
    }

    public ApnsPayloadBuilder setThreadId(String threadId) {
        this.threadId = threadId;
        return this;
    }

    public ApnsPayloadBuilder setTargetContentId(String targetContentId) {
        this.targetContentId = targetContentId;
        return this;
    }

    public ApnsPayloadBuilder setSummaryArgument(String summaryArgument) {
        this.summaryArgument = summaryArgument;
        return this;
    }

    public ApnsPayloadBuilder setSummaryArgumentCount(Integer summaryArgumentCount) {
        if (summaryArgumentCount != null && summaryArgumentCount < 1) {
            throw new IllegalArgumentException("Summary argument count must be positive.");
        }
        this.summaryArgumentCount = summaryArgumentCount;
        return this;
    }

    public ApnsPayloadBuilder setUrlArguments(List<String> arguments) {
        return this.setUrlArguments(arguments != null ? arguments.toArray(new String[0]) : null);
    }

    public ApnsPayloadBuilder setUrlArguments(String ... arguments) {
        this.urlArguments = arguments;
        return this;
    }

    public ApnsPayloadBuilder addCustomProperty(String key, Object value) {
        this.customProperties.put(key, value);
        return this;
    }

    public String buildWithDefaultMaximumLength() {
        return this.buildWithMaximumLength(4096);
    }

    public String buildWithMaximumLength(int maximumPayloadSize) {
        String fittedPayloadString;
        HashMap<String, Object> payload = new HashMap<String, Object>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.badgeNumber != null) {
            hashMap.put(BADGE_KEY, this.badgeNumber);
        }
        if (this.soundFileName != null) {
            hashMap.put(SOUND_KEY, this.soundFileName);
        } else if (this.soundForCriticalAlert != null) {
            hashMap.put(SOUND_KEY, this.soundForCriticalAlert);
        }
        if (this.categoryName != null) {
            hashMap.put(CATEGORY_KEY, this.categoryName);
        }
        if (this.contentAvailable) {
            hashMap.put(CONTENT_AVAILABLE_KEY, 1);
        }
        if (this.mutableContent) {
            hashMap.put(MUTABLE_CONTENT_KEY, 1);
        }
        if (this.threadId != null) {
            hashMap.put(THREAD_ID_KEY, this.threadId);
        }
        if (this.targetContentId != null) {
            hashMap.put(TARGET_CONTENT_ID_KEY, this.targetContentId);
        }
        if (this.urlArguments != null) {
            hashMap.put(URL_ARGS_KEY, this.urlArguments);
        }
        HashMap<String, Object> alert = new HashMap<String, Object>();
        if (this.alertBody != null) {
            alert.put(ALERT_BODY_KEY, this.alertBody);
        }
        if (this.alertTitle != null) {
            alert.put(ALERT_TITLE_KEY, this.alertTitle);
        }
        if (this.alertSubtitle != null) {
            alert.put(ALERT_SUBTITLE_KEY, this.alertSubtitle);
        }
        if (this.summaryArgument != null) {
            alert.put(SUMMARY_ARGUMENT_KEY, this.summaryArgument);
        }
        if (this.summaryArgumentCount != null) {
            alert.put(SUMMARY_ARGUMENT_COUNT_KEY, this.summaryArgumentCount);
        }
        if (this.showActionButton) {
            if (this.localizedActionButtonKey != null) {
                alert.put(ACTION_LOC_KEY, this.localizedActionButtonKey);
            }
            if (this.actionButtonLabel != null) {
                alert.put(ACTION_KEY, this.actionButtonLabel);
            }
        } else {
            alert.put(ACTION_LOC_KEY, null);
        }
        if (this.localizedAlertKey != null) {
            alert.put(ALERT_LOC_KEY, this.localizedAlertKey);
            if (this.localizedAlertArguments != null) {
                alert.put(ALERT_ARGS_KEY, Arrays.asList(this.localizedAlertArguments));
            }
        }
        if (this.localizedAlertTitleKey != null) {
            alert.put(ALERT_TITLE_LOC_KEY, this.localizedAlertTitleKey);
            if (this.localizedAlertTitleArguments != null) {
                alert.put(ALERT_TITLE_ARGS_KEY, Arrays.asList(this.localizedAlertTitleArguments));
            }
        }
        if (this.localizedAlertSubtitleKey != null) {
            alert.put(ALERT_SUBTITLE_LOC_KEY, this.localizedAlertSubtitleKey);
            if (this.localizedAlertSubtitleArguments != null) {
                alert.put(ALERT_SUBTITLE_ARGS_KEY, Arrays.asList(this.localizedAlertSubtitleArguments));
            }
        }
        if (this.launchImageFileName != null) {
            alert.put(LAUNCH_IMAGE_KEY, this.launchImageFileName);
        }
        if (alert.size() == 1 && alert.containsKey(ALERT_BODY_KEY) && this.preferStringRepresentationForAlerts) {
            hashMap.put(ALERT_KEY, alert.get(ALERT_BODY_KEY));
        } else if (!alert.isEmpty()) {
            hashMap.put(ALERT_KEY, alert);
        }
        payload.put(APS_KEY, hashMap);
        for (Map.Entry entry : this.customProperties.entrySet()) {
            payload.put((String)entry.getKey(), entry.getValue());
        }
        this.buffer.reset();
        GSON.toJson(payload, (Appendable)this.buffer);
        String string = this.buffer.toString();
        int initialPayloadSize = string.getBytes(StandardCharsets.UTF_8).length;
        if (initialPayloadSize <= maximumPayloadSize) {
            fittedPayloadString = string;
        } else if (this.alertBody != null) {
            this.replaceMessageBody(payload, "");
            this.buffer.reset();
            GSON.toJson(payload, (Appendable)this.buffer);
            int payloadSizeWithEmptyMessage = this.buffer.toString().getBytes(StandardCharsets.UTF_8).length;
            if (payloadSizeWithEmptyMessage >= maximumPayloadSize) {
                throw new IllegalArgumentException("Payload exceeds maximum size even with an empty message body.");
            }
            int maximumEscapedMessageBodySize = maximumPayloadSize - payloadSizeWithEmptyMessage - ABBREVIATION_SUBSTRING.getBytes(StandardCharsets.UTF_8).length;
            String fittedMessageBody = this.alertBody.substring(0, ApnsPayloadBuilder.getLengthOfJsonEscapedUtf8StringFittingSize(this.alertBody, maximumEscapedMessageBodySize));
            this.replaceMessageBody(payload, String.valueOf(fittedMessageBody) + ABBREVIATION_SUBSTRING);
            this.buffer.reset();
            GSON.toJson(payload, (Appendable)this.buffer);
            fittedPayloadString = this.buffer.toString();
        } else {
            throw new IllegalArgumentException(String.format("Payload size is %d bytes (with a maximum of %d bytes) and cannot be shortened.", initialPayloadSize, maximumPayloadSize));
        }
        return fittedPayloadString;
    }

    public static String buildMdmPayload(String pushMagicValue) {
        return GSON.toJson(Collections.singletonMap(MDM_KEY, pushMagicValue));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void replaceMessageBody(Map<String, Object> payload, String messageBody) {
        Map aps = (Map)payload.get(APS_KEY);
        Object alert = aps.get(ALERT_KEY);
        if (alert == null) throw new IllegalArgumentException("Payload has no message body.");
        if (alert instanceof String) {
            aps.put(ALERT_KEY, messageBody);
            return;
        } else {
            Map alertObject = (Map)alert;
            if (alertObject.get(ALERT_BODY_KEY) == null) throw new IllegalArgumentException("Payload has no message body.");
            alertObject.put(ALERT_BODY_KEY, messageBody);
        }
    }

    static int getLengthOfJsonEscapedUtf8StringFittingSize(String string, int maximumSize) {
        int i = 0;
        int cumulativeSize = 0;
        i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            int charSize = ApnsPayloadBuilder.getSizeOfJsonEscapedUtf8Character(c);
            if (cumulativeSize + charSize > maximumSize) break;
            cumulativeSize += charSize;
            if (Character.isHighSurrogate(c)) {
                ++i;
            }
            ++i;
        }
        return i;
    }

    static int getSizeOfJsonEscapedUtf8Character(char c) {
        int charSize = c == '\"' || c == '\\' || c == '\b' || c == '\f' || c == '\n' || c == '\r' || c == '\t' ? 2 : (c <= '\u001f' || c == '\u2028' || c == '\u2029' ? 6 : (c <= '\u007f' ? 1 : (c <= '\u07ff' ? 2 : (Character.isHighSurrogate(c) ? 4 : 3))));
        return charSize;
    }

    private static class SoundForCriticalAlert {
        private final String name;
        private final int critical;
        private final double volume;

        private SoundForCriticalAlert(String name, boolean critical, double volume) {
            this.name = name;
            this.critical = critical ? 1 : 0;
            this.volume = volume;
        }
    }
}

