/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv6;

import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressSeqRange;
import inet.ipaddr.NetworkMismatchException;
import inet.ipaddr.PrefixLenException;
import inet.ipaddr.format.validate.ParsedAddressGrouping;
import inet.ipaddr.ipv6.IPv6Address;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import java.util.Iterator;
import java.util.function.Function;

public class IPv6AddressSeqRange
extends IPAddressSeqRange
implements Iterable<IPv6Address> {
    private static final long serialVersionUID = 1L;
    private static final IPv6AddressSeqRange[] EMPTY = new IPv6AddressSeqRange[0];

    public IPv6AddressSeqRange(IPv6Address first, IPv6Address second) {
        super(first, second, IPv6Address::getLower, IPv6Address::getUpper, a -> a.withoutPrefixLength().removeZone());
        if (!first.getNetwork().equals(second.getNetwork())) {
            throw new NetworkMismatchException(first, second);
        }
    }

    private IPv6AddressSeqRange(IPAddress first, IPAddress second) {
        super(first, second);
    }

    @Override
    public IPv6Address getLower() {
        return (IPv6Address)super.getLower();
    }

    @Override
    public IPv6Address getUpper() {
        return (IPv6Address)super.getUpper();
    }

    private IPv6AddressNetwork.IPv6AddressCreator getAddressCreator() {
        return this.getLower().getDefaultCreator();
    }

    public Iterable<IPv6Address> getIterable() {
        return this;
    }

    @Override
    public Iterator<IPv6Address> iterator() {
        IPv6Address lower = this.getLower();
        IPv6Address upper = this.getUpper();
        IPv6AddressNetwork.IPv6AddressCreator creator = this.getAddressCreator();
        if (!this.isMultiple()) {
            return IPv6AddressSeqRange.iterator(lower, creator);
        }
        int divCount = lower.getSegmentCount();
        return IPv6AddressSeqRange.iterator(lower, upper, creator, IPv6Address::getSegment, (seg, segIndex) -> seg.iterator(), (addr1, addr2, index) -> addr1.getSegment(index).getSegmentValue() == addr2.getSegment(index).getSegmentValue(), divCount - 1, divCount, null);
    }

    public IPv6Address[] spanWithPrefixBlocks() {
        return this.getLower().spanWithPrefixBlocks(this.getUpper());
    }

    public IPv6Address[] spanWithSequentialBlocks() {
        return this.getLower().spanWithSequentialBlocks(this.getUpper());
    }

    @Override
    protected IPv6AddressSeqRange create(IPAddress lower, IPAddress upper) {
        return new IPv6AddressSeqRange(lower, upper);
    }

    protected IPv6AddressSeqRange[] createPair(IPAddress lower1, IPAddress upper1, IPAddress lower2, IPAddress upper2) {
        return new IPv6AddressSeqRange[]{this.create(lower1, upper1), this.create(lower2, upper2)};
    }

    protected IPv6AddressSeqRange[] createSingle(IPAddress lower, IPAddress upper) {
        return new IPv6AddressSeqRange[]{this.create(lower, upper)};
    }

    protected IPv6AddressSeqRange[] createSingle() {
        return new IPv6AddressSeqRange[]{this};
    }

    protected IPv6AddressSeqRange[] createEmpty() {
        return EMPTY;
    }

    @Override
    public Iterator<? extends IPAddress> prefixBlockIterator(int prefLength) {
        if (prefLength < 0) {
            throw new PrefixLenException(prefLength);
        }
        IPv6Address lower = this.getLower();
        IPv6Address upper = this.getUpper();
        IPv6AddressNetwork.IPv6AddressCreator creator = this.getAddressCreator();
        return IPv6AddressSeqRange.iterator(lower, upper, creator, IPv6Address::getSegment, (seg, segIndex) -> seg.iterator(), (addr1, addr2, index) -> {
            Integer segPrefLength = ParsedAddressGrouping.getPrefixedSegmentPrefixLength(16, prefLength, index);
            if (segPrefLength == null) {
                return addr1.getSegment(index).getSegmentValue() == addr2.getSegment(index).getSegmentValue();
            }
            int shift = 16 - segPrefLength;
            return addr1.getSegment(index).getSegmentValue() >>> shift == addr2.getSegment(index).getSegmentValue() >>> shift;
        }, IPv6AddressSeqRange.getNetworkSegmentIndex(prefLength, 2, 16), IPv6AddressSeqRange.getHostSegmentIndex(prefLength, 2, 16), (seg, index) -> {
            Integer segPrefLength = ParsedAddressGrouping.getPrefixedSegmentPrefixLength(16, prefLength, index);
            if (segPrefLength == null) {
                return seg.iterator();
            }
            return seg.prefixBlockIterator(segPrefLength);
        });
    }

    public Iterator<IPv6AddressSeqRange> prefixIterator(int prefixLength) {
        return super.prefixIterator(prefixLength);
    }

    public String toIPv6String(Function<IPv6Address, String> lowerStringer, String separator, Function<IPv6Address, String> upperStringer) {
        return lowerStringer.apply(this.getLower()) + separator + upperStringer.apply(this.getUpper());
    }

    @Override
    public IPv6AddressSeqRange intersect(IPAddressSeqRange other) {
        return (IPv6AddressSeqRange)super.intersect(other);
    }

    @Override
    public IPv6AddressSeqRange join(IPAddressSeqRange other) {
        return (IPv6AddressSeqRange)super.join(other);
    }

    public IPv6AddressSeqRange[] subtract(IPAddressSeqRange other) {
        return (IPv6AddressSeqRange[])super.subtract(other);
    }
}

