/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef.mime;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMultipart;
import net.freeutils.tnef.MAPIProps;
import net.freeutils.tnef.Message;
import net.freeutils.tnef.mime.Converter;
import net.freeutils.tnef.mime.TNEFMime;
import net.freeutils.tnef.mime.TNEFMimeMessage;

public class ReadReceiptConverter
extends Converter {
    public boolean canConvert(Message message) {
        return this.isMessageClass(message, "IPM.Microsoft Mail.Read Receipt");
    }

    public TNEFMimeMessage convert(Message message, TNEFMimeMessage mime) throws IOException, MessagingException {
        MAPIProps props = message.getMAPIProps();
        String recipient = (String)props.getPropValue(116);
        String subject = (String)props.getPropValue(112);
        Date sentDate = (Date)props.getPropValue(78);
        Date readDate = (Date)props.getPropValue(50);
        DateFormat format = DateFormat.getDateTimeInstance(3, 3);
        MimeMultipart mp = new MimeMultipart("report; report-type=disposition-notification");
        StringBuilder text = new StringBuilder();
        text.append("Your message\r\n");
        text.append("\r\n      To:\t");
        if (recipient != null) {
            text.append(recipient);
        }
        text.append("\r\n      Subject:\t");
        if (subject != null) {
            text.append(subject);
        }
        text.append("\r\n      Sent:\t");
        if (sentDate != null) {
            text.append(format.format(sentDate));
        }
        if (readDate != null) {
            text.append("\r\n\r\nwas read on ").append(format.format(readDate)).append('.');
        }
        text.append("\r\n");
        TNEFMime.addTextPart((Multipart)mp, text.toString(), "text/plain");
        text.setLength(0);
        text.append("Original-Recipient: rfc822;").append(recipient).append("\r\n").append("Final-Recipient: rfc822;").append(recipient).append("\r\n").append("Disposition: manual-action/MDN-sent-manually; displayed").append("\r\n");
        TNEFMime.addTextPart((Multipart)mp, text.toString(), "message/disposition-notification");
        mime.setContent((Multipart)mp);
        return mime;
    }
}

