/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef.mime;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MimetypesFileTypeMap;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMultipart;
import net.freeutils.tnef.Address;
import net.freeutils.tnef.Attachment;
import net.freeutils.tnef.Attr;
import net.freeutils.tnef.CompressedRTFInputStream;
import net.freeutils.tnef.MAPIProps;
import net.freeutils.tnef.Message;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFUtils;
import net.freeutils.tnef.mime.Converter;
import net.freeutils.tnef.mime.RawDataSource;
import net.freeutils.tnef.mime.TNEFMime;
import net.freeutils.tnef.mime.TNEFMimeBodyPart;
import net.freeutils.tnef.mime.TNEFMimeMessage;

public class MessageConverter
extends Converter {
    public boolean canConvert(Message message) {
        return true;
    }

    public TNEFMimeMessage convert(Message message, TNEFMimeMessage mime) throws IOException, MessagingException {
        mime.setTNEFAttributes(message.getAttributes());
        this.addHeaders(message, mime);
        Attr attr = message.getAttribute(32768);
        if (attr != null) {
            Address address = (Address)attr.getValue();
            mime.setFrom((javax.mail.Address)new InternetAddress(address.getAddress(), address.getDisplayName()));
        }
        if ((attr = message.getAttribute(32773)) != null) {
            mime.setSentDate((Date)attr.getValue());
        }
        this.addRecipients(message, mime);
        attr = message.getAttribute(32772);
        if (attr != null) {
            mime.setSubject((String)attr.getValue());
        }
        MimeMultipart mp = new MimeMultipart();
        this.addBody(message, (Multipart)mp);
        this.addAttachments(message, mime, (Multipart)mp);
        if (mp.getCount() > 0) {
            mime.setContent((Multipart)mp);
        } else {
            mime.setContent("", "text/plain; charset=utf-8");
        }
        return mime;
    }

    protected void addHeaders(Message message, TNEFMimeMessage mime) throws IOException, MessagingException {
        String headers;
        MAPIProps props = message.getMAPIProps();
        if (props != null && (headers = (String)props.getPropValue(125)) != null) {
            InternetHeaders ih = new InternetHeaders((InputStream)new ByteArrayInputStream(headers.getBytes("ISO8859_1")));
            Enumeration e = ih.getAllHeaders();
            while (e.hasMoreElements()) {
                Header h = (Header)e.nextElement();
                mime.addHeader(h.getName(), h.getValue());
            }
        }
    }

    protected void addRecipients(Message message, TNEFMimeMessage mime) throws MessagingException, IOException {
        Attr attr = message.getAttribute(36868);
        if (attr != null) {
            mime.removeHeader("To");
            mime.removeHeader("Cc");
            mime.removeHeader("Bcc");
            for (MAPIProps recipient : (MAPIProps[])attr.getValue()) {
                Message.RecipientType recipientType;
                String name = (String)recipient.getPropValue(12289);
                String address = (String)recipient.getPropValue(12291);
                InternetAddress internetAddress = new InternetAddress(address, name);
                int type = (Integer)recipient.getPropValue(3093);
                switch (type) {
                    case 1: {
                        recipientType = Message.RecipientType.TO;
                        break;
                    }
                    case 2: {
                        recipientType = Message.RecipientType.CC;
                        break;
                    }
                    case 3: {
                        recipientType = Message.RecipientType.BCC;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid PR_RECIPIENT_TYPE: " + type);
                    }
                }
                mime.addRecipient(recipientType, (javax.mail.Address)internetAddress);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Multipart addBody(Message message, Multipart mp) throws IOException, MessagingException {
        MAPIProps props;
        Attr attr = message.getAttribute(32780);
        if (attr != null) {
            String text = (String)attr.getValue();
            TNEFMime.addTextPart(mp, text, "text/plain");
        }
        if ((props = message.getMAPIProps()) != null) {
            RawInputStream ris = (RawInputStream)props.getPropValue(4105);
            if (ris != null) {
                try {
                    CompressedRTFInputStream rtfStream = new CompressedRTFInputStream(ris);
                    byte[] rtfBytes = TNEFUtils.readSafely(rtfStream, rtfStream.getUncompressedSize(), 0x100000);
                    TNEFMime.addTextPart(mp, new String(rtfBytes), "text/rtf");
                }
                finally {
                    ris.close();
                }
            } else {
                Object html = props.getPropValue(4115);
                if (html != null) {
                    String text;
                    if (html instanceof RawInputStream) {
                        ris = (RawInputStream)html;
                        try {
                            text = new String(ris.toByteArray(), "UTF-8");
                        }
                        finally {
                            ris.close();
                        }
                    } else {
                        text = (String)html;
                    }
                    TNEFMime.addTextPart(mp, text, "text/html");
                }
            }
        }
        return mp;
    }

    protected void addAttachments(Message message, TNEFMimeMessage mime, Multipart mp) throws MessagingException, IOException {
        for (Attachment attachment : message.getAttachments()) {
            TNEFMimeBodyPart part = new TNEFMimeBodyPart();
            if (attachment.getNestedMessage() == null) {
                part.setTNEFAttributes(attachment.getAttributes());
                String filename = attachment.getFilename();
                if (filename != null) {
                    part.setFileName(filename);
                }
                String mimeType = null;
                if (attachment.getMAPIProps() != null) {
                    mimeType = (String)attachment.getMAPIProps().getPropValue(14094);
                }
                if (mimeType == null && filename != null) {
                    mimeType = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(filename);
                }
                if (mimeType == null) {
                    mimeType = "application/octet-stream";
                }
                RawDataSource ds = new RawDataSource(attachment.getRawData(), mimeType, filename);
                part.setDataHandler(new DataHandler((DataSource)ds));
                mp.addBodyPart((BodyPart)part);
                continue;
            }
            TNEFMimeMessage nested = TNEFMime.convert(mime.getSession(), attachment.getNestedMessage());
            part.setDataHandler(new DataHandler((Object)nested, "message/rfc822"));
            mp.addBodyPart((BodyPart)part);
        }
    }
}

