/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.freeutils.tnef.Attachment;
import net.freeutils.tnef.Attr;
import net.freeutils.tnef.MAPIProps;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFInputStream;
import net.freeutils.tnef.TNEFUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message
implements Closeable {
    List<Attr> attributes = new ArrayList<Attr>();
    List<Attachment> attachments = new ArrayList<Attachment>();

    public Message() {
    }

    public Message(TNEFInputStream in) throws IOException {
        this();
        this.read(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void read(TNEFInputStream in) throws IOException {
        Attr attr;
        Attachment attachment = null;
        block14: while ((attr = in.readAttr()) != null) {
            switch (attr.getLevel()) {
                case 2: {
                    switch (attr.getID()) {
                        case 36866: {
                            if (attachment != null) {
                                this.attachments.add(attachment);
                            }
                            attachment = new Attachment();
                            attachment.addAttribute(attr);
                            continue block14;
                        }
                        case 36869: {
                            RawInputStream data = (RawInputStream)attr.getValue();
                            try {
                                attachment.setMAPIProps(new MAPIProps(data));
                            }
                            catch (Throwable throwable) {
                                TNEFUtils.closeAll((Closeable[])new Closeable[]{data, attr});
                                throw throwable;
                            }
                            TNEFUtils.closeAll((Closeable[])new Closeable[]{data, attr});
                            continue block14;
                        }
                        case 32783: {
                            RawInputStream data = (RawInputStream)attr.getValue();
                            attachment.setRawData(data);
                            attr.close();
                            continue block14;
                        }
                        case 36865: {
                            RawInputStream data = (RawInputStream)attr.getValue();
                            try {
                                String filename = TNEFUtils.removeTerminatingNulls(new String(data.toByteArray(), this.getOEMCodePage()));
                                attachment.setFilename(filename);
                            }
                            catch (Throwable throwable) {
                                TNEFUtils.closeAll((Closeable[])new Closeable[]{data, attr});
                                throw throwable;
                            }
                            TNEFUtils.closeAll((Closeable[])new Closeable[]{data, attr});
                            continue block14;
                        }
                    }
                    attachment.addAttribute(attr);
                    continue block14;
                }
                case 1: {
                    this.attributes.add(attr);
                    continue block14;
                }
            }
            throw new IOException("Invalid attribute level: " + attr.getLevel());
        }
        if (attachment != null) {
            this.attachments.add(attachment);
        }
    }

    public MAPIProps getMAPIProps() throws IOException {
        Attr attr = this.getAttribute(36867);
        return attr != null ? (MAPIProps)attr.getValue() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOEMCodePage() {
        String string;
        Attr attr = this.getAttribute(36871);
        if (attr == null) {
            return null;
        }
        RawInputStream data = (RawInputStream)attr.getValue();
        try {
            string = "Cp" + data.readU16();
        }
        catch (Throwable throwable) {
            try {
                data.close();
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        data.close();
        return string;
    }

    public List<Attr> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<Attr> attributes) {
        this.attributes = attributes;
    }

    public Attr getAttribute(int id) {
        return Attr.findAttr(this.attributes, id);
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public void addAttribute(Attr attr) {
        this.attributes.add(attr);
    }

    public void addAttachment(Attachment attachment) {
        this.attachments.add(attachment);
    }

    @Override
    public void close() throws IOException {
        TNEFUtils.closeAll(this.attributes);
        TNEFUtils.closeAll(this.attachments);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Message:");
        s.append("\n  Attributes:");
        for (Attr attribute : this.attributes) {
            s.append("\n    ").append(attribute);
        }
        s.append("\n  Attachments:");
        for (Attachment attachment : this.attachments) {
            s.append("\n    ").append(attachment);
        }
        return s.toString();
    }
}

