/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef;

import java.io.Closeable;
import java.io.IOException;
import net.freeutils.tnef.MAPIProp;
import net.freeutils.tnef.MAPIPropName;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFUtils;

public class MAPIProps
implements Closeable {
    MAPIProp[] props;
    int rawLength;

    public MAPIProps(RawInputStream data) throws IOException {
        long startOffset = data.getPosition();
        int count = (int)data.readU32();
        if (count * 4 > data.available()) {
            throw new IOException("count is too large: " + count);
        }
        this.props = new MAPIProp[count];
        for (int i = 0; i < count; ++i) {
            this.props[i] = new MAPIProp(data);
        }
        this.rawLength = (int)(data.getPosition() - startOffset);
    }

    public MAPIProps(MAPIProp ... props) {
        this.props = props;
    }

    public MAPIProp[] getProps() {
        return this.props;
    }

    protected int getRawLength() {
        return this.rawLength;
    }

    public MAPIProp getProp(int id) {
        return MAPIProp.findProp(this.props, id);
    }

    public MAPIProp getProp(MAPIPropName name) {
        return MAPIProp.findProp(this.props, name);
    }

    public Object getPropValue(int id) throws IOException {
        MAPIProp prop = this.getProp(id);
        return prop != null ? prop.getValue() : null;
    }

    public Object getPropValue(MAPIPropName name) throws IOException {
        MAPIProp prop = this.getProp(name);
        return prop != null ? prop.getValue() : null;
    }

    public void close() throws IOException {
        TNEFUtils.closeAll((Closeable[])this.props);
    }
}

