/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.parameter;

import ezvcard.Messages;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.Warning;
import ezvcard.parameter.Calscale;
import ezvcard.parameter.Encoding;
import ezvcard.parameter.Pid;
import ezvcard.parameter.VCardParameter;
import ezvcard.util.CharacterBitSet;
import ezvcard.util.GeoUri;
import ezvcard.util.ListMultimap;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCardParameters
extends ListMultimap<String, String> {
    public static final String ALTID = "ALTID";
    public static final String CALSCALE = "CALSCALE";
    public static final String CHARSET = "CHARSET";
    public static final String ENCODING = "ENCODING";
    public static final String GEO = "GEO";
    public static final String INDEX = "INDEX";
    public static final String LABEL = "LABEL";
    public static final String LANGUAGE = "LANGUAGE";
    public static final String LEVEL = "LEVEL";
    public static final String MEDIATYPE = "MEDIATYPE";
    public static final String PID = "PID";
    public static final String PREF = "PREF";
    public static final String SORT_AS = "SORT-AS";
    public static final String TYPE = "TYPE";
    public static final String TZ = "TZ";
    public static final String VALUE = "VALUE";
    private static final Map<String, Set<VCardVersion>> supportedVersions;

    public VCardParameters() {
    }

    public VCardParameters(VCardParameters orig) {
        super(orig);
    }

    public String getAltId() {
        return (String)this.first(ALTID);
    }

    public void setAltId(String altId) {
        this.replace(ALTID, altId);
    }

    public Calscale getCalscale() {
        String value = (String)this.first(CALSCALE);
        return value == null ? null : Calscale.get(value);
    }

    public void setCalscale(Calscale calscale) {
        this.replace(CALSCALE, calscale == null ? null : calscale.getValue());
    }

    public String getCharset() {
        return (String)this.first(CHARSET);
    }

    public void setCharset(String charset) {
        this.replace(CHARSET, charset);
    }

    public Encoding getEncoding() {
        String value = (String)this.first(ENCODING);
        return value == null ? null : Encoding.get(value);
    }

    public void setEncoding(Encoding encoding) {
        this.replace(ENCODING, encoding == null ? null : encoding.getValue());
    }

    public GeoUri getGeo() {
        String value = (String)this.first(GEO);
        if (value == null) {
            return null;
        }
        try {
            return GeoUri.parse(value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(Messages.INSTANCE.getExceptionMessage(15, GEO), e);
        }
    }

    public void setGeo(GeoUri uri) {
        this.replace(GEO, uri == null ? null : uri.toString());
    }

    public Integer getIndex() {
        String index = (String)this.first(INDEX);
        if (index == null) {
            return null;
        }
        try {
            return Integer.valueOf(index);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(Messages.INSTANCE.getExceptionMessage(15, INDEX), e);
        }
    }

    public void setIndex(Integer index) {
        this.replace(INDEX, index == null ? null : index.toString());
    }

    public String getLabel() {
        return (String)this.first(LABEL);
    }

    public void setLabel(String label) {
        this.replace(LABEL, label);
    }

    public String getLanguage() {
        return (String)this.first(LANGUAGE);
    }

    public void setLanguage(String language) {
        this.replace(LANGUAGE, language);
    }

    public String getLevel() {
        return (String)this.first(LEVEL);
    }

    public void setLevel(String level) {
        this.replace(LEVEL, level);
    }

    public String getMediaType() {
        return (String)this.first(MEDIATYPE);
    }

    public void setMediaType(String mediaType) {
        this.replace(MEDIATYPE, mediaType);
    }

    public List<Pid> getPids() {
        return new VCardParameterList<Pid>(PID){

            @Override
            protected String _asString(Pid value) {
                return value.toString();
            }

            @Override
            protected Pid _asObject(String value) {
                return Pid.valueOf(value);
            }

            @Override
            protected IllegalStateException _exception(String value, Exception thrown) {
                return new IllegalStateException(Messages.INSTANCE.getExceptionMessage(15, VCardParameters.PID), thrown);
            }
        };
    }

    public void addPid(Pid pid) {
        this.put(PID, pid.toString());
    }

    public void removePid(Pid pid) {
        String value = pid.toString();
        this.remove(PID, value);
    }

    public void removePids() {
        this.removeAll(PID);
    }

    public Integer getPref() {
        String pref = (String)this.first(PREF);
        if (pref == null) {
            return null;
        }
        try {
            return Integer.valueOf(pref);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(Messages.INSTANCE.getExceptionMessage(15, PREF), e);
        }
    }

    public void setPref(Integer pref) {
        this.replace(PREF, pref == null ? null : pref.toString());
    }

    public List<String> getSortAs() {
        return this.get(SORT_AS);
    }

    public void setSortAs(String ... sortStrings) {
        this.removeAll(SORT_AS);
        this.putAll(SORT_AS, Arrays.asList(sortStrings));
    }

    public List<String> getTypes() {
        return this.get(TYPE);
    }

    public String getType() {
        return (String)this.first(TYPE);
    }

    public void addType(String type) {
        this.put(TYPE, type);
    }

    public void removeType(String type) {
        this.remove(TYPE, type);
    }

    public void setType(String type) {
        this.replace(TYPE, type);
    }

    public String getTimezone() {
        return (String)this.first(TZ);
    }

    public void setTimezone(String timezone) {
        this.replace(TZ, timezone);
    }

    public VCardDataType getValue() {
        String value = (String)this.first(VALUE);
        return value == null ? null : VCardDataType.get(value);
    }

    public void setValue(VCardDataType dataType) {
        this.replace(VALUE, dataType == null ? null : dataType.getName());
    }

    public List<Warning> validate(VCardVersion version) {
        ArrayList<Warning> warnings = new ArrayList<Warning>(0);
        int invalidCharsInParamValueCode = 25;
        int invalidCharsInParamNameCode = 26;
        BitSet invalidValueChars = new BitSet(128);
        invalidValueChars.set(0, 31);
        invalidValueChars.set(127);
        invalidValueChars.set(9, false);
        invalidValueChars.set(10, false);
        invalidValueChars.set(13, false);
        if (version == VCardVersion.V2_1) {
            invalidValueChars.set(44);
            invalidValueChars.set(46);
            invalidValueChars.set(58);
            invalidValueChars.set(61);
            invalidValueChars.set(91);
            invalidValueChars.set(93);
        }
        CharacterBitSet validNameChars = new CharacterBitSet("-a-zA-Z0-9");
        for (Map.Entry entry : this) {
            String name = (String)entry.getKey();
            if (version != VCardVersion.V4_0 && LABEL.equalsIgnoreCase(name)) continue;
            if (!validNameChars.containsOnly(name)) {
                warnings.add(new Warning(26, name));
            }
            List values = entry.getValue();
            block10: for (String value : values) {
                for (int i = 0; i < value.length(); ++i) {
                    char c = value.charAt(i);
                    if (!invalidValueChars.get(c)) continue;
                    warnings.add(new Warning(25, name, value, c, i));
                    continue block10;
                }
            }
        }
        int nonStandardValueCode = 3;
        int unsupportedValueCode = 4;
        String value = (String)this.first(CALSCALE);
        if (value != null && Calscale.find(value) == null) {
            warnings.add(new Warning(3, CALSCALE, value, Calscale.all()));
        }
        if ((value = (String)this.first(ENCODING)) != null) {
            Encoding encoding = Encoding.find(value);
            if (encoding == null) {
                warnings.add(new Warning(3, ENCODING, value, Encoding.all()));
            } else if (!encoding.isSupportedBy(version)) {
                warnings.add(new Warning(4, ENCODING, value));
            }
        }
        if ((value = (String)this.first(VALUE)) != null) {
            VCardDataType dataType = VCardDataType.find(value);
            if (dataType == null) {
                warnings.add(new Warning(3, VALUE, value, VCardDataType.all()));
            } else if (!dataType.isSupportedBy(version)) {
                warnings.add(new Warning(4, VALUE, value));
            }
        }
        int malformedValueCode = 5;
        try {
            this.getGeo();
        }
        catch (IllegalStateException e) {
            warnings.add(new Warning(5, GEO, this.first(GEO)));
        }
        try {
            Integer index = this.getIndex();
            if (index != null && index <= 0) {
                warnings.add(new Warning(28, index));
            }
        }
        catch (IllegalStateException e) {
            warnings.add(new Warning(5, INDEX, this.first(INDEX)));
        }
        List pids = this.get(PID);
        for (String pid : pids) {
            if (VCardParameters.isPidValid(pid)) continue;
            warnings.add(new Warning(27, pid));
        }
        try {
            Integer pref = this.getPref();
            if (pref != null && (pref < 1 || pref > 100)) {
                warnings.add(new Warning(29, pref));
            }
        }
        catch (IllegalStateException e) {
            warnings.add(new Warning(5, PREF, this.first(PREF)));
        }
        int paramNotSupportedCode = 6;
        for (Map.Entry<String, Set<VCardVersion>> entry : supportedVersions.entrySet()) {
            Set<VCardVersion> versions;
            String name = entry.getKey();
            String value2 = (String)this.first(name);
            if (value2 == null || (versions = entry.getValue()).contains((Object)version)) continue;
            warnings.add(new Warning(6, name));
        }
        int invalidCharsetCode = 22;
        String charsetStr = this.getCharset();
        if (charsetStr != null) {
            try {
                Charset.forName(charsetStr);
            }
            catch (IllegalCharsetNameException e) {
                warnings.add(new Warning(22, charsetStr));
            }
            catch (UnsupportedCharsetException e) {
                warnings.add(new Warning(22, charsetStr));
            }
        }
        return warnings;
    }

    private static boolean isPidValid(String pid) {
        boolean dotFound = false;
        for (int i = 0; i < pid.length(); ++i) {
            char c = pid.charAt(i);
            if (c == '.') {
                if (i == 0 || i == pid.length() - 1) {
                    return false;
                }
                if (dotFound) {
                    return false;
                }
                dotFound = true;
                continue;
            }
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    @Override
    protected String sanitizeKey(String key) {
        return key == null ? null : key.toUpperCase();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        for (Map.Entry entry : this) {
            String key = (String)entry.getKey();
            List value = entry.getValue();
            int valueHash = 1;
            for (String v : value) {
                valueHash += v.toLowerCase().hashCode();
            }
            int entryHash = 1;
            entryHash += 31 * entryHash + key.toLowerCase().hashCode();
            entryHash += 31 * entryHash + valueHash;
            result += entryHash;
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VCardParameters other = (VCardParameters)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (Map.Entry entry : this) {
            String key = (String)entry.getKey();
            List value = entry.getValue();
            List otherValue = other.get(key);
            if (value.size() != otherValue.size()) {
                return false;
            }
            ArrayList<String> valueLower = new ArrayList<String>(value.size());
            for (String v : value) {
                valueLower.add(v.toLowerCase());
            }
            Collections.sort(valueLower);
            ArrayList<String> otherValueLower = new ArrayList<String>(otherValue.size());
            for (String v : otherValue) {
                otherValueLower.add(v.toLowerCase());
            }
            Collections.sort(otherValueLower);
            if (valueLower.equals(otherValueLower)) continue;
            return false;
        }
        return true;
    }

    static {
        HashMap<String, EnumSet<VCardVersion>> m = new HashMap<String, EnumSet<VCardVersion>>();
        m.put(ALTID, EnumSet.of(VCardVersion.V4_0));
        m.put(CALSCALE, EnumSet.of(VCardVersion.V4_0));
        m.put(CHARSET, EnumSet.of(VCardVersion.V2_1));
        m.put(GEO, EnumSet.of(VCardVersion.V4_0));
        m.put(INDEX, EnumSet.of(VCardVersion.V4_0));
        m.put(LEVEL, EnumSet.of(VCardVersion.V4_0));
        m.put(MEDIATYPE, EnumSet.of(VCardVersion.V4_0));
        m.put(PID, EnumSet.of(VCardVersion.V4_0));
        m.put(SORT_AS, EnumSet.of(VCardVersion.V4_0));
        m.put(TZ, EnumSet.of(VCardVersion.V4_0));
        supportedVersions = Collections.unmodifiableMap(m);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class VCardParameterList<T>
    extends AbstractList<T> {
        protected final String parameterName;
        protected final List<String> parameterValues;

        public VCardParameterList(String parameterName) {
            this.parameterName = parameterName;
            this.parameterValues = VCardParameters.this.get(parameterName);
        }

        @Override
        public void add(int index, T value) {
            String valueStr = this._asString(value);
            this.parameterValues.add(index, valueStr);
        }

        @Override
        public T remove(int index) {
            String removed = this.parameterValues.remove(index);
            return this.asObject(removed);
        }

        @Override
        public T get(int index) {
            String value = this.parameterValues.get(index);
            return this.asObject(value);
        }

        @Override
        public T set(int index, T value) {
            String valueStr = this._asString(value);
            String replaced = this.parameterValues.set(index, valueStr);
            return this.asObject(replaced);
        }

        @Override
        public int size() {
            return this.parameterValues.size();
        }

        private T asObject(String value) {
            try {
                return this._asObject(value);
            }
            catch (Exception e) {
                throw this._exception(value, e);
            }
        }

        protected abstract String _asString(T var1);

        protected abstract T _asObject(String var1) throws Exception;

        protected IllegalStateException _exception(String value, Exception thrown) {
            return new IllegalStateException(Messages.INSTANCE.getExceptionMessage(26, this.parameterName), thrown);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class EnumParameterList<T extends VCardParameter>
    extends VCardParameterList<T> {
        public EnumParameterList(String parameterName) {
            super(parameterName);
        }

        @Override
        protected String _asString(T value) {
            return ((VCardParameter)value).getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class TypeParameterList<T extends VCardParameter>
    extends EnumParameterList<T> {
        public TypeParameterList() {
            super(VCardParameters.TYPE);
        }
    }
}

