/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.chain;

import ezvcard.VCard;
import ezvcard.io.chain.ChainingWriter;
import ezvcard.io.json.JCardWriter;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.property.VCardProperty;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingJsonWriter
extends ChainingWriter<ChainingJsonWriter> {
    private boolean prettyPrint = false;

    public ChainingJsonWriter(Collection<VCard> vcards) {
        super(vcards);
    }

    public ChainingJsonWriter prettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        return this;
    }

    @Override
    public ChainingJsonWriter prodId(boolean include) {
        return (ChainingJsonWriter)super.prodId(include);
    }

    @Override
    public ChainingJsonWriter versionStrict(boolean versionStrict) {
        return (ChainingJsonWriter)super.versionStrict(versionStrict);
    }

    @Override
    public ChainingJsonWriter register(VCardPropertyScribe<? extends VCardProperty> scribe) {
        return (ChainingJsonWriter)super.register(scribe);
    }

    public String go() {
        StringWriter sw = new StringWriter();
        try {
            this.go(sw);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    public void go(OutputStream out) throws IOException {
        this.go(new JCardWriter(out, this.wrapInArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go(File file) throws IOException {
        JCardWriter writer = new JCardWriter(file, this.wrapInArray());
        try {
            this.go(writer);
        }
        finally {
            writer.close();
        }
    }

    public void go(Writer writer) throws IOException {
        this.go(new JCardWriter(writer, this.wrapInArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void go(JCardWriter writer) throws IOException {
        writer.setAddProdId(this.prodId);
        writer.setPrettyPrint(this.prettyPrint);
        writer.setVersionStrict(this.versionStrict);
        if (this.index != null) {
            writer.setScribeIndex(this.index);
        }
        try {
            for (VCard vcard : this.vcards) {
                writer.write(vcard);
                writer.flush();
            }
        }
        finally {
            writer.closeJsonStream();
        }
    }

    private boolean wrapInArray() {
        return this.vcards.size() > 1;
    }
}

