/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.fishwife.jrugged.FlowMeter;
import org.fishwife.jrugged.LatencyTracker;
import org.fishwife.jrugged.MovingAverage;
import org.fishwife.jrugged.RequestCounter;
import org.fishwife.jrugged.SampledQuantile;
import org.fishwife.jrugged.ServiceWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceMonitor
implements ServiceWrapper {
    private static final String WRAP_MSG = "org.fishwife.jrugged.PerformanceMonitor.WRAPPED";
    private final long startupMillis = System.currentTimeMillis();
    private static final long ONE_MINUTE_MILLIS = 60000L;
    private static final long ONE_HOUR_MILLIS = 3600000L;
    private static final long ONE_DAY_MILLIS = 86400000L;
    private final RequestCounter requestCounter = new RequestCounter();
    private final FlowMeter flowMeter = new FlowMeter(this.requestCounter);
    private MovingAverage averageSuccessLatencyLastMinute;
    private MovingAverage averageSuccessLatencyLastHour;
    private MovingAverage averageSuccessLatencyLastDay;
    private MovingAverage averageFailureLatencyLastMinute;
    private MovingAverage averageFailureLatencyLastHour;
    private MovingAverage averageFailureLatencyLastDay;
    private MovingAverage totalRequestsPerSecondLastMinute;
    private MovingAverage successRequestsPerSecondLastMinute;
    private MovingAverage failureRequestsPerSecondLastMinute;
    private MovingAverage totalRequestsPerSecondLastHour;
    private MovingAverage successRequestsPerSecondLastHour;
    private MovingAverage failureRequestsPerSecondLastHour;
    private MovingAverage totalRequestsPerSecondLastDay;
    private MovingAverage successRequestsPerSecondLastDay;
    private MovingAverage failureRequestsPerSecondLastDay;
    private SampledQuantile lifetimeSuccessLatencyQuantile = new SampledQuantile();
    private SampledQuantile lifetimeFailureLatencyQuantile = new SampledQuantile();
    private SampledQuantile successLatencyQuantileLastMinute = new SampledQuantile(60L, TimeUnit.SECONDS);
    private SampledQuantile successLatencyQuantileLastHour = new SampledQuantile(3600L, TimeUnit.SECONDS);
    private SampledQuantile successLatencyQuantileLastDay = new SampledQuantile(86400L, TimeUnit.SECONDS);
    private SampledQuantile failureLatencyQuantileLastMinute = new SampledQuantile(60L, TimeUnit.SECONDS);
    private SampledQuantile failureLatencyQuantileLastHour = new SampledQuantile(3600L, TimeUnit.SECONDS);
    private SampledQuantile failureLatencyQuantileLastDay = new SampledQuantile(86400L, TimeUnit.SECONDS);
    private long lifetimeMaxSuccessMillis;
    private long lifetimeMaxFailureMillis;

    public PerformanceMonitor() {
        this.createMovingAverages();
    }

    private void createMovingAverages() {
        this.averageSuccessLatencyLastMinute = new MovingAverage(60000L);
        this.averageSuccessLatencyLastHour = new MovingAverage(3600000L);
        this.averageSuccessLatencyLastDay = new MovingAverage(86400000L);
        this.averageFailureLatencyLastMinute = new MovingAverage(60000L);
        this.averageFailureLatencyLastHour = new MovingAverage(3600000L);
        this.averageFailureLatencyLastDay = new MovingAverage(86400000L);
        this.totalRequestsPerSecondLastMinute = new MovingAverage(60000L);
        this.successRequestsPerSecondLastMinute = new MovingAverage(60000L);
        this.failureRequestsPerSecondLastMinute = new MovingAverage(60000L);
        this.totalRequestsPerSecondLastHour = new MovingAverage(3600000L);
        this.successRequestsPerSecondLastHour = new MovingAverage(3600000L);
        this.failureRequestsPerSecondLastHour = new MovingAverage(3600000L);
        this.totalRequestsPerSecondLastDay = new MovingAverage(86400000L);
        this.successRequestsPerSecondLastDay = new MovingAverage(86400000L);
        this.failureRequestsPerSecondLastDay = new MovingAverage(86400000L);
    }

    private void recordRequest() {
        double[] rates = this.flowMeter.sample();
        this.totalRequestsPerSecondLastMinute.update(rates[0]);
        this.totalRequestsPerSecondLastHour.update(rates[0]);
        this.totalRequestsPerSecondLastDay.update(rates[0]);
        this.successRequestsPerSecondLastMinute.update(rates[1]);
        this.successRequestsPerSecondLastHour.update(rates[1]);
        this.successRequestsPerSecondLastDay.update(rates[1]);
        this.failureRequestsPerSecondLastMinute.update(rates[2]);
        this.failureRequestsPerSecondLastHour.update(rates[2]);
        this.failureRequestsPerSecondLastDay.update(rates[2]);
    }

    private void recordSuccess(LatencyTracker latencyTracker) {
        long successMillis = latencyTracker.getLastSuccessMillis();
        this.averageSuccessLatencyLastMinute.update(successMillis);
        this.averageSuccessLatencyLastHour.update(successMillis);
        this.averageSuccessLatencyLastDay.update(successMillis);
        this.lifetimeSuccessLatencyQuantile.addSample(successMillis);
        this.successLatencyQuantileLastMinute.addSample(successMillis);
        this.successLatencyQuantileLastHour.addSample(successMillis);
        this.successLatencyQuantileLastDay.addSample(successMillis);
        this.lifetimeMaxSuccessMillis = successMillis > this.lifetimeMaxSuccessMillis ? successMillis : this.lifetimeMaxSuccessMillis;
        this.recordRequest();
    }

    private void recordFailure(LatencyTracker latencyTracker) {
        long failureMillis = latencyTracker.getLastFailureMillis();
        this.averageFailureLatencyLastMinute.update(failureMillis);
        this.averageFailureLatencyLastHour.update(failureMillis);
        this.averageFailureLatencyLastDay.update(failureMillis);
        this.lifetimeFailureLatencyQuantile.addSample(failureMillis);
        this.failureLatencyQuantileLastMinute.addSample(failureMillis);
        this.failureLatencyQuantileLastHour.addSample(failureMillis);
        this.failureLatencyQuantileLastDay.addSample(failureMillis);
        this.lifetimeMaxFailureMillis = failureMillis > this.lifetimeMaxFailureMillis ? failureMillis : this.lifetimeMaxFailureMillis;
        this.recordRequest();
    }

    @Override
    public <T> T invoke(final Callable<T> c) throws Exception {
        final LatencyTracker latencyTracker = new LatencyTracker();
        try {
            Object result = this.requestCounter.invoke(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return latencyTracker.invoke(c);
                }
            });
            this.recordSuccess(latencyTracker);
            return result;
        }
        catch (Exception e) {
            this.recordFailure(latencyTracker);
            if (WRAP_MSG.equals(e.getMessage())) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void invoke(final Runnable r) throws Exception {
        final LatencyTracker latencyTracker = new LatencyTracker();
        try {
            this.requestCounter.invoke(new Runnable(){

                public void run() {
                    try {
                        latencyTracker.invoke(r);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(PerformanceMonitor.WRAP_MSG, e);
                    }
                }
            });
            this.recordSuccess(latencyTracker);
        }
        catch (RuntimeException re) {
            this.recordFailure(latencyTracker);
            if (WRAP_MSG.equals(re.getMessage())) {
                throw (Exception)re.getCause();
            }
            throw re;
        }
    }

    @Override
    public <T> T invoke(Runnable r, T result) throws Exception {
        this.invoke(r);
        return result;
    }

    public double getAverageSuccessLatencyLastMinute() {
        return this.averageSuccessLatencyLastMinute.getAverage();
    }

    public double getAverageSuccessLatencyLastHour() {
        return this.averageSuccessLatencyLastHour.getAverage();
    }

    public double getAverageSuccessLatencyLastDay() {
        return this.averageSuccessLatencyLastDay.getAverage();
    }

    public double getAverageFailureLatencyLastMinute() {
        return this.averageFailureLatencyLastMinute.getAverage();
    }

    public double getAverageFailureLatencyLastHour() {
        return this.averageFailureLatencyLastHour.getAverage();
    }

    public double getAverageFailureLatencyLastDay() {
        return this.averageFailureLatencyLastDay.getAverage();
    }

    public double getTotalRequestsPerSecondLastMinute() {
        return this.totalRequestsPerSecondLastMinute.getAverage();
    }

    public double getSuccessRequestsPerSecondLastMinute() {
        return this.successRequestsPerSecondLastMinute.getAverage();
    }

    public double getFailureRequestsPerSecondLastMinute() {
        return this.failureRequestsPerSecondLastMinute.getAverage();
    }

    public double getTotalRequestsPerSecondLastHour() {
        return this.totalRequestsPerSecondLastHour.getAverage();
    }

    public double getSuccessRequestsPerSecondLastHour() {
        return this.successRequestsPerSecondLastHour.getAverage();
    }

    public double getFailureRequestsPerSecondLastHour() {
        return this.failureRequestsPerSecondLastHour.getAverage();
    }

    public double getTotalRequestsPerSecondLastDay() {
        return this.totalRequestsPerSecondLastDay.getAverage();
    }

    public double getSuccessRequestsPerSecondLastDay() {
        return this.successRequestsPerSecondLastDay.getAverage();
    }

    public double getFailureRequestsPerSecondLastDay() {
        return this.failureRequestsPerSecondLastDay.getAverage();
    }

    public double getTotalRequestsPerSecondLifetime() {
        long deltaT = System.currentTimeMillis() - this.startupMillis;
        return (double)this.requestCounter.sample()[0] / (double)deltaT * 1000.0;
    }

    public double getSuccessRequestsPerSecondLifetime() {
        long deltaT = System.currentTimeMillis() - this.startupMillis;
        return (double)this.requestCounter.sample()[1] / (double)deltaT * 1000.0;
    }

    public double getFailureRequestsPerSecondLifetime() {
        long deltaT = System.currentTimeMillis() - this.startupMillis;
        return (double)this.requestCounter.sample()[2] / (double)deltaT * 1000.0;
    }

    public RequestCounter getRequestCounter() {
        return this.requestCounter;
    }

    public long getRequestCount() {
        return this.requestCounter.sample()[0];
    }

    public long getSuccessCount() {
        return this.requestCounter.sample()[1];
    }

    public long getFailureCount() {
        return this.requestCounter.sample()[2];
    }

    public long getMedianPercentileSuccessLatencyLifetime() {
        return this.lifetimeSuccessLatencyQuantile.getPercentile(50);
    }

    public long get95thPercentileSuccessLatencyLifetime() {
        return this.lifetimeSuccessLatencyQuantile.getPercentile(95);
    }

    public long get99thPercentileSuccessLatencyLifetime() {
        return this.lifetimeSuccessLatencyQuantile.getPercentile(99);
    }

    public long getMaxSuccessLatencyLifetime() {
        return this.lifetimeMaxSuccessMillis;
    }

    public long getMedianPercentileSuccessLatencyLastMinute() {
        return this.successLatencyQuantileLastMinute.getPercentile(50);
    }

    public long get95thPercentileSuccessLatencyLastMinute() {
        return this.successLatencyQuantileLastMinute.getPercentile(95);
    }

    public long get99thPercentileSuccessLatencyLastMinute() {
        return this.successLatencyQuantileLastMinute.getPercentile(99);
    }

    public long getMedianPercentileSuccessfulLatencyLastHour() {
        return this.successLatencyQuantileLastHour.getPercentile(50);
    }

    public long get95thPercentileSuccessLatencyLastHour() {
        return this.successLatencyQuantileLastHour.getPercentile(95);
    }

    public long get99thPercentileSuccessLatencyLastHour() {
        return this.successLatencyQuantileLastHour.getPercentile(99);
    }

    public long getMedianPercentileSuccessLatencyLastDay() {
        return this.successLatencyQuantileLastDay.getPercentile(50);
    }

    public long get95thPercentileSuccessLatencyLastDay() {
        return this.successLatencyQuantileLastDay.getPercentile(95);
    }

    public long get99thPercentileSuccessLatencyLastDay() {
        return this.successLatencyQuantileLastDay.getPercentile(99);
    }

    public long getMedianPercentileFailureLatencyLifetime() {
        return this.lifetimeFailureLatencyQuantile.getPercentile(50);
    }

    public long get95thPercentileFailureLatencyLifetime() {
        return this.lifetimeFailureLatencyQuantile.getPercentile(95);
    }

    public long get99thPercentileFailureLatencyLifetime() {
        return this.lifetimeFailureLatencyQuantile.getPercentile(99);
    }

    public long getMaxFailureLatencyLifetime() {
        return this.lifetimeMaxFailureMillis;
    }

    public long getMedianPercentileFailureLatencyLastMinute() {
        return this.failureLatencyQuantileLastMinute.getPercentile(50);
    }

    public long get95thPercentileFailureLatencyLastMinute() {
        return this.failureLatencyQuantileLastMinute.getPercentile(95);
    }

    public long get99thPercentileFailureLatencyLastMinute() {
        return this.failureLatencyQuantileLastMinute.getPercentile(99);
    }

    public long getMedianPercentileFailureLatencyLastHour() {
        return this.failureLatencyQuantileLastHour.getPercentile(50);
    }

    public long get95thPercentileFailureLatencyLastHour() {
        return this.failureLatencyQuantileLastHour.getPercentile(95);
    }

    public long get99thPercentileFailureLatencyLastHour() {
        return this.failureLatencyQuantileLastHour.getPercentile(99);
    }

    public long getMedianPercentileFailureLatencyLastDay() {
        return this.failureLatencyQuantileLastDay.getPercentile(50);
    }

    public long get95thPercentileFailureLatencyLastDay() {
        return this.failureLatencyQuantileLastDay.getPercentile(95);
    }

    public long get99thPercentileFailureLatencyLastDay() {
        return this.failureLatencyQuantileLastDay.getPercentile(99);
    }
}

