/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.fishwife.jrugged.FailureInterpreter;
import org.fishwife.jrugged.PerformanceMonitor;
import org.fishwife.jrugged.RequestCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PercentErrPerTimeFailureInterpreter
implements FailureInterpreter {
    private Set<Class<? extends Throwable>> ignore = new HashSet<Class<? extends Throwable>>();
    private int percent = 0;
    private long windowMillis = 0L;
    private int requestThreshold = 0;
    private long previousRequestHighWaterMark = 0L;
    private List<Long> errorTimes = new LinkedList<Long>();
    private List<Long> requestCounts = new LinkedList<Long>();
    private final Object modificationLock = new Object();
    private RequestCounter requestCounter;
    private static Class[] defaultIgnore = new Class[0];

    public PercentErrPerTimeFailureInterpreter() {
        this.setIgnore(defaultIgnore);
        this.requestCounter = new RequestCounter();
    }

    public PercentErrPerTimeFailureInterpreter(RequestCounter rc, int percent, long windowMillis) {
        this.setIgnore(defaultIgnore);
        this.setPercent(percent);
        this.setWindowMillis(windowMillis);
        this.setRequestCounter(rc);
    }

    public PercentErrPerTimeFailureInterpreter(PerformanceMonitor p, int percent, long windowMillis) {
        this.setIgnore(defaultIgnore);
        this.setPercent(percent);
        this.setWindowMillis(windowMillis);
        this.setRequestCounter(p.getRequestCounter());
    }

    public PercentErrPerTimeFailureInterpreter(Class<? extends Throwable>[] ignore) {
        this.setIgnore(ignore);
    }

    public PercentErrPerTimeFailureInterpreter(RequestCounter rc, Class<? extends Throwable>[] ignore, int percent, long windowMillis) {
        this.setRequestCounter(rc);
        this.setIgnore(ignore);
        this.setPercent(percent);
        this.setWindowMillis(windowMillis);
    }

    private boolean hasWindowConditions() {
        return this.percent > 0 && this.windowMillis > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldTrip(Throwable cause) {
        if (this.isExceptionIgnorable(cause)) {
            return false;
        }
        if (this.hasWindowConditions()) {
            long numberOfErrorsAfter;
            Long currentRequestCount = -1L;
            Object object = this.modificationLock;
            synchronized (object) {
                this.errorTimes.add(System.currentTimeMillis());
                this.requestCounts.add(this.requestCounter.sample()[0]);
                long removeTimeBeforeMillis = System.currentTimeMillis() - this.windowMillis;
                int numberOfErrorsBefore = this.errorTimes.size();
                this.removeErrorsPriorToCutoffTime(numberOfErrorsBefore, removeTimeBeforeMillis);
                numberOfErrorsAfter = this.errorTimes.size();
                currentRequestCount = this.requestCounts.get(this.requestCounts.size() - 1);
            }
            long windowRequests = currentRequestCount - this.previousRequestHighWaterMark;
            return windowRequests >= (long)this.requestThreshold && (double)numberOfErrorsAfter / (double)windowRequests * 100.0 >= (double)this.percent;
        }
        return true;
    }

    private boolean isExceptionIgnorable(Throwable cause) {
        for (Class<? extends Throwable> clazz : this.ignore) {
            if (!clazz.isInstance(cause)) continue;
            return true;
        }
        return false;
    }

    private void removeErrorsPriorToCutoffTime(int numberOfErrorsBefore, long removeTimeBeforeMillis) {
        boolean windowRemoval = false;
        for (int j = numberOfErrorsBefore - 1; j >= 0; --j) {
            Long time = this.errorTimes.get(j);
            if (time >= removeTimeBeforeMillis) continue;
            if (!windowRemoval) {
                this.previousRequestHighWaterMark = this.requestCounts.get(j);
                windowRemoval = true;
            }
            this.errorTimes.remove(j);
            this.requestCounts.remove(j);
        }
    }

    public Set<Class<? extends Throwable>> getIgnore() {
        return this.ignore;
    }

    public synchronized void setIgnore(Class<? extends Throwable>[] ignore) {
        this.ignore = new HashSet<Class<? extends Throwable>>(Arrays.asList(ignore));
    }

    public int getPercent() {
        return this.percent;
    }

    public void setPercent(int percent) {
        this.percent = percent;
    }

    public long getWindowMillis() {
        return this.windowMillis;
    }

    public void setWindowMillis(long windowMillis) {
        this.windowMillis = windowMillis;
    }

    public void setRequestCounter(RequestCounter rc) {
        this.requestCounter = rc;
    }

    public void setRequestThreshold(int requestThreshold) {
        this.requestThreshold = requestThreshold;
    }
}

