/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.util.Clock;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;

public class RecordStatistics
implements DataSerializable {
    protected volatile int hits;
    protected long lastStoredTime;
    protected long expirationTime;

    public int getHits() {
        return this.hits;
    }

    public void setHits(int hits) {
        this.hits = hits;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    @SuppressWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="We have the guarantee that only the partition thread will call this method")
    public void access() {
        ++this.hits;
    }

    public void store() {
        this.lastStoredTime = Clock.currentTimeMillis();
    }

    public long getLastStoredTime() {
        return this.lastStoredTime;
    }

    public void setLastStoredTime(long lastStoredTime) {
        this.lastStoredTime = lastStoredTime;
    }

    public long size() {
        int numberOfLongVariables = 3;
        return 28L;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.hits);
        out.writeLong(this.lastStoredTime);
        out.writeLong(this.expirationTime);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.hits = in.readInt();
        this.lastStoredTime = in.readLong();
        this.expirationTime = in.readLong();
    }
}

