/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.region;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.hibernate.RegionCache;
import com.hazelcast.hibernate.region.AbstractHazelcastRegion;
import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.GeneralDataRegion;

public abstract class AbstractGeneralRegion<Cache extends RegionCache>
extends AbstractHazelcastRegion<Cache>
implements GeneralDataRegion {
    private final Cache cache;

    protected AbstractGeneralRegion(HazelcastInstance instance, String name, Properties props, Cache cache) {
        super(instance, name, props);
        this.cache = cache;
    }

    public void evict(Object key) throws CacheException {
        try {
            this.getCache().remove(key);
        }
        catch (OperationTimeoutException operationTimeoutException) {
            // empty catch block
        }
    }

    public void evictAll() throws CacheException {
        try {
            this.getCache().clear();
        }
        catch (OperationTimeoutException operationTimeoutException) {
            // empty catch block
        }
    }

    public Object get(Object key) throws CacheException {
        try {
            return this.getCache().get(key);
        }
        catch (OperationTimeoutException e) {
            return null;
        }
    }

    public void put(Object key, Object value) throws CacheException {
        try {
            this.getCache().put(key, value, null);
        }
        catch (OperationTimeoutException operationTimeoutException) {
            // empty catch block
        }
    }

    @Override
    public Cache getCache() {
        return this.cache;
    }
}

