/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.obs.api;

import com.openexchange.obs.api.Architecture;
import com.openexchange.obs.api.Binary;
import com.openexchange.obs.api.BinaryParser;
import com.openexchange.obs.api.BuildServiceException;
import com.openexchange.obs.api.DistroNaming;
import com.openexchange.obs.api.Flag;
import com.openexchange.obs.api.ObsPackage;
import com.openexchange.obs.api.ObsPackageParser;
import com.openexchange.obs.api.Project;
import com.openexchange.obs.api.ProjectParser;
import com.openexchange.obs.api.ProjectReference;
import com.openexchange.obs.api.ProjectWriter;
import com.openexchange.obs.api.Result;
import com.openexchange.obs.api.ResultParser;
import com.openexchange.obs.api.SourceFile;
import com.openexchange.obs.api.SourceFileParser;
import com.openexchange.obs.api.Status;
import com.openexchange.obs.api.Tools;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.net.ssl.SSLException;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class BuildServiceClient {
    private static final int MAX_RETRIES = 5;
    private final String login;
    private CloseableHttpClient httpclient;
    HttpClientContext localcontext;
    HttpHost targetHost;

    public BuildServiceClient(String url, String login, String password) throws BuildServiceException {
        URL tmpurl;
        this.login = login;
        try {
            tmpurl = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        this.targetHost = new HttpHost(tmpurl.getHost(), tmpurl.getPort(), tmpurl.getProtocol());
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(this.targetHost.getHostName(), this.targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(login, password));
        HttpRequestRetryHandler myRetryHandler = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                boolean idempotent;
                if (executionCount >= 5) {
                    return false;
                }
                if (exception instanceof NoHttpResponseException) {
                    return true;
                }
                if (exception instanceof SSLException) {
                    return false;
                }
                HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                HttpRequest request = clientContext.getRequest();
                boolean bl = idempotent = !(request instanceof HttpEntityEnclosingRequest);
                return idempotent;
            }
        };
        HttpClientBuilder builder = HttpClients.custom();
        if (Boolean.parseBoolean(System.getProperty("trust_all_cert"))) {
            this.addTrustAll(builder);
        }
        builder.setRetryHandler(myRetryHandler);
        this.httpclient = builder.build();
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(this.targetHost, (AuthScheme)basicAuth);
        this.localcontext = HttpClientContext.create();
        this.localcontext.setCredentialsProvider((CredentialsProvider)credsProvider);
        this.localcontext.setAuthCache((AuthCache)authCache);
    }

    private void addTrustAll(HttpClientBuilder builder) throws BuildServiceException {
        try {
            SSLContextBuilder sslctxbuilder = new SSLContextBuilder();
            sslctxbuilder.loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            });
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslctxbuilder.build(), SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER));
        }
        catch (NoSuchAlgorithmException e) {
            throw new BuildServiceException("Was not able to activate trust for all certificates.", e);
        }
        catch (KeyStoreException e) {
            throw new BuildServiceException("Was not able to activate trust for all certificates.", e);
        }
        catch (KeyManagementException e) {
            throw new BuildServiceException("Was not able to activate trust for all certificates.", e);
        }
    }

    private HttpEntity getEntity(HttpRequestBase method) throws ClientProtocolException, IOException, BuildServiceException {
        CloseableHttpResponse response = this.httpclient.execute(this.targetHost, (HttpRequest)method, (HttpContext)this.localcontext);
        BuildServiceClient.checkIfHttpStatusOk((HttpResponse)response);
        return response.getEntity();
    }

    private InputStream getResponseStream(HttpRequestBase method) throws BuildServiceException, IOException {
        HttpEntity entity = this.getEntity(method);
        return entity.getContent();
    }

    public InputStream getProjectBinaryPackageByName(String projectName, String repositoryName, Architecture arch, String packageName, String filename) throws BuildServiceException, IOException {
        HttpGet method = new HttpGet("/build/" + projectName + '/' + repositoryName + '/' + arch.toString() + '/' + packageName + '/' + filename);
        return this.getResponseStream((HttpRequestBase)method);
    }

    public String getPackageLogByName(String project, String repository, Architecture arch, String pkgName) throws BuildServiceException, IOException {
        HttpGet method = new HttpGet("/build/" + project + '/' + repository + '/' + arch.toString() + '/' + pkgName + "/_log");
        return EntityUtils.toString((HttpEntity)this.getEntity((HttpRequestBase)method));
    }

    private void uploadPackageMeta(String project, String pkgName, String[] disabledRepositories) throws BuildServiceException, IOException {
        String pkgmeta = this.getPackageMeta(project, pkgName, disabledRepositories);
        HttpPut pmethod = new HttpPut("/source/" + project + "/" + pkgName + "/_meta");
        pmethod.setEntity((HttpEntity)new StringEntity(pkgmeta, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8)));
        CloseableHttpResponse response = this.httpclient.execute(this.targetHost, (HttpRequest)pmethod, (HttpContext)this.localcontext);
        BuildServiceClient.consumeEntity((HttpResponse)response);
        BuildServiceClient.checkIfHttpStatusOk((HttpResponse)response);
    }

    public void deletePackage(String project, String pkgName) throws BuildServiceException {
        HttpDelete method = new HttpDelete("/source/" + project + "/" + pkgName);
        try {
            CloseableHttpResponse response = this.httpclient.execute(this.targetHost, (HttpRequest)method, (HttpContext)this.localcontext);
            BuildServiceClient.checkIfHttpStatusOk((HttpResponse)response);
            BuildServiceClient.consumeEntity((HttpResponse)response);
        }
        catch (IOException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadSource(String project, String pkgName, File file) throws BuildServiceException, IOException {
        CloseableHttpResponse response;
        HttpPut pmethod = new HttpPut("/source/" + project + "/" + pkgName + "/" + file.getName() + "?rev=upload");
        FileInputStream fis = new FileInputStream(file);
        try {
            pmethod.setEntity((HttpEntity)new InputStreamEntity((InputStream)fis, -1L));
            response = this.httpclient.execute(this.targetHost, (HttpRequest)pmethod, (HttpContext)this.localcontext);
        }
        finally {
            fis.close();
        }
        BuildServiceClient.consumeEntity((HttpResponse)response);
        BuildServiceClient.checkIfHttpStatusOk((HttpResponse)response);
    }

    private void commit(String project, String pkgName) throws BuildServiceException, IOException {
        HttpPost pmethod = new HttpPost("/source/" + project + "/" + pkgName + "?cmd=commit");
        CloseableHttpResponse response = this.httpclient.execute(this.targetHost, (HttpRequest)pmethod, (HttpContext)this.localcontext);
        BuildServiceClient.consumeEntity((HttpResponse)response);
        BuildServiceClient.checkIfHttpStatusOk((HttpResponse)response);
    }

    private void deleteSource(String projectName, String pkgName, String fileName) throws BuildServiceException, IOException {
        HttpDelete dmethod = new HttpDelete("/source/" + projectName + "/" + pkgName + "/" + fileName);
        CloseableHttpResponse response = this.httpclient.execute(this.targetHost, (HttpRequest)dmethod, (HttpContext)this.localcontext);
        BuildServiceClient.consumeEntity((HttpResponse)response);
        BuildServiceClient.checkIfHttpStatusOk((HttpResponse)response);
    }

    private String getPackageMeta(String project, String pkgname, String[] disabledRepositories) throws BuildServiceException {
        StringBuilder sb = new StringBuilder();
        sb.append("<package project=\"" + project + "\" name=\"" + pkgname + "\">\n<title>" + pkgname + "</title>\n<description/>\n<person role=\"maintainer\" userid=\"" + this.login + "\"/>\n");
        if (disabledRepositories != null && disabledRepositories.length > 0) {
            sb.append("<build>\n");
            for (String s : disabledRepositories) {
                sb.append("<disable repository=\"" + DistroNaming.parse(s).getOBSName() + "\"/>\n");
            }
            sb.append("</build>\n");
        }
        sb.append("</package>");
        return sb.toString();
    }

    public void uploadSourcePackage(String project, String pkgname, String path, String[] disabledRepositories) throws IOException, BuildServiceException {
        File sdir = new File(path);
        if (!sdir.isDirectory()) {
            throw new BuildServiceException("path \"" + sdir.getAbsolutePath() + "\" is not a directory");
        }
        File[] files = sdir.listFiles();
        if (null == files) {
            throw new BuildServiceException("Listing files in directory " + sdir.getAbsolutePath() + " failed.");
        }
        this.uploadSourcePackage(project, pkgname, files, disabledRepositories);
    }

    public void uploadSourcePackage(String project, String pkgName, File[] files, String[] disabledRepositories) throws IOException, BuildServiceException {
        if (!this.existsProject(project)) {
            throw new BuildServiceException("Project " + project + " does not exist on build service.");
        }
        this.uploadPackageMeta(project, pkgName, disabledRepositories);
        SourceFile[] sourceFiles = this.getPackageSourceNames(project, pkgName);
        HashMap<String, SourceFile> currentSourceNamesHash = new HashMap<String, SourceFile>();
        for (int i = 0; i < sourceFiles.length; ++i) {
            currentSourceNamesHash.put(sourceFiles[i].getName(), sourceFiles[i]);
        }
        for (File f : files) {
            if (currentSourceNamesHash.containsKey(f.getName())) {
                System.out.println("Uploading " + f.getPath() + " to " + project);
                this.uploadSource(project, pkgName, f);
                currentSourceNamesHash.remove(f.getName());
                continue;
            }
            System.out.println("Uploading " + f.getPath() + " to " + project);
            this.uploadSource(project, pkgName, f);
        }
        Collection notNeededSourceFiles = currentSourceNamesHash.values();
        for (SourceFile s : notNeededSourceFiles) {
            System.out.println("Removing " + s.getName() + " from " + project);
            this.deleteSource(project, pkgName, s.getName());
        }
        this.commit(project, pkgName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Binary[] getProjectBinaryPackageNames(String projectName, String repositoryName, Architecture arch, String packageName) throws IOException, BuildServiceException {
        HttpGet method = new HttpGet("/build/" + projectName + '/' + repositoryName + '/' + arch.toString() + '/' + packageName);
        InputStream is = this.getResponseStream((HttpRequestBase)method);
        try {
            Binary[] binaryArray = BinaryParser.parse(is);
            return binaryArray;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SourceFile[] getPackageSourceNames(String project, String pkgname) throws BuildServiceException {
        HttpGet method = new HttpGet("/source/" + project + "/" + pkgname);
        int retries = 5;
        SourceFile[] sourceFiles = null;
        do {
            BuildServiceException exception = null;
            --retries;
            InputStream is = null;
            try {
                is = this.getResponseStream((HttpRequestBase)method);
                sourceFiles = SourceFileParser.parse(is);
            }
            catch (IOException e) {
                exception = new BuildServiceException(e.getMessage(), e);
            }
            catch (BuildServiceException e) {
                exception = e;
            }
            finally {
                block18: {
                    if (null != is) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            if (null != exception) break block18;
                            exception = new BuildServiceException(e.getMessage(), e);
                        }
                    }
                }
            }
            if (null == exception || retries != 0) continue;
            throw exception;
        } while (null == sourceFiles);
        return sourceFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObsPackage[] getPackageList(String project) throws BuildServiceException {
        HttpGet method = new HttpGet("/source/" + project);
        int retries = 5;
        ObsPackage[] results = null;
        do {
            BuildServiceException exception = null;
            --retries;
            try {
                InputStream is = this.getResponseStream((HttpRequestBase)method);
                try {
                    results = ObsPackageParser.parse(is);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                exception = new BuildServiceException(e.getMessage(), e);
            }
            catch (BuildServiceException e) {
                exception = e;
            }
            if (null == exception || retries != 0) continue;
            throw exception;
        } while (null == results);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result[] getProjectStatus(String project, Collection<String> packageNames) throws BuildServiceException {
        StringBuilder sb = new StringBuilder();
        if (packageNames != null && packageNames.size() > 0) {
            sb.append("?");
            for (String packageName : packageNames) {
                sb.append("package=");
                sb.append(packageName);
                sb.append('&');
            }
            sb.setLength(sb.length() - 1);
        }
        HttpGet method = new HttpGet("/build/" + project + "/_result" + sb.toString());
        int retries = 5;
        Result[] results = null;
        do {
            BuildServiceException exception = null;
            --retries;
            InputStream is = null;
            try {
                is = this.getResponseStream((HttpRequestBase)method);
                results = ResultParser.parse(is);
            }
            catch (IOException e) {
                exception = new BuildServiceException(e.getMessage(), e);
            }
            catch (BuildServiceException e) {
                exception = e;
            }
            finally {
                if (null != is) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (null == exception || retries != 0) continue;
            throw exception;
        } while (null == results);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsProject(Project project) throws BuildServiceException {
        boolean bl;
        HttpGet method = new HttpGet("/source/" + project.getName() + "/_meta");
        CloseableHttpResponse response = this.httpclient.execute(this.targetHost, (HttpRequest)method, (HttpContext)this.localcontext);
        if (404 == response.getStatusLine().getStatusCode()) {
            BuildServiceClient.consumeEntity((HttpResponse)response);
            return false;
        }
        BuildServiceClient.checkIfHttpStatusOk((HttpResponse)response);
        HttpEntity entity = response.getEntity();
        InputStream is = entity.getContent();
        try {
            Project other = ProjectParser.parse(is);
            bl = other.equals(project);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new BuildServiceException(e.getMessage(), e);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new BuildServiceException(e.getMessage(), e);
            }
        }
        try {
            is.close();
        }
        catch (IOException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        return bl;
    }

    public boolean existsProject(String project) throws BuildServiceException {
        HttpGet method = new HttpGet("/source/" + project + "/_meta");
        try {
            CloseableHttpResponse response = this.httpclient.execute(this.targetHost, (HttpRequest)method, (HttpContext)this.localcontext);
            if (404 == response.getStatusLine().getStatusCode()) {
                BuildServiceClient.consumeEntity((HttpResponse)response);
                return false;
            }
            if (200 == response.getStatusLine().getStatusCode()) {
                BuildServiceClient.consumeEntity((HttpResponse)response);
                return true;
            }
            BuildServiceClient.checkIfHttpStatusOk((HttpResponse)response);
            BuildServiceClient.consumeEntity((HttpResponse)response);
            return false;
        }
        catch (IOException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
    }

    private void writeProjectMeta(String project, String data) throws BuildServiceException {
        HttpPut method1 = new HttpPut("/source/" + project + "/_meta");
        try {
            method1.setEntity((HttpEntity)new StringEntity(data, ContentType.create((String)"text/xml", (Charset)Consts.UTF_8)));
            CloseableHttpResponse response = this.httpclient.execute(this.targetHost, (HttpRequest)method1, (HttpContext)this.localcontext);
            BuildServiceClient.checkIfHttpStatusOk((HttpResponse)response);
            BuildServiceClient.consumeEntity((HttpResponse)response);
        }
        catch (IOException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
    }

    public void createProject(Project project) throws BuildServiceException {
        String xml = Tools.transform(ProjectWriter.write(project));
        this.writeProjectMeta(project.getName(), xml);
        HttpPut method2 = new HttpPut("/source/" + project.getName() + "/_config");
        try {
            method2.setEntity((HttpEntity)new StringEntity(project.getBuildConfiguration()));
            CloseableHttpResponse response = this.httpclient.execute(this.targetHost, (HttpRequest)method2, (HttpContext)this.localcontext);
            BuildServiceClient.checkIfHttpStatusOk((HttpResponse)response);
            BuildServiceClient.consumeEntity((HttpResponse)response);
        }
        catch (IOException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
    }

    public void copyProject(String project, String OldProject) throws BuildServiceException {
        HttpPost method = new HttpPost("/source/" + project);
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(1);
        nameValuePairs.add(new BasicNameValuePair("cmd", "copy"));
        nameValuePairs.add(new BasicNameValuePair("oproject", OldProject));
        nameValuePairs.add(new BasicNameValuePair("withhistory", "1"));
        nameValuePairs.add(new BasicNameValuePair("withbinaries", "1"));
        nameValuePairs.add(new BasicNameValuePair("resign", "1"));
        nameValuePairs.add(new BasicNameValuePair("nodelay", "1"));
        try {
            method.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
            CloseableHttpResponse response = this.httpclient.execute(this.targetHost, (HttpRequest)method, (HttpContext)this.localcontext);
            BuildServiceClient.checkIfHttpStatusOk((HttpResponse)response);
            BuildServiceClient.consumeEntity((HttpResponse)response);
        }
        catch (IOException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
    }

    public void deleteProject(String projectName) throws BuildServiceException {
        HttpDelete request = new HttpDelete("/source/" + projectName);
        try {
            CloseableHttpResponse response = this.httpclient.execute(this.targetHost, (HttpRequest)request, (HttpContext)this.localcontext);
            BuildServiceClient.checkIfHttpStatusOk((HttpResponse)response);
            BuildServiceClient.consumeEntity((HttpResponse)response);
        }
        catch (IOException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
    }

    public void deleteProject(String projectName, String commitMessage) throws BuildServiceException {
        try {
            HttpDelete request = new HttpDelete("/source/" + projectName + "?comment=" + URLEncoder.encode(commitMessage, "UTF-8"));
            CloseableHttpResponse response = this.httpclient.execute(this.targetHost, (HttpRequest)request, (HttpContext)this.localcontext);
            BuildServiceClient.checkIfHttpStatusOk((HttpResponse)response);
            BuildServiceClient.consumeEntity((HttpResponse)response);
        }
        catch (IOException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
    }

    public void disableProject(Project project) throws BuildServiceException {
        this.disableProject(project.getName());
    }

    public void disableProject(String project) throws BuildServiceException {
        this.setFlagForProject(project, Flag.BUILD, Status.DISABLE);
        this.setFlagForProject(project, Flag.PUBLISH, Status.DISABLE);
    }

    public void setFlagForProject(String project, Flag flag, Status status) throws BuildServiceException {
        HttpPost method = new HttpPost("/source/" + project);
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(1);
        nameValuePairs.add(new BasicNameValuePair("cmd", "set_flag"));
        nameValuePairs.add(new BasicNameValuePair("flag", flag.name().toLowerCase()));
        nameValuePairs.add(new BasicNameValuePair("status", status.name().toLowerCase()));
        nameValuePairs.add(new BasicNameValuePair("nodelay", "1"));
        try {
            method.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
            CloseableHttpResponse response = this.httpclient.execute(this.targetHost, (HttpRequest)method, (HttpContext)this.localcontext);
            BuildServiceClient.checkIfHttpStatusOk((HttpResponse)response);
            BuildServiceClient.consumeEntity((HttpResponse)response);
        }
        catch (IOException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProjectDisabled(Project project) throws BuildServiceException, IOException {
        InputStream is = this.getProjectInputStream(project.getName());
        try {
            boolean bl = ProjectParser.isDisabled(is);
            return bl;
        }
        finally {
            is.close();
        }
    }

    public String getProjectConfig(String project) throws BuildServiceException {
        HttpGet method = new HttpGet("/source/" + project + "/_config");
        try {
            return EntityUtils.toString((HttpEntity)this.getEntity((HttpRequestBase)method));
        }
        catch (IOException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectReference[] getProjectList() throws BuildServiceException {
        HttpGet method = new HttpGet("/source");
        int retries = 5;
        ProjectReference[] results = null;
        do {
            BuildServiceException exception = null;
            --retries;
            try {
                InputStream is = this.getResponseStream((HttpRequestBase)method);
                try {
                    results = ProjectParser.parseAll(is);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                exception = new BuildServiceException(e.getMessage(), e);
            }
            catch (BuildServiceException e) {
                exception = e;
            }
            if (null == exception || retries != 0) continue;
            throw exception;
        } while (null == results);
        return results;
    }

    private InputStream getProjectInputStream(String project) throws BuildServiceException {
        HttpGet method = new HttpGet("/source/" + project + "/_meta");
        BuildServiceException exception = new BuildServiceException("unable to get project metadata for " + project);
        for (int i = 0; i < 5; ++i) {
            try {
                return this.getResponseStream((HttpRequestBase)method);
            }
            catch (IOException e) {
                exception = new BuildServiceException(e.getMessage(), e);
                continue;
            }
            catch (BuildServiceException e) {
                exception = e;
            }
        }
        throw exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project getRepositoryList(String projectName) throws BuildServiceException {
        int retries = 5;
        Project project = null;
        do {
            BuildServiceException exception = null;
            --retries;
            InputStream is = this.getProjectInputStream(projectName);
            try {
                project = ProjectParser.parse(is);
            }
            catch (BuildServiceException e) {
                exception = e;
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new BuildServiceException(e.getMessage(), e);
                }
            }
            if (null == exception || retries != 0) continue;
            throw exception;
        } while (null == project);
        return project;
    }

    private static void consumeEntity(HttpResponse response) throws IOException {
        EntityUtils.consume((HttpEntity)response.getEntity());
    }

    private static void checkIfHttpStatusOk(HttpResponse response) throws BuildServiceException, IOException {
        if (response.getStatusLine().getStatusCode() != 200) {
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            BuildServiceClient.consumeEntity(response);
            throw new BuildServiceException(response.getStatusLine().toString() + " : " + responseString);
        }
    }
}

