/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.PathRootError;
import com.dropbox.core.v2.sharing.SharedFolderMetadata;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class SharePathError {
    public static final SharePathError IS_FILE = new SharePathError(Tag.IS_FILE, null, null);
    public static final SharePathError INSIDE_SHARED_FOLDER = new SharePathError(Tag.INSIDE_SHARED_FOLDER, null, null);
    public static final SharePathError CONTAINS_SHARED_FOLDER = new SharePathError(Tag.CONTAINS_SHARED_FOLDER, null, null);
    public static final SharePathError CONTAINS_APP_FOLDER = new SharePathError(Tag.CONTAINS_APP_FOLDER, null, null);
    public static final SharePathError CONTAINS_TEAM_FOLDER = new SharePathError(Tag.CONTAINS_TEAM_FOLDER, null, null);
    public static final SharePathError IS_APP_FOLDER = new SharePathError(Tag.IS_APP_FOLDER, null, null);
    public static final SharePathError INSIDE_APP_FOLDER = new SharePathError(Tag.INSIDE_APP_FOLDER, null, null);
    public static final SharePathError IS_PUBLIC_FOLDER = new SharePathError(Tag.IS_PUBLIC_FOLDER, null, null);
    public static final SharePathError INSIDE_PUBLIC_FOLDER = new SharePathError(Tag.INSIDE_PUBLIC_FOLDER, null, null);
    public static final SharePathError INVALID_PATH = new SharePathError(Tag.INVALID_PATH, null, null);
    public static final SharePathError IS_OSX_PACKAGE = new SharePathError(Tag.IS_OSX_PACKAGE, null, null);
    public static final SharePathError INSIDE_OSX_PACKAGE = new SharePathError(Tag.INSIDE_OSX_PACKAGE, null, null);
    public static final SharePathError OTHER = new SharePathError(Tag.OTHER, null, null);
    private final Tag _tag;
    private final SharedFolderMetadata alreadySharedValue;
    private final PathRootError invalidPathRootValue;

    private SharePathError(Tag _tag, SharedFolderMetadata alreadySharedValue, PathRootError invalidPathRootValue) {
        this._tag = _tag;
        this.alreadySharedValue = alreadySharedValue;
        this.invalidPathRootValue = invalidPathRootValue;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isIsFile() {
        return this._tag == Tag.IS_FILE;
    }

    public boolean isInsideSharedFolder() {
        return this._tag == Tag.INSIDE_SHARED_FOLDER;
    }

    public boolean isContainsSharedFolder() {
        return this._tag == Tag.CONTAINS_SHARED_FOLDER;
    }

    public boolean isContainsAppFolder() {
        return this._tag == Tag.CONTAINS_APP_FOLDER;
    }

    public boolean isContainsTeamFolder() {
        return this._tag == Tag.CONTAINS_TEAM_FOLDER;
    }

    public boolean isIsAppFolder() {
        return this._tag == Tag.IS_APP_FOLDER;
    }

    public boolean isInsideAppFolder() {
        return this._tag == Tag.INSIDE_APP_FOLDER;
    }

    public boolean isIsPublicFolder() {
        return this._tag == Tag.IS_PUBLIC_FOLDER;
    }

    public boolean isInsidePublicFolder() {
        return this._tag == Tag.INSIDE_PUBLIC_FOLDER;
    }

    public boolean isAlreadyShared() {
        return this._tag == Tag.ALREADY_SHARED;
    }

    public static SharePathError alreadyShared(SharedFolderMetadata value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new SharePathError(Tag.ALREADY_SHARED, value, null);
    }

    public SharedFolderMetadata getAlreadySharedValue() {
        if (this._tag != Tag.ALREADY_SHARED) {
            throw new IllegalStateException("Invalid tag: required Tag.ALREADY_SHARED, but was Tag." + this._tag.name());
        }
        return this.alreadySharedValue;
    }

    public boolean isInvalidPath() {
        return this._tag == Tag.INVALID_PATH;
    }

    public boolean isIsOsxPackage() {
        return this._tag == Tag.IS_OSX_PACKAGE;
    }

    public boolean isInsideOsxPackage() {
        return this._tag == Tag.INSIDE_OSX_PACKAGE;
    }

    public boolean isInvalidPathRoot() {
        return this._tag == Tag.INVALID_PATH_ROOT;
    }

    public static SharePathError invalidPathRoot(PathRootError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new SharePathError(Tag.INVALID_PATH_ROOT, null, value);
    }

    public PathRootError getInvalidPathRootValue() {
        if (this._tag != Tag.INVALID_PATH_ROOT) {
            throw new IllegalStateException("Invalid tag: required Tag.INVALID_PATH_ROOT, but was Tag." + this._tag.name());
        }
        return this.invalidPathRootValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.alreadySharedValue, this.invalidPathRootValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SharePathError) {
            SharePathError other = (SharePathError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case IS_FILE: {
                    return true;
                }
                case INSIDE_SHARED_FOLDER: {
                    return true;
                }
                case CONTAINS_SHARED_FOLDER: {
                    return true;
                }
                case CONTAINS_APP_FOLDER: {
                    return true;
                }
                case CONTAINS_TEAM_FOLDER: {
                    return true;
                }
                case IS_APP_FOLDER: {
                    return true;
                }
                case INSIDE_APP_FOLDER: {
                    return true;
                }
                case IS_PUBLIC_FOLDER: {
                    return true;
                }
                case INSIDE_PUBLIC_FOLDER: {
                    return true;
                }
                case ALREADY_SHARED: {
                    return this.alreadySharedValue == other.alreadySharedValue || this.alreadySharedValue.equals(other.alreadySharedValue);
                }
                case INVALID_PATH: {
                    return true;
                }
                case IS_OSX_PACKAGE: {
                    return true;
                }
                case INSIDE_OSX_PACKAGE: {
                    return true;
                }
                case INVALID_PATH_ROOT: {
                    return this.invalidPathRootValue == other.invalidPathRootValue || this.invalidPathRootValue.equals(other.invalidPathRootValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<SharePathError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SharePathError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case IS_FILE: {
                    g.writeString("is_file");
                    break;
                }
                case INSIDE_SHARED_FOLDER: {
                    g.writeString("inside_shared_folder");
                    break;
                }
                case CONTAINS_SHARED_FOLDER: {
                    g.writeString("contains_shared_folder");
                    break;
                }
                case CONTAINS_APP_FOLDER: {
                    g.writeString("contains_app_folder");
                    break;
                }
                case CONTAINS_TEAM_FOLDER: {
                    g.writeString("contains_team_folder");
                    break;
                }
                case IS_APP_FOLDER: {
                    g.writeString("is_app_folder");
                    break;
                }
                case INSIDE_APP_FOLDER: {
                    g.writeString("inside_app_folder");
                    break;
                }
                case IS_PUBLIC_FOLDER: {
                    g.writeString("is_public_folder");
                    break;
                }
                case INSIDE_PUBLIC_FOLDER: {
                    g.writeString("inside_public_folder");
                    break;
                }
                case ALREADY_SHARED: {
                    g.writeStartObject();
                    this.writeTag("already_shared", g);
                    SharedFolderMetadata.Serializer.INSTANCE.serialize(value.alreadySharedValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case INVALID_PATH: {
                    g.writeString("invalid_path");
                    break;
                }
                case IS_OSX_PACKAGE: {
                    g.writeString("is_osx_package");
                    break;
                }
                case INSIDE_OSX_PACKAGE: {
                    g.writeString("inside_osx_package");
                    break;
                }
                case INVALID_PATH_ROOT: {
                    g.writeStartObject();
                    this.writeTag("invalid_path_root", g);
                    PathRootError.Serializer.INSTANCE.serialize(value.invalidPathRootValue, g, true);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public SharePathError deserialize(JsonParser p) throws IOException, JsonParseException {
            SharePathError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("is_file".equals(tag)) {
                value = IS_FILE;
            } else if ("inside_shared_folder".equals(tag)) {
                value = INSIDE_SHARED_FOLDER;
            } else if ("contains_shared_folder".equals(tag)) {
                value = CONTAINS_SHARED_FOLDER;
            } else if ("contains_app_folder".equals(tag)) {
                value = CONTAINS_APP_FOLDER;
            } else if ("contains_team_folder".equals(tag)) {
                value = CONTAINS_TEAM_FOLDER;
            } else if ("is_app_folder".equals(tag)) {
                value = IS_APP_FOLDER;
            } else if ("inside_app_folder".equals(tag)) {
                value = INSIDE_APP_FOLDER;
            } else if ("is_public_folder".equals(tag)) {
                value = IS_PUBLIC_FOLDER;
            } else if ("inside_public_folder".equals(tag)) {
                value = INSIDE_PUBLIC_FOLDER;
            } else if ("already_shared".equals(tag)) {
                SharedFolderMetadata fieldValue = null;
                fieldValue = SharedFolderMetadata.Serializer.INSTANCE.deserialize(p, true);
                value = SharePathError.alreadyShared(fieldValue);
            } else if ("invalid_path".equals(tag)) {
                value = INVALID_PATH;
            } else if ("is_osx_package".equals(tag)) {
                value = IS_OSX_PACKAGE;
            } else if ("inside_osx_package".equals(tag)) {
                value = INSIDE_OSX_PACKAGE;
            } else if ("invalid_path_root".equals(tag)) {
                PathRootError fieldValue = null;
                fieldValue = PathRootError.Serializer.INSTANCE.deserialize(p, true);
                value = SharePathError.invalidPathRoot(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        IS_FILE,
        INSIDE_SHARED_FOLDER,
        CONTAINS_SHARED_FOLDER,
        CONTAINS_APP_FOLDER,
        CONTAINS_TEAM_FOLDER,
        IS_APP_FOLDER,
        INSIDE_APP_FOLDER,
        IS_PUBLIC_FOLDER,
        INSIDE_PUBLIC_FOLDER,
        ALREADY_SHARED,
        INVALID_PATH,
        IS_OSX_PACKAGE,
        INSIDE_OSX_PACKAGE,
        INVALID_PATH_ROOT,
        OTHER;

    }
}

