/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import java.io.IOException;
import java.io.InputStream;

public final class NoThrowInputStream
extends InputStream {
    private final InputStream underlying;
    private long bytesRead = 0L;

    public NoThrowInputStream(InputStream underlying) {
        this.underlying = underlying;
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("don't call close()");
    }

    @Override
    public int read() {
        try {
            ++this.bytesRead;
            return this.underlying.read();
        }
        catch (IOException ex) {
            throw new HiddenException(ex);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) {
        try {
            int bytesReadNow = this.underlying.read(b, off, len);
            this.bytesRead += (long)bytesReadNow;
            return bytesReadNow;
        }
        catch (IOException ex) {
            throw new HiddenException(ex);
        }
    }

    @Override
    public int read(byte[] b) {
        try {
            int bytesReadNow = this.underlying.read(b);
            this.bytesRead += (long)bytesReadNow;
            return bytesReadNow;
        }
        catch (IOException ex) {
            throw new HiddenException(ex);
        }
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public static final class HiddenException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;

        public HiddenException(IOException underlying) {
            super(underlying);
        }

        @Override
        public IOException getCause() {
            return (IOException)super.getCause();
        }
    }
}

