/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.inifile;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import net.sf.antcontrib.inifile.IniFile;
import net.sf.antcontrib.inifile.IniProperty;
import net.sf.antcontrib.inifile.IniSection;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;

public class IniFileTask
extends Task {
    private File source;
    private File dest;
    private Vector operations = new Vector();

    public Set createSet() {
        Set set = new Set();
        this.operations.add(set);
        return set;
    }

    public Remove createRemove() {
        Remove remove = new Remove();
        this.operations.add(remove);
        return remove;
    }

    public Exists createExists() {
        Exists exists = new Exists();
        this.operations.add(exists);
        return exists;
    }

    public Get createGet() {
        Get get = new Get();
        this.operations.add(get);
        return get;
    }

    public void setSource(File source) {
        this.source = source;
    }

    public void setDest(File dest) {
        this.dest = dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.dest == null) {
            throw new BuildException("You must supply a dest file to write to.");
        }
        IniFile iniFile = null;
        try {
            iniFile = this.readIniFile(this.source);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        Iterator it = this.operations.iterator();
        IniOperation operation = null;
        while (it.hasNext()) {
            operation = (IniOperation)it.next();
            operation.execute(this.getProject(), iniFile);
        }
        FileWriter writer = null;
        try {
            try {
                writer = new FileWriter(this.dest);
                iniFile.write(writer);
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IniFile readIniFile(File source) throws IOException {
        FileReader reader = null;
        IniFile iniFile = new IniFile();
        if (source == null) {
            return iniFile;
        }
        try {
            reader = new FileReader(source);
            iniFile.read(reader);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
        return iniFile;
    }

    public final class Get
    extends IniOperationPropertySetter {
        protected void operate(IniFile file) {
            String secName = this.getSection();
            String propName = this.getProperty();
            if (secName == null) {
                throw new BuildException("You must supply a section to search for.");
            }
            if (propName == null) {
                throw new BuildException("You must supply a property name to search for.");
            }
            this.setResultPropertyValue(IniFileTask.this.getProject(), file.getProperty(secName, propName));
        }
    }

    public final class Exists
    extends IniOperationPropertySetter {
        protected void operate(IniFile file) {
            boolean exists = false;
            String secName = this.getSection();
            String propName = this.getProperty();
            if (secName == null) {
                throw new BuildException("You must supply a section to search for.");
            }
            exists = propName == null ? file.getSection(secName) != null : file.getProperty(secName, propName) != null;
            this.setResultPropertyValue(IniFileTask.this.getProject(), Boolean.valueOf(exists).toString());
        }
    }

    public final class Set
    extends IniOperationConditional {
        private String value;
        private String operation;

        public void setValue(String value) {
            this.value = value;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        protected void operate(IniFile file) {
            String secName = this.getSection();
            String propName = this.getProperty();
            IniSection section = file.getSection(secName);
            if (section == null) {
                section = new IniSection(secName);
                file.setSection(section);
            }
            if (propName != null) {
                if (this.operation != null) {
                    if ("+".equals(this.operation)) {
                        IniProperty prop = section.getProperty(propName);
                        this.value = prop.getValue();
                        int intVal = Integer.parseInt(this.value) + 1;
                        this.value = String.valueOf(intVal);
                    } else if ("-".equals(this.operation)) {
                        IniProperty prop = section.getProperty(propName);
                        this.value = prop.getValue();
                        int intVal = Integer.parseInt(this.value) - 1;
                        this.value = String.valueOf(intVal);
                    }
                }
                section.setProperty(new IniProperty(propName, this.value));
            }
        }
    }

    public static final class Remove
    extends IniOperationConditional {
        protected void operate(IniFile file) {
            String secName = this.getSection();
            String propName = this.getProperty();
            if (propName == null) {
                file.removeSection(secName);
            } else {
                IniSection section = file.getSection(secName);
                if (section != null) {
                    section.removeProperty(propName);
                }
            }
        }
    }

    public static abstract class IniOperationPropertySetter
    extends IniOperation {
        private boolean override;
        private String resultproperty;

        public void setOverride(boolean override) {
            this.override = override;
        }

        public void setResultProperty(String resultproperty) {
            this.resultproperty = resultproperty;
        }

        protected final void setResultPropertyValue(Project project, String value) {
            if (value != null) {
                if (this.override) {
                    if (project.getUserProperty(this.resultproperty) == null) {
                        project.setProperty(this.resultproperty, value);
                    } else {
                        project.setUserProperty(this.resultproperty, value);
                    }
                } else {
                    Property p = (Property)project.createTask("property");
                    p.setName(this.resultproperty);
                    p.setValue(value);
                    p.execute();
                }
            }
        }
    }

    public static abstract class IniOperationConditional
    extends IniOperation {
        private String ifCond;
        private String unlessCond;

        public void setIf(String ifCond) {
            this.ifCond = ifCond;
        }

        public void setUnless(String unlessCond) {
            this.unlessCond = unlessCond;
        }

        public boolean isActive(Project p) {
            if (this.ifCond != null && p.getProperty(this.ifCond) == null) {
                return false;
            }
            return this.unlessCond == null || p.getProperty(this.unlessCond) == null;
        }

        public void execute(Project project, IniFile iniFile) {
            if (this.isActive(project)) {
                this.operate(iniFile);
            }
        }
    }

    public static abstract class IniOperation {
        private String section;
        private String property;

        public String getSection() {
            return this.section;
        }

        public void setSection(String section) {
            this.section = section;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public void execute(Project project, IniFile iniFile) {
            this.operate(iniFile);
        }

        protected abstract void operate(IniFile var1);
    }
}

