/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.jmx;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.GmbalMBean;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.jmxbase.GrizzlyJmxManager;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;

@ManagedObject
@Description(value="The HttpServer.")
public class HttpServer
extends JmxObject {
    private final org.glassfish.grizzly.http.server.HttpServer gws;
    private GrizzlyJmxManager mom;
    private final ConcurrentMap<String, NetworkListener> currentListeners = new ConcurrentHashMap<String, NetworkListener>(4);
    private final ConcurrentMap<String, Object> listenersJmx = new ConcurrentHashMap<String, Object>(4);

    public HttpServer(org.glassfish.grizzly.http.server.HttpServer gws) {
        this.gws = gws;
    }

    public String getJmxName() {
        return "HttpServer";
    }

    protected synchronized void onRegister(GrizzlyJmxManager mom, GmbalMBean bean) {
        this.mom = mom;
        this.rebuildSubTree();
    }

    protected synchronized void onDeregister(GrizzlyJmxManager mom) {
        this.mom = null;
    }

    @ManagedAttribute(id="started")
    @Description(value="Indicates whether or not this server instance has been started.")
    public boolean isStarted() {
        return this.gws.isStarted();
    }

    protected void rebuildSubTree() {
        for (NetworkListener l : this.gws.getListeners()) {
            NetworkListener currentListener = (NetworkListener)this.currentListeners.get(l.getName());
            if (currentListener == l) continue;
            if (currentListener != null) {
                Object listenerJmx = this.listenersJmx.get(l.getName());
                if (listenerJmx != null) {
                    this.mom.deregister(listenerJmx);
                }
                this.currentListeners.remove(l.getName());
                this.listenersJmx.remove(l.getName());
            }
            Object mmJmx = l.createManagementObject();
            this.mom.register((Object)this, mmJmx, "NetworkListener[" + l.getName() + ']');
            this.currentListeners.put(l.getName(), l);
            this.listenersJmx.put(l.getName(), mmJmx);
        }
    }
}

