/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns.server;

import com.turo.pushy.apns.server.BaseHttp2Server;
import com.turo.pushy.apns.server.MockApnsServerHandler;
import com.turo.pushy.apns.server.MockApnsServerListener;
import com.turo.pushy.apns.server.PushNotificationHandler;
import com.turo.pushy.apns.server.PushNotificationHandlerFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.ssl.SslContext;
import javax.net.ssl.SSLSession;

public class MockApnsServer
extends BaseHttp2Server {
    private final PushNotificationHandlerFactory handlerFactory;
    private final MockApnsServerListener listener;
    private final int maxConcurrentStreams;

    MockApnsServer(SslContext sslContext, EventLoopGroup eventLoopGroup, PushNotificationHandlerFactory handlerFactory, MockApnsServerListener listener, int maxConcurrentStreams) {
        super(sslContext, eventLoopGroup);
        this.handlerFactory = handlerFactory;
        this.listener = listener;
        this.maxConcurrentStreams = maxConcurrentStreams;
    }

    @Override
    protected void addHandlersToPipeline(SSLSession sslSession, ChannelPipeline pipeline) throws Exception {
        PushNotificationHandler pushNotificationHandler = this.handlerFactory.buildHandler(sslSession);
        MockApnsServerHandler serverHandler = new MockApnsServerHandler.MockApnsServerHandlerBuilder().pushNotificationHandler(pushNotificationHandler).initialSettings(Http2Settings.defaultSettings().maxConcurrentStreams((long)this.maxConcurrentStreams)).listener(this.listener).build();
        pipeline.addLast(new ChannelHandler[]{serverHandler});
    }
}

