/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.util.org.apache.commons.codec.net;

import ezvcard.util.org.apache.commons.codec.DecoderException;
import ezvcard.util.org.apache.commons.codec.EncoderException;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;

public class QuotedPrintableCodec {
    private static final byte ESCAPE_CHAR = 61;
    private static final byte TAB = 9;
    private static final byte SPACE = 32;
    private static final BitSet PRINTABLE_CHARS;
    private final String charset;

    public QuotedPrintableCodec(String charset) {
        this.charset = charset;
    }

    public String encode(String string) throws EncoderException {
        byte[] bytes;
        try {
            bytes = string.getBytes(this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new EncoderException(e);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int n : bytes) {
            int b = n;
            if (b < 0) {
                b = 256 + b;
            }
            if (PRINTABLE_CHARS.get(b)) {
                buffer.write(b);
                continue;
            }
            QuotedPrintableCodec.encodeQuotedPrintable(b, buffer);
        }
        try {
            return new String(buffer.toByteArray(), "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new EncoderException(e);
        }
    }

    public String decode(String string) throws DecoderException {
        byte[] bytes;
        try {
            bytes = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new DecoderException(e);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b == 61) {
                try {
                    int u = QuotedPrintableCodec.digit16(bytes[++i]);
                    int l = QuotedPrintableCodec.digit16(bytes[++i]);
                    buffer.write((char)((u << 4) + l));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new DecoderException("Invalid quoted-printable encoding", e);
                }
            }
            buffer.write(b);
        }
        try {
            return new String(buffer.toByteArray(), this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new DecoderException(e);
        }
    }

    private static int digit16(byte b) throws DecoderException {
        int i = Character.digit((char)b, 16);
        if (i == -1) {
            throw new DecoderException("Invalid URL encoding: not a valid digit (radix 16): " + b);
        }
        return i;
    }

    private static void encodeQuotedPrintable(int b, ByteArrayOutputStream buffer) {
        buffer.write(61);
        char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
        char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
        buffer.write(hex1);
        buffer.write(hex2);
    }

    static {
        int i;
        PRINTABLE_CHARS = new BitSet(256);
        for (i = 33; i <= 60; ++i) {
            PRINTABLE_CHARS.set(i);
        }
        for (i = 62; i <= 126; ++i) {
            PRINTABLE_CHARS.set(i);
        }
        PRINTABLE_CHARS.set(9);
        PRINTABLE_CHARS.set(32);
    }
}

