/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.text;

import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.CannotParseException;
import ezvcard.io.EmbeddedVCardException;
import ezvcard.io.SkipMeException;
import ezvcard.io.StreamReader;
import ezvcard.io.scribe.RawPropertyScribe;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.text.VCardParseException;
import ezvcard.io.text.VCardRawLine;
import ezvcard.io.text.VCardRawReader;
import ezvcard.parameter.Encoding;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.Label;
import ezvcard.property.RawProperty;
import ezvcard.property.VCardProperty;
import ezvcard.util.IOUtils;
import ezvcard.util.org.apache.commons.codec.DecoderException;
import ezvcard.util.org.apache.commons.codec.net.QuotedPrintableCodec;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class VCardReader
extends StreamReader {
    private final VCardRawReader reader;
    private Charset defaultQuotedPrintableCharset;

    public VCardReader(String str) {
        this(new StringReader(str));
    }

    public VCardReader(InputStream in) {
        this(new InputStreamReader(in));
    }

    public VCardReader(File file) throws FileNotFoundException {
        this(new BufferedReader(new FileReader(file)));
    }

    public VCardReader(Reader reader) {
        this.reader = new VCardRawReader(reader);
        this.defaultQuotedPrintableCharset = this.reader.getEncoding();
        if (this.defaultQuotedPrintableCharset == null) {
            this.defaultQuotedPrintableCharset = Charset.defaultCharset();
        }
    }

    public boolean isCaretDecodingEnabled() {
        return this.reader.isCaretDecodingEnabled();
    }

    public void setCaretDecodingEnabled(boolean enable) {
        this.reader.setCaretDecodingEnabled(enable);
    }

    public Charset getDefaultQuotedPrintableCharset() {
        return this.defaultQuotedPrintableCharset;
    }

    public void setDefaultQuotedPrintableCharset(Charset charset) {
        this.defaultQuotedPrintableCharset = charset;
    }

    public void setVersionAlias(String version, VCardVersion parseAccordingTo) {
        this.reader.setVersionAlias(version, parseAccordingTo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected VCard _readNext() throws IOException {
        VCard root = null;
        LinkedList<VCard> vcardStack = new LinkedList<VCard>();
        LinkedList labelStack = new LinkedList();
        EmbeddedVCardException embeddedVCardException = null;
        while (true) {
            VCardProperty property;
            VCardDataType dataType;
            VCardRawLine line;
            try {
                line = this.reader.readLine();
            }
            catch (VCardParseException e) {
                if (vcardStack.isEmpty()) continue;
                this.warnings.add(e.getLineNumber(), null, 27, e.getMessage(), e.getLine());
                continue;
            }
            if (line == null) break;
            if ("BEGIN".equalsIgnoreCase(line.getName()) && "VCARD".equalsIgnoreCase(line.getValue())) {
                VCard vcard = new VCard();
                vcard.setVersion(this.reader.getVersion());
                vcardStack.add(vcard);
                labelStack.add(new ArrayList());
                if (root == null) {
                    root = vcard;
                }
                if (embeddedVCardException == null) continue;
                embeddedVCardException.injectVCard(vcard);
                embeddedVCardException = null;
                continue;
            }
            if (vcardStack.isEmpty()) continue;
            if ("VERSION".equalsIgnoreCase(line.getName())) {
                ((VCard)vcardStack.getLast()).setVersion(this.reader.getVersion());
                continue;
            }
            if ("END".equalsIgnoreCase(line.getName()) && "VCARD".equalsIgnoreCase(line.getValue())) {
                VCard curVCard = (VCard)vcardStack.removeLast();
                List labels = (List)labelStack.removeLast();
                this.assignLabels(curVCard, labels);
                if (!vcardStack.isEmpty()) continue;
                break;
            }
            String group = line.getGroup();
            VCardParameters parameters = line.getParameters();
            String name = line.getName();
            String value = line.getValue();
            if (embeddedVCardException != null) {
                embeddedVCardException.injectVCard(null);
                embeddedVCardException = null;
            }
            VCard curVCard = (VCard)vcardStack.getLast();
            VCardVersion version = curVCard.getVersion();
            this.processNamelessParameters(parameters);
            this.processQuotedMultivaluedTypeParams(parameters);
            try {
                value = this.decodeQuotedPrintableValue(name, parameters, value);
            }
            catch (DecoderException e) {
                this.warnings.add(this.reader.getLineNumber(), name, 38, e.getMessage());
            }
            RawPropertyScribe scribe = this.index.getPropertyScribe(name);
            if (scribe == null) {
                scribe = new RawPropertyScribe(name);
            }
            if ((dataType = parameters.getValue()) == null) {
                dataType = scribe.defaultDataType(version);
            } else {
                parameters.setValue(null);
            }
            try {
                VCardPropertyScribe.Result result = scribe.parseText(value, dataType, version, parameters);
                for (String warning : result.getWarnings()) {
                    this.warnings.add(this.reader.getLineNumber(), name, warning);
                }
                property = result.getProperty();
                property.setGroup(group);
                if (property instanceof Label) {
                    Label label = (Label)property;
                    ((List)labelStack.getLast()).add(label);
                    continue;
                }
                curVCard.addProperty(property);
            }
            catch (SkipMeException e) {
                this.warnings.add(this.reader.getLineNumber(), name, 22, e.getMessage());
            }
            catch (CannotParseException e) {
                this.warnings.add(this.reader.getLineNumber(), name, 25, value, e.getMessage());
                property = new RawProperty(name, value);
                property.setGroup(group);
                curVCard.addProperty(property);
            }
            catch (EmbeddedVCardException e) {
                block29: {
                    VCardReader agentReader;
                    property = e.getProperty();
                    if (value.length() == 0 || version == VCardVersion.V2_1) {
                        embeddedVCardException = e;
                    } else {
                        value = VCardPropertyScribe.unescape(value);
                        agentReader = new VCardReader(value);
                        agentReader.setScribeIndex(this.index);
                        VCard nestedVCard = agentReader.readNext();
                        if (nestedVCard != null) {
                            e.injectVCard(nestedVCard);
                        }
                        for (String w : agentReader.getWarnings()) {
                            this.warnings.add(this.reader.getLineNumber(), name, 26, w);
                        }
                        IOUtils.closeQuietly(agentReader);
                    }
                    break block29;
                    catch (IOException e2) {
                        for (String w : agentReader.getWarnings()) {
                            this.warnings.add(this.reader.getLineNumber(), name, 26, w);
                        }
                        IOUtils.closeQuietly(agentReader);
                        break block29;
                        catch (Throwable throwable) {
                            for (String w : agentReader.getWarnings()) {
                                this.warnings.add(this.reader.getLineNumber(), name, 26, w);
                            }
                            IOUtils.closeQuietly(agentReader);
                            throw throwable;
                        }
                    }
                }
                curVCard.addProperty(property);
            }
        }
        return root;
    }

    private void processNamelessParameters(VCardParameters parameters) {
        List namelessParamValues = parameters.removeAll(null);
        for (String paramValue : namelessParamValues) {
            String paramName = this.guessParameterName(paramValue);
            parameters.put(paramName, paramValue);
        }
    }

    private String guessParameterName(String value) {
        if (VCardDataType.find(value) != null) {
            return "VALUE";
        }
        if (Encoding.find(value) != null) {
            return "ENCODING";
        }
        return "TYPE";
    }

    private void processQuotedMultivaluedTypeParams(VCardParameters parameters) {
        int cur;
        List<String> types = parameters.getTypes();
        String valueWithComma = null;
        for (String value : types) {
            if (value.indexOf(44) < 0) continue;
            valueWithComma = value;
            break;
        }
        if (valueWithComma == null) {
            return;
        }
        types.clear();
        int prev = -1;
        while ((cur = valueWithComma.indexOf(44, prev + 1)) >= 0) {
            types.add(valueWithComma.substring(prev + 1, cur));
            prev = cur;
        }
        types.add(valueWithComma.substring(prev + 1));
    }

    private String decodeQuotedPrintableValue(String name, VCardParameters parameters, String value) throws DecoderException {
        if (parameters.getEncoding() != Encoding.QUOTED_PRINTABLE) {
            return value;
        }
        parameters.setEncoding(null);
        Charset charset = null;
        String charsetStr = parameters.getCharset();
        if (charsetStr == null) {
            charset = this.defaultQuotedPrintableCharset;
        } else {
            try {
                charset = Charset.forName(charsetStr);
            }
            catch (IllegalCharsetNameException e) {
            }
            catch (UnsupportedCharsetException e) {
                // empty catch block
            }
            if (charset == null) {
                charset = this.defaultQuotedPrintableCharset;
                this.warnings.add(this.reader.getLineNumber(), name, 23, charsetStr, charset.name());
            }
        }
        QuotedPrintableCodec codec = new QuotedPrintableCodec(charset.name());
        return codec.decode(value);
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

