/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.text;

import ezvcard.Messages;
import ezvcard.VCardVersion;
import ezvcard.io.text.FoldedLineWriter;
import ezvcard.parameter.Encoding;
import ezvcard.parameter.VCardParameters;
import ezvcard.util.CharacterBitSet;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class VCardRawWriter
implements Closeable,
Flushable {
    private final CharacterBitSet specialParameterCharacters = new CharacterBitSet(",:;");
    private final Pattern newlineRegex = Pattern.compile("\\r\\n|\\r|\\n");
    private final CharacterBitSet newlineBitSet = new CharacterBitSet("\r\n");
    private final CharacterBitSet invalidPropertyNameCharacters;
    private final CharacterBitSet invalidGroupNameCharacters = this.invalidPropertyNameCharacters = new CharacterBitSet(".;:\n\r");
    private final CharacterBitSet invalidParameterNameCharacters = new CharacterBitSet(";:=\n\r");
    private final Map<VCardVersion, CharacterBitSet> invalidParamValueChars;
    private final Map<VCardVersion, CharacterBitSet> invalidParamValueCharsWithCaretEncoding;
    private final FoldedLineWriter writer;
    private boolean caretEncodingEnabled;
    private VCardVersion version;

    public VCardRawWriter(Writer writer, VCardVersion version) {
        EnumMap<VCardVersion, CharacterBitSet> map = new EnumMap<VCardVersion, CharacterBitSet>(VCardVersion.class);
        map.put(VCardVersion.V2_1, new CharacterBitSet(",:\n\r"));
        map.put(VCardVersion.V3_0, new CharacterBitSet("\"\r\n"));
        map.put(VCardVersion.V4_0, new CharacterBitSet("\""));
        this.invalidParamValueChars = Collections.unmodifiableMap(map);
        map = new EnumMap(VCardVersion.class);
        map.put(VCardVersion.V2_1, this.invalidParamValueChars.get((Object)VCardVersion.V2_1));
        map.put(VCardVersion.V3_0, new CharacterBitSet(""));
        map.put(VCardVersion.V4_0, new CharacterBitSet(""));
        this.invalidParamValueCharsWithCaretEncoding = Collections.unmodifiableMap(map);
        this.caretEncodingEnabled = false;
        this.writer = new FoldedLineWriter(writer);
        this.version = version;
    }

    public FoldedLineWriter getFoldedLineWriter() {
        return this.writer;
    }

    public boolean isCaretEncodingEnabled() {
        return this.caretEncodingEnabled;
    }

    public void setCaretEncodingEnabled(boolean enable) {
        this.caretEncodingEnabled = enable;
    }

    public VCardVersion getVersion() {
        return this.version;
    }

    public void setVersion(VCardVersion version) {
        this.version = version;
    }

    public void writeBeginComponent(String componentName) throws IOException {
        this.writeProperty("BEGIN", componentName);
    }

    public void writeEndComponent(String componentName) throws IOException {
        this.writeProperty("END", componentName);
    }

    public void writeVersion() throws IOException {
        this.writeProperty("VERSION", this.version.getVersion());
    }

    public void writeProperty(String propertyName, String value) throws IOException {
        this.writeProperty(null, propertyName, new VCardParameters(), value);
    }

    public void writeProperty(String group, String propertyName, VCardParameters parameters, String value) throws IOException {
        if (group != null) {
            if (this.invalidGroupNameCharacters.containsAny(group)) {
                throw Messages.INSTANCE.getIllegalArgumentException(7, propertyName, group, this.printableCharacterList(this.invalidGroupNameCharacters.characters()));
            }
            if (this.beginsWithWhitespace(group)) {
                throw Messages.INSTANCE.getIllegalArgumentException(8, propertyName, group);
            }
        }
        if (this.invalidPropertyNameCharacters.containsAny(propertyName)) {
            throw Messages.INSTANCE.getIllegalArgumentException(9, propertyName, this.printableCharacterList(this.invalidPropertyNameCharacters.characters()));
        }
        if (this.beginsWithWhitespace(propertyName)) {
            throw Messages.INSTANCE.getIllegalArgumentException(10, propertyName);
        }
        value = this.sanitizePropertyValue(value, parameters);
        boolean useQuotedPrintable = parameters.getEncoding() == Encoding.QUOTED_PRINTABLE;
        Charset quotedPrintableCharset = null;
        if (useQuotedPrintable) {
            String charsetParam = parameters.getCharset();
            if (charsetParam == null) {
                quotedPrintableCharset = Charset.forName("UTF-8");
            } else {
                try {
                    quotedPrintableCharset = Charset.forName(charsetParam);
                }
                catch (Throwable t) {
                    quotedPrintableCharset = Charset.forName("UTF-8");
                }
            }
            parameters.setCharset(quotedPrintableCharset.name());
        }
        if (group != null) {
            this.writer.append(group).append('.');
        }
        this.writer.append(propertyName);
        for (Map.Entry parameter : parameters) {
            String parameterName = (String)parameter.getKey();
            List parameterValues = parameter.getValue();
            if (parameterValues.isEmpty()) continue;
            if (this.invalidParameterNameCharacters.containsAny(parameterName)) {
                throw Messages.INSTANCE.getIllegalArgumentException(11, propertyName, parameterName, this.printableCharacterList(this.invalidParameterNameCharacters.characters()));
            }
            if (this.version == VCardVersion.V2_1) {
                boolean isTypeParameter = "TYPE".equalsIgnoreCase(parameterName);
                for (String parameterValue : parameterValues) {
                    parameterValue = this.sanitizeParameterValue(parameterValue, parameterName, propertyName);
                    if (isTypeParameter) {
                        this.writer.append(';').append(parameterValue.toUpperCase());
                        continue;
                    }
                    this.writer.append(';').append(parameterName).append('=').append(parameterValue);
                }
                continue;
            }
            boolean first = true;
            this.writer.append(';').append(parameterName).append('=');
            for (String parameterValue : parameterValues) {
                if (!first) {
                    this.writer.append(',');
                }
                if (this.specialParameterCharacters.containsAny(parameterValue = this.sanitizeParameterValue(parameterValue, parameterName, propertyName))) {
                    this.writer.append('\"').append(parameterValue).append('\"');
                } else {
                    this.writer.append(parameterValue);
                }
                first = false;
            }
        }
        this.writer.append(':');
        this.writer.append((CharSequence)value, useQuotedPrintable, quotedPrintableCharset);
        this.writer.append(this.writer.getNewline());
    }

    private boolean beginsWithWhitespace(String string) {
        if (string.length() == 0) {
            return false;
        }
        char first = string.charAt(0);
        return first == ' ' || first == '\t';
    }

    private String sanitizePropertyValue(String value, VCardParameters parameters) {
        if (value == null) {
            return "";
        }
        if (this.version == VCardVersion.V2_1 && this.newlineBitSet.containsAny(value)) {
            parameters.setEncoding(Encoding.QUOTED_PRINTABLE);
            return value;
        }
        return this.escapeNewlines(value);
    }

    private String sanitizeParameterValue(String parameterValue, String parameterName, String propertyName) {
        CharacterBitSet invalidChars = (this.caretEncodingEnabled ? this.invalidParamValueCharsWithCaretEncoding : this.invalidParamValueChars).get((Object)this.version);
        if (invalidChars.containsAny(parameterValue)) {
            throw Messages.INSTANCE.getIllegalArgumentException(12, propertyName, parameterName, this.printableCharacterList(invalidChars.characters()));
        }
        String sanitizedValue = parameterValue;
        switch (this.version) {
            case V2_1: {
                sanitizedValue = sanitizedValue.replace("\\", "\\\\");
                return sanitizedValue.replace(";", "\\;");
            }
            case V3_0: {
                if (this.caretEncodingEnabled) {
                    return this.applyCaretEncoding(sanitizedValue);
                }
                return sanitizedValue;
            }
            case V4_0: {
                if (this.caretEncodingEnabled) {
                    return this.applyCaretEncoding(sanitizedValue);
                }
                return this.newlineRegex.matcher(sanitizedValue).replaceAll("\\\\\\n");
            }
        }
        return "";
    }

    private String printableCharacterList(String list) {
        return list.replace("\n", "\\n").replace("\r", "\\r");
    }

    private String applyCaretEncoding(String value) {
        value = value.replace("^", "^^");
        value = this.newlineRegex.matcher(value).replaceAll("^n");
        value = value.replace("\"", "^'");
        return value;
    }

    private String escapeNewlines(String string) {
        return this.newlineRegex.matcher(string).replaceAll("\\\\n");
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }
}

