/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import ezvcard.Messages;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.CannotParseException;
import ezvcard.io.html.HCardElement;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.DateOrTimeProperty;
import ezvcard.util.PartialDate;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DateOrTimePropertyScribe<T extends DateOrTimeProperty>
extends VCardPropertyScribe<T> {
    public DateOrTimePropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName);
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        switch (version) {
            case V2_1: 
            case V3_0: {
                return null;
            }
            case V4_0: {
                return VCardDataType.DATE_AND_OR_TIME;
            }
        }
        return null;
    }

    @Override
    protected VCardDataType _dataType(T property, VCardVersion version) {
        switch (version) {
            case V2_1: 
            case V3_0: {
                return null;
            }
            case V4_0: {
                if (((DateOrTimeProperty)property).getText() != null) {
                    return VCardDataType.TEXT;
                }
                if (((DateOrTimeProperty)property).getDate() != null || ((DateOrTimeProperty)property).getPartialDate() != null) {
                    return ((DateOrTimeProperty)property).hasTime() ? VCardDataType.DATE_TIME : VCardDataType.DATE;
                }
                return VCardDataType.DATE_AND_OR_TIME;
            }
        }
        return null;
    }

    @Override
    protected String _writeText(T property, VCardVersion version) {
        Date date = ((DateOrTimeProperty)property).getDate();
        if (date != null) {
            boolean extended = version == VCardVersion.V3_0;
            return DateOrTimePropertyScribe.date(date).time(((DateOrTimeProperty)property).hasTime()).extended(extended).utc(false).write();
        }
        if (version == VCardVersion.V4_0) {
            String text = ((DateOrTimeProperty)property).getText();
            if (text != null) {
                return DateOrTimePropertyScribe.escape(text);
            }
            PartialDate partialDate = ((DateOrTimeProperty)property).getPartialDate();
            if (partialDate != null) {
                return partialDate.toISO8601(false);
            }
        }
        return "";
    }

    @Override
    protected T _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        value = DateOrTimePropertyScribe.unescape(value);
        if (version == VCardVersion.V4_0 && dataType == VCardDataType.TEXT) {
            return this.newInstance(value);
        }
        return this.parse(value, version, warnings);
    }

    @Override
    protected void _writeXml(T property, XCardElement parent) {
        Date date = ((DateOrTimeProperty)property).getDate();
        if (date != null) {
            boolean hasTime = ((DateOrTimeProperty)property).hasTime();
            String value = DateOrTimePropertyScribe.date(date).time(hasTime).extended(false).utc(false).write();
            VCardDataType dataType = hasTime ? VCardDataType.DATE_TIME : VCardDataType.DATE;
            parent.append(dataType, value);
            return;
        }
        PartialDate partialDate = ((DateOrTimeProperty)property).getPartialDate();
        if (partialDate != null) {
            VCardDataType dataType = partialDate.hasTimeComponent() && partialDate.hasDateComponent() ? VCardDataType.DATE_TIME : (partialDate.hasTimeComponent() ? VCardDataType.TIME : (partialDate.hasDateComponent() ? VCardDataType.DATE : VCardDataType.DATE_AND_OR_TIME));
            parent.append(dataType, partialDate.toISO8601(false));
            return;
        }
        String text = ((DateOrTimeProperty)property).getText();
        if (text != null) {
            parent.append(VCardDataType.TEXT, text);
            return;
        }
        parent.append(VCardDataType.DATE_AND_OR_TIME, "");
    }

    @Override
    protected T _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        String value = element.first(VCardDataType.DATE, VCardDataType.DATE_TIME, VCardDataType.DATE_AND_OR_TIME);
        if (value != null) {
            return this.parse(value, element.version(), warnings);
        }
        value = element.first(VCardDataType.TEXT);
        if (value != null) {
            return this.newInstance(value);
        }
        throw DateOrTimePropertyScribe.missingXmlElements(VCardDataType.DATE, VCardDataType.DATE_TIME, VCardDataType.DATE_AND_OR_TIME, VCardDataType.TEXT);
    }

    @Override
    protected T _parseHtml(HCardElement element, List<String> warnings) {
        String datetime;
        String value = null;
        if ("time".equals(element.tagName()) && (datetime = element.attr("datetime")).length() > 0) {
            value = datetime;
        }
        if (value == null) {
            value = element.value();
        }
        return this.parse(value, VCardVersion.V3_0, warnings);
    }

    @Override
    protected JCardValue _writeJson(T property) {
        Date date = ((DateOrTimeProperty)property).getDate();
        if (date != null) {
            boolean hasTime = ((DateOrTimeProperty)property).hasTime();
            String value = DateOrTimePropertyScribe.date(date).time(hasTime).extended(true).utc(false).write();
            return JCardValue.single(value);
        }
        PartialDate partialDate = ((DateOrTimeProperty)property).getPartialDate();
        if (partialDate != null) {
            String value = partialDate.toISO8601(true);
            return JCardValue.single(value);
        }
        String text = ((DateOrTimeProperty)property).getText();
        if (text != null) {
            return JCardValue.single(text);
        }
        return JCardValue.single("");
    }

    @Override
    protected T _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, List<String> warnings) {
        String valueStr = value.asSingle();
        if (dataType == VCardDataType.TEXT) {
            return this.newInstance(valueStr);
        }
        return this.parse(valueStr, VCardVersion.V4_0, warnings);
    }

    private T parse(String value, VCardVersion version, List<String> warnings) {
        try {
            boolean hasTime = value.contains("T");
            return this.newInstance(DateOrTimePropertyScribe.date(value), hasTime);
        }
        catch (IllegalArgumentException e) {
            if (version == VCardVersion.V2_1 || version == VCardVersion.V3_0) {
                throw new CannotParseException(5, new Object[0]);
            }
            try {
                return this.newInstance(PartialDate.parse(value));
            }
            catch (IllegalArgumentException e2) {
                warnings.add(Messages.INSTANCE.getParseMessage(6, new Object[0]));
                return this.newInstance(value);
            }
        }
    }

    protected abstract T newInstance(String var1);

    protected abstract T newInstance(Date var1, boolean var2);

    protected abstract T newInstance(PartialDate var1);
}

