/*
 * Decompiled with CFR 0.152.
 */
package ezvcard;

import ezvcard.Ezvcard;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.ValidationWarnings;
import ezvcard.Warning;
import ezvcard.parameter.EmailType;
import ezvcard.parameter.TelephoneType;
import ezvcard.property.Address;
import ezvcard.property.Agent;
import ezvcard.property.Anniversary;
import ezvcard.property.Birthday;
import ezvcard.property.Birthplace;
import ezvcard.property.CalendarRequestUri;
import ezvcard.property.CalendarUri;
import ezvcard.property.Categories;
import ezvcard.property.Classification;
import ezvcard.property.ClientPidMap;
import ezvcard.property.Deathdate;
import ezvcard.property.Deathplace;
import ezvcard.property.Email;
import ezvcard.property.Expertise;
import ezvcard.property.FormattedName;
import ezvcard.property.FreeBusyUrl;
import ezvcard.property.Gender;
import ezvcard.property.Geo;
import ezvcard.property.HasAltId;
import ezvcard.property.Hobby;
import ezvcard.property.Impp;
import ezvcard.property.Interest;
import ezvcard.property.Key;
import ezvcard.property.Kind;
import ezvcard.property.Label;
import ezvcard.property.Language;
import ezvcard.property.Logo;
import ezvcard.property.Mailer;
import ezvcard.property.Member;
import ezvcard.property.Nickname;
import ezvcard.property.Note;
import ezvcard.property.OrgDirectory;
import ezvcard.property.Organization;
import ezvcard.property.Photo;
import ezvcard.property.ProductId;
import ezvcard.property.Profile;
import ezvcard.property.RawProperty;
import ezvcard.property.Related;
import ezvcard.property.Revision;
import ezvcard.property.Role;
import ezvcard.property.SortString;
import ezvcard.property.Sound;
import ezvcard.property.Source;
import ezvcard.property.SourceDisplayText;
import ezvcard.property.StructuredName;
import ezvcard.property.Telephone;
import ezvcard.property.Timezone;
import ezvcard.property.Title;
import ezvcard.property.Uid;
import ezvcard.property.Url;
import ezvcard.property.VCardProperty;
import ezvcard.property.Xml;
import ezvcard.util.ListMultimap;
import ezvcard.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCard
implements Iterable<VCardProperty> {
    private VCardVersion version;
    private final ListMultimap<Class<? extends VCardProperty>, VCardProperty> properties = new ListMultimap();

    public VCard() {
        this(VCardVersion.V3_0);
    }

    public VCard(VCardVersion version) {
        this.version = version;
    }

    public VCard(VCard original) {
        this.version = original.version;
        for (VCardProperty property : original.getProperties()) {
            this.addProperty(property.copy());
        }
    }

    public String write() {
        return Ezvcard.write(this).go();
    }

    public void write(File file) throws IOException {
        Ezvcard.write(this).go(file);
    }

    public void write(OutputStream out) throws IOException {
        Ezvcard.write(this).go(out);
    }

    public void write(Writer writer) throws IOException {
        Ezvcard.write(this).go(writer);
    }

    public String writeXml() {
        return Ezvcard.writeXml(this).indent(2).go();
    }

    public void writeXml(File file) throws IOException, TransformerException {
        Ezvcard.writeXml(this).indent(2).go(file);
    }

    public void writeXml(OutputStream out) throws TransformerException {
        Ezvcard.writeXml(this).indent(2).go(out);
    }

    public void writeXml(Writer writer) throws TransformerException {
        Ezvcard.writeXml(this).indent(2).go(writer);
    }

    public String writeHtml() {
        return Ezvcard.writeHtml(this).go();
    }

    public void writeHtml(File file) throws IOException {
        Ezvcard.writeHtml(this).go(file);
    }

    public void writeHtml(OutputStream out) throws IOException {
        Ezvcard.writeHtml(this).go(out);
    }

    public void writeHtml(Writer writer) throws IOException {
        Ezvcard.writeHtml(this).go(writer);
    }

    public String writeJson() {
        return Ezvcard.writeJson(this).go();
    }

    public void writeJson(File file) throws IOException {
        Ezvcard.writeJson(this).go(file);
    }

    public void writeJson(OutputStream out) throws IOException {
        Ezvcard.writeJson(this).go(out);
    }

    public void writeJson(Writer writer) throws IOException {
        Ezvcard.writeJson(this).go(writer);
    }

    public VCardVersion getVersion() {
        return this.version;
    }

    public void setVersion(VCardVersion version) {
        this.version = version;
    }

    public Kind getKind() {
        return this.getProperty(Kind.class);
    }

    public void setKind(Kind kind) {
        this.setProperty(Kind.class, kind);
    }

    public Gender getGender() {
        return this.getProperty(Gender.class);
    }

    public void setGender(Gender gender) {
        this.setProperty(Gender.class, gender);
    }

    public List<Member> getMembers() {
        return this.getProperties(Member.class);
    }

    public void addMember(Member member) {
        this.addProperty(member);
    }

    public void addMemberAlt(Member ... altRepresentations) {
        this.addPropertyAlt(Member.class, altRepresentations);
    }

    public Profile getProfile() {
        return this.getProperty(Profile.class);
    }

    public void setProfile(Profile profile) {
        this.setProperty(Profile.class, profile);
    }

    public Classification getClassification() {
        return this.getProperty(Classification.class);
    }

    public void setClassification(Classification classification) {
        this.setProperty(Classification.class, classification);
    }

    public Classification setClassification(String classification) {
        Classification type = classification == null ? null : new Classification(classification);
        this.setClassification(type);
        return type;
    }

    public List<Source> getSources() {
        return this.getProperties(Source.class);
    }

    public void addSource(Source source) {
        this.addProperty(source);
    }

    public Source addSource(String source) {
        Source type = new Source(source);
        this.addSource(type);
        return type;
    }

    public void addSourceAlt(Source ... altRepresentations) {
        this.addPropertyAlt(Source.class, altRepresentations);
    }

    public SourceDisplayText getSourceDisplayText() {
        return this.getProperty(SourceDisplayText.class);
    }

    public void setSourceDisplayText(SourceDisplayText sourceDisplayText) {
        this.setProperty(SourceDisplayText.class, sourceDisplayText);
    }

    public SourceDisplayText setSourceDisplayText(String sourceDisplayText) {
        SourceDisplayText type = sourceDisplayText == null ? null : new SourceDisplayText(sourceDisplayText);
        this.setSourceDisplayText(type);
        return type;
    }

    public List<FormattedName> getFormattedNames() {
        return this.getProperties(FormattedName.class);
    }

    public FormattedName getFormattedName() {
        return this.getProperty(FormattedName.class);
    }

    public void setFormattedNameAlt(FormattedName ... altRepresentations) {
        this.setPropertyAlt(FormattedName.class, altRepresentations);
    }

    public void addFormattedNameAlt(FormattedName ... altRepresentations) {
        this.addPropertyAlt(FormattedName.class, altRepresentations);
    }

    public void setFormattedName(FormattedName formattedName) {
        this.setProperty(FormattedName.class, formattedName);
    }

    public void addFormattedName(FormattedName formattedName) {
        this.addProperty(formattedName);
    }

    public FormattedName setFormattedName(String formattedName) {
        FormattedName type = formattedName == null ? null : new FormattedName(formattedName);
        this.setFormattedName(type);
        return type;
    }

    public List<StructuredName> getStructuredNames() {
        return this.getProperties(StructuredName.class);
    }

    public StructuredName getStructuredName() {
        return this.getProperty(StructuredName.class);
    }

    public void setStructuredNameAlt(StructuredName ... altRepresentations) {
        this.setPropertyAlt(StructuredName.class, altRepresentations);
    }

    public void setStructuredName(StructuredName structuredName) {
        this.setProperty(StructuredName.class, structuredName);
    }

    public List<Nickname> getNicknames() {
        return this.getProperties(Nickname.class);
    }

    public Nickname getNickname() {
        return this.getProperty(Nickname.class);
    }

    public void setNicknameAlt(Nickname ... altRepresentations) {
        this.setPropertyAlt(Nickname.class, altRepresentations);
    }

    public void addNicknameAlt(Nickname ... altRepresentations) {
        this.addPropertyAlt(Nickname.class, altRepresentations);
    }

    public void setNickname(Nickname nickname) {
        this.setProperty(Nickname.class, nickname);
    }

    public void addNickname(Nickname nickname) {
        this.addProperty(nickname);
    }

    public Nickname setNickname(String ... nicknames) {
        Nickname property = null;
        if (nicknames != null && nicknames.length > 0 && nicknames[0] != null) {
            property = new Nickname();
            property.getValues().addAll(Arrays.asList(nicknames));
        }
        this.setNickname(property);
        return property;
    }

    public SortString getSortString() {
        return this.getProperty(SortString.class);
    }

    public void setSortString(SortString sortString) {
        this.setProperty(SortString.class, sortString);
    }

    public SortString setSortString(String sortString) {
        SortString type = sortString == null ? null : new SortString(sortString);
        this.setSortString(type);
        return type;
    }

    public List<Title> getTitles() {
        return this.getProperties(Title.class);
    }

    public void addTitle(Title title) {
        this.addProperty(title);
    }

    public Title addTitle(String title) {
        Title type = new Title(title);
        this.addTitle(type);
        return type;
    }

    public void addTitleAlt(Title ... altRepresentations) {
        this.addPropertyAlt(Title.class, altRepresentations);
    }

    public List<Role> getRoles() {
        return this.getProperties(Role.class);
    }

    public void addRole(Role role) {
        this.addProperty(role);
    }

    public Role addRole(String role) {
        Role type = new Role(role);
        this.addRole(type);
        return type;
    }

    public void addRoleAlt(Role ... altRepresentations) {
        this.addPropertyAlt(Role.class, altRepresentations);
    }

    public List<Photo> getPhotos() {
        return this.getProperties(Photo.class);
    }

    public void addPhoto(Photo photo) {
        this.addProperty(photo);
    }

    public void addPhotoAlt(Photo ... altRepresentations) {
        this.addPropertyAlt(Photo.class, altRepresentations);
    }

    public List<Logo> getLogos() {
        return this.getProperties(Logo.class);
    }

    public void addLogo(Logo logo) {
        this.addProperty(logo);
    }

    public void addLogoAlt(Logo ... altRepresentations) {
        this.addPropertyAlt(Logo.class, altRepresentations);
    }

    public List<Sound> getSounds() {
        return this.getProperties(Sound.class);
    }

    public void addSound(Sound sound) {
        this.addProperty(sound);
    }

    public void addSoundAlt(Sound ... altRepresentations) {
        this.addPropertyAlt(Sound.class, altRepresentations);
    }

    public List<Birthplace> getBirthplaces() {
        return this.getProperties(Birthplace.class);
    }

    public Birthplace getBirthplace() {
        return this.getProperty(Birthplace.class);
    }

    public void setBirthplaceAlt(Birthplace ... altRepresentations) {
        this.setPropertyAlt(Birthplace.class, altRepresentations);
    }

    public void setBirthplace(Birthplace birthplace) {
        this.setProperty(Birthplace.class, birthplace);
    }

    public List<Deathplace> getDeathplaces() {
        return this.getProperties(Deathplace.class);
    }

    public Deathplace getDeathplace() {
        return this.getProperty(Deathplace.class);
    }

    public void setDeathplaceAlt(Deathplace ... altRepresentations) {
        this.setPropertyAlt(Deathplace.class, altRepresentations);
    }

    public void setDeathplace(Deathplace deathplace) {
        this.setProperty(Deathplace.class, deathplace);
    }

    public List<Deathdate> getDeathdates() {
        return this.getProperties(Deathdate.class);
    }

    public Deathdate getDeathdate() {
        return this.getProperty(Deathdate.class);
    }

    public void setDeathdateAlt(Deathdate ... altRepresentations) {
        this.setPropertyAlt(Deathdate.class, altRepresentations);
    }

    public void setDeathdate(Deathdate deathdate) {
        this.setProperty(Deathdate.class, deathdate);
    }

    public List<Birthday> getBirthdays() {
        return this.getProperties(Birthday.class);
    }

    public Birthday getBirthday() {
        return this.getProperty(Birthday.class);
    }

    public void setBirthdayAlt(Birthday ... altRepresentations) {
        this.setPropertyAlt(Birthday.class, altRepresentations);
    }

    public void setBirthday(Birthday birthday) {
        this.setProperty(Birthday.class, birthday);
    }

    public List<Anniversary> getAnniversaries() {
        return this.getProperties(Anniversary.class);
    }

    public Anniversary getAnniversary() {
        return this.getProperty(Anniversary.class);
    }

    public void setAnniversaryAlt(Anniversary ... altRepresentations) {
        this.setPropertyAlt(Anniversary.class, altRepresentations);
    }

    public void setAnniversary(Anniversary anniversary) {
        this.setProperty(Anniversary.class, anniversary);
    }

    public Revision getRevision() {
        return this.getProperty(Revision.class);
    }

    public void setRevision(Revision revision) {
        this.setProperty(Revision.class, revision);
    }

    public Revision setRevision(Date rev) {
        Revision type = rev == null ? null : new Revision(rev);
        this.setRevision(type);
        return type;
    }

    public ProductId getProductId() {
        return this.getProperty(ProductId.class);
    }

    public void setProductId(ProductId productId) {
        this.setProperty(ProductId.class, productId);
    }

    public ProductId setProductId(String productId) {
        ProductId type = productId == null ? null : new ProductId(productId);
        this.setProductId(type);
        return type;
    }

    public List<Address> getAddresses() {
        return this.getProperties(Address.class);
    }

    public void addAddress(Address address) {
        this.addProperty(address);
    }

    public void addAddressAlt(Address ... altRepresentations) {
        this.addPropertyAlt(Address.class, altRepresentations);
    }

    public List<Label> getOrphanedLabels() {
        return this.getProperties(Label.class);
    }

    public void addOrphanedLabel(Label label) {
        this.addProperty(label);
    }

    public List<Email> getEmails() {
        return this.getProperties(Email.class);
    }

    public void addEmail(Email email) {
        this.addProperty(email);
    }

    public Email addEmail(String email, EmailType ... types) {
        Email property = new Email(email);
        property.getTypes().addAll(Arrays.asList(types));
        this.addEmail(property);
        return property;
    }

    public void addEmailAlt(Email ... altRepresentations) {
        this.addPropertyAlt(Email.class, altRepresentations);
    }

    public List<Telephone> getTelephoneNumbers() {
        return this.getProperties(Telephone.class);
    }

    public void addTelephoneNumber(Telephone telephoneNumber) {
        this.addProperty(telephoneNumber);
    }

    public Telephone addTelephoneNumber(String telephoneNumber, TelephoneType ... types) {
        Telephone property = new Telephone(telephoneNumber);
        property.getTypes().addAll(Arrays.asList(types));
        this.addTelephoneNumber(property);
        return property;
    }

    public void addTelephoneNumberAlt(Telephone ... altRepresentations) {
        this.addPropertyAlt(Telephone.class, altRepresentations);
    }

    public Mailer getMailer() {
        return this.getProperty(Mailer.class);
    }

    public void setMailer(Mailer mailer) {
        this.setProperty(Mailer.class, mailer);
    }

    public Mailer setMailer(String mailer) {
        Mailer type = mailer == null ? null : new Mailer(mailer);
        this.setMailer(type);
        return type;
    }

    public List<Url> getUrls() {
        return this.getProperties(Url.class);
    }

    public void addUrl(Url url) {
        this.addProperty(url);
    }

    public Url addUrl(String url) {
        Url type = new Url(url);
        this.addUrl(type);
        return type;
    }

    public void addUrlAlt(Url ... altRepresentations) {
        this.addPropertyAlt(Url.class, altRepresentations);
    }

    public List<Timezone> getTimezones() {
        return this.getProperties(Timezone.class);
    }

    public Timezone getTimezone() {
        return this.getProperty(Timezone.class);
    }

    public void setTimezoneAlt(Timezone ... altRepresentations) {
        this.setPropertyAlt(Timezone.class, altRepresentations);
    }

    public void addTimezoneAlt(Timezone ... altRepresentations) {
        this.addPropertyAlt(Timezone.class, altRepresentations);
    }

    public void setTimezone(Timezone timezone) {
        this.setProperty(Timezone.class, timezone);
    }

    public void addTimezone(Timezone timezone) {
        this.addProperty(timezone);
    }

    public List<Geo> getGeos() {
        return this.getProperties(Geo.class);
    }

    public Geo getGeo() {
        return this.getProperty(Geo.class);
    }

    public void setGeoAlt(Geo ... altRepresentations) {
        this.setPropertyAlt(Geo.class, altRepresentations);
    }

    public void addGeoAlt(Geo ... altRepresentations) {
        this.addPropertyAlt(Geo.class, altRepresentations);
    }

    public void setGeo(Geo geo) {
        this.setProperty(Geo.class, geo);
    }

    public void addGeo(Geo geo) {
        this.addProperty(geo);
    }

    public Geo setGeo(double latitude, double longitude) {
        Geo type = new Geo(latitude, longitude);
        this.setGeo(type);
        return type;
    }

    public List<Organization> getOrganizations() {
        return this.getProperties(Organization.class);
    }

    public Organization getOrganization() {
        return this.getProperty(Organization.class);
    }

    public void setOrganizationAlt(Organization ... altRepresentations) {
        this.setPropertyAlt(Organization.class, altRepresentations);
    }

    public void addOrganizationAlt(Organization ... altRepresentations) {
        this.addPropertyAlt(Organization.class, altRepresentations);
    }

    public void setOrganization(Organization organization) {
        this.setProperty(Organization.class, organization);
    }

    public void addOrganization(Organization organization) {
        this.addProperty(organization);
    }

    public Organization setOrganization(String ... departments) {
        Organization type = null;
        if (departments.length > 0) {
            type = new Organization();
            type.getValues().addAll(Arrays.asList(departments));
        }
        this.setOrganization(type);
        return type;
    }

    public List<Categories> getCategoriesList() {
        return this.getProperties(Categories.class);
    }

    public Categories getCategories() {
        return this.getProperty(Categories.class);
    }

    public void setCategoriesAlt(Categories ... altRepresentations) {
        this.setPropertyAlt(Categories.class, altRepresentations);
    }

    public void addCategoriesAlt(Categories ... altRepresentations) {
        this.addPropertyAlt(Categories.class, altRepresentations);
    }

    public void setCategories(Categories categories) {
        this.setProperty(Categories.class, categories);
    }

    public void addCategories(Categories categories) {
        this.addProperty(categories);
    }

    public Categories setCategories(String ... categories) {
        Categories type = null;
        if (categories.length > 0) {
            type = new Categories();
            type.getValues().addAll(Arrays.asList(categories));
        }
        this.setCategories(type);
        return type;
    }

    public Agent getAgent() {
        return this.getProperty(Agent.class);
    }

    public void setAgent(Agent agent) {
        this.setProperty(Agent.class, agent);
    }

    public List<Note> getNotes() {
        return this.getProperties(Note.class);
    }

    public void addNote(Note note) {
        this.addProperty(note);
    }

    public Note addNote(String note) {
        Note type = new Note(note);
        this.addNote(type);
        return type;
    }

    public void addNoteAlt(Note ... altRepresentations) {
        this.addPropertyAlt(Note.class, altRepresentations);
    }

    public Uid getUid() {
        return this.getProperty(Uid.class);
    }

    public void setUid(Uid uid) {
        this.setProperty(Uid.class, uid);
    }

    public List<Key> getKeys() {
        return this.getProperties(Key.class);
    }

    public void addKey(Key key) {
        this.addProperty(key);
    }

    public void addKeyAlt(Key ... altRepresentations) {
        this.addPropertyAlt(Key.class, altRepresentations);
    }

    public List<Impp> getImpps() {
        return this.getProperties(Impp.class);
    }

    public void addImpp(Impp impp) {
        this.addProperty(impp);
    }

    public void addImppAlt(Impp ... altRepresentations) {
        this.addPropertyAlt(Impp.class, altRepresentations);
    }

    public List<Related> getRelations() {
        return this.getProperties(Related.class);
    }

    public void addRelated(Related related) {
        this.addProperty(related);
    }

    public void addRelatedAlt(Related ... altRepresentations) {
        this.addPropertyAlt(Related.class, altRepresentations);
    }

    public List<Language> getLanguages() {
        return this.getProperties(Language.class);
    }

    public void addLanguage(Language language) {
        this.addProperty(language);
    }

    public Language addLanguage(String language) {
        Language type = new Language(language);
        this.addLanguage(type);
        return type;
    }

    public void addLanguageAlt(Language ... altRepresentations) {
        this.addPropertyAlt(Language.class, altRepresentations);
    }

    public List<CalendarRequestUri> getCalendarRequestUris() {
        return this.getProperties(CalendarRequestUri.class);
    }

    public void addCalendarRequestUri(CalendarRequestUri calendarRequestUri) {
        this.addProperty(calendarRequestUri);
    }

    public void addCalendarRequestUriAlt(CalendarRequestUri ... altRepresentations) {
        this.addPropertyAlt(CalendarRequestUri.class, altRepresentations);
    }

    public List<CalendarUri> getCalendarUris() {
        return this.getProperties(CalendarUri.class);
    }

    public void addCalendarUri(CalendarUri calendarUri) {
        this.addProperty(calendarUri);
    }

    public void addCalendarUriAlt(CalendarUri ... altRepresentations) {
        this.addPropertyAlt(CalendarUri.class, altRepresentations);
    }

    public List<FreeBusyUrl> getFbUrls() {
        return this.getProperties(FreeBusyUrl.class);
    }

    public void addFbUrl(FreeBusyUrl fbUrl) {
        this.addProperty(fbUrl);
    }

    public void addFbUrlAlt(FreeBusyUrl ... altRepresentations) {
        this.addPropertyAlt(FreeBusyUrl.class, altRepresentations);
    }

    public List<ClientPidMap> getClientPidMaps() {
        return this.getProperties(ClientPidMap.class);
    }

    public void addClientPidMap(ClientPidMap clientPidMap) {
        this.addProperty(clientPidMap);
    }

    public List<Xml> getXmls() {
        return this.getProperties(Xml.class);
    }

    public void addXml(Xml xml) {
        this.addProperty(xml);
    }

    public void addXmlAlt(Xml ... altRepresentations) {
        this.addPropertyAlt(Xml.class, altRepresentations);
    }

    public List<Expertise> getExpertise() {
        return this.getProperties(Expertise.class);
    }

    public void addExpertise(Expertise expertise) {
        this.addProperty(expertise);
    }

    public Expertise addExpertise(String expertise) {
        Expertise type = new Expertise(expertise);
        this.addExpertise(type);
        return type;
    }

    public void addExpertiseAlt(Expertise ... altRepresentations) {
        this.addPropertyAlt(Expertise.class, altRepresentations);
    }

    public List<Hobby> getHobbies() {
        return this.getProperties(Hobby.class);
    }

    public void addHobby(Hobby hobby) {
        this.addProperty(hobby);
    }

    public Hobby addHobby(String hobby) {
        Hobby type = new Hobby(hobby);
        this.addHobby(type);
        return type;
    }

    public void addHobbyAlt(Hobby ... altRepresentations) {
        this.addPropertyAlt(Hobby.class, altRepresentations);
    }

    public List<Interest> getInterests() {
        return this.getProperties(Interest.class);
    }

    public void addInterest(Interest interest) {
        this.addProperty(interest);
    }

    public Interest addInterest(String interest) {
        Interest type = new Interest(interest);
        this.addInterest(type);
        return type;
    }

    public void addInterestAlt(Interest ... altRepresentations) {
        this.addPropertyAlt(Interest.class, altRepresentations);
    }

    public List<OrgDirectory> getOrgDirectories() {
        return this.getProperties(OrgDirectory.class);
    }

    public void addOrgDirectory(OrgDirectory orgDirectory) {
        this.addProperty(orgDirectory);
    }

    public OrgDirectory addOrgDirectory(String orgDirectory) {
        OrgDirectory type = new OrgDirectory(orgDirectory);
        this.addOrgDirectory(type);
        return type;
    }

    public void addOrgDirectoryAlt(OrgDirectory ... altRepresentations) {
        this.addPropertyAlt(OrgDirectory.class, altRepresentations);
    }

    @Override
    public Iterator<VCardProperty> iterator() {
        return this.properties.values().iterator();
    }

    public <T extends VCardProperty> T getProperty(Class<T> clazz) {
        return (T)((VCardProperty)clazz.cast(this.properties.first(clazz)));
    }

    public <T extends VCardProperty> List<T> getProperties(Class<T> clazz) {
        return new VCardPropertyList<T>(clazz);
    }

    public <T extends VCardProperty> List<List<T>> getPropertiesAlt(Class<T> clazz) {
        ArrayList<VCardProperty> propertiesWithoutAltIds = new ArrayList<VCardProperty>();
        ListMultimap<String, VCardProperty> propertiesWithAltIds = new ListMultimap<String, VCardProperty>();
        for (VCardProperty property : this.getProperties(clazz)) {
            String altId = ((HasAltId)((Object)property)).getAltId();
            if (altId == null) {
                propertiesWithoutAltIds.add(property);
                continue;
            }
            propertiesWithAltIds.put(altId, property);
        }
        int size = propertiesWithoutAltIds.size() + propertiesWithAltIds.size();
        ArrayList listToReturn = new ArrayList(size);
        for (Map.Entry entry : propertiesWithAltIds) {
            listToReturn.add(Collections.unmodifiableList(entry.getValue()));
        }
        for (VCardProperty property : propertiesWithoutAltIds) {
            ArrayList<VCardProperty> list = new ArrayList<VCardProperty>(1);
            list.add(property);
            listToReturn.add(Collections.unmodifiableList(list));
        }
        return Collections.unmodifiableList(listToReturn);
    }

    public Collection<VCardProperty> getProperties() {
        return this.properties.values();
    }

    public void addProperty(VCardProperty property) {
        this.properties.put(property.getClass(), property);
    }

    public List<VCardProperty> setProperty(VCardProperty property) {
        return this.properties.replace(property.getClass(), property);
    }

    public <T extends VCardProperty> List<T> setProperty(Class<T> clazz, T property) {
        List<VCardProperty> replaced = this.properties.replace(clazz, property);
        return VCard.castList(replaced, clazz);
    }

    public boolean removeProperty(VCardProperty property) {
        return this.properties.remove(property.getClass(), property);
    }

    public <T extends VCardProperty> List<T> removeProperties(Class<T> clazz) {
        List<VCardProperty> removed = this.properties.removeAll(clazz);
        return VCard.castList(removed, clazz);
    }

    public RawProperty getExtendedProperty(String name) {
        for (RawProperty raw : this.getExtendedProperties()) {
            if (!raw.getPropertyName().equalsIgnoreCase(name)) continue;
            return raw;
        }
        return null;
    }

    public List<RawProperty> getExtendedProperties(String name) {
        ArrayList<RawProperty> properties = new ArrayList<RawProperty>();
        for (RawProperty raw : this.getExtendedProperties()) {
            if (!raw.getPropertyName().equalsIgnoreCase(name)) continue;
            properties.add(raw);
        }
        return Collections.unmodifiableList(properties);
    }

    public List<RawProperty> getExtendedProperties() {
        return this.getProperties(RawProperty.class);
    }

    public RawProperty addExtendedProperty(String name, String value) {
        RawProperty raw = new RawProperty(name, value);
        this.addProperty(raw);
        return raw;
    }

    public RawProperty addExtendedProperty(String name, String value, VCardDataType dataType) {
        RawProperty raw = new RawProperty(name, value, dataType);
        this.addProperty(raw);
        return raw;
    }

    public RawProperty setExtendedProperty(String name, String value) {
        this.removeExtendedProperty(name);
        return this.addExtendedProperty(name, value);
    }

    public RawProperty setExtendedProperty(String name, String value, VCardDataType dataType) {
        this.removeExtendedProperty(name);
        return this.addExtendedProperty(name, value, dataType);
    }

    public List<RawProperty> removeExtendedProperty(String name) {
        List<RawProperty> all = this.getExtendedProperties();
        ArrayList<RawProperty> toRemove = new ArrayList<RawProperty>();
        for (RawProperty property : all) {
            if (!property.getPropertyName().equalsIgnoreCase(name)) continue;
            toRemove.add(property);
        }
        all.removeAll(toRemove);
        return Collections.unmodifiableList(toRemove);
    }

    public <T extends VCardProperty> void addPropertyAlt(Class<T> propertyClass, T ... altRepresentations) {
        this.addPropertyAlt(propertyClass, (Collection<T>)Arrays.asList(altRepresentations));
    }

    public <T extends VCardProperty> void addPropertyAlt(Class<T> propertyClass, Collection<T> altRepresentations) {
        String altId = VCard.generateAltId(this.getProperties(propertyClass));
        for (VCardProperty property : altRepresentations) {
            ((HasAltId)((Object)property)).setAltId(altId);
            this.addProperty(property);
        }
    }

    public <T extends VCardProperty> List<T> setPropertyAlt(Class<T> propertyClass, T ... altRepresentations) {
        return this.setPropertyAlt(propertyClass, (Collection<T>)Arrays.asList(altRepresentations));
    }

    public <T extends VCardProperty> List<T> setPropertyAlt(Class<T> propertyClass, Collection<T> altRepresentations) {
        List<T> removed = this.removeProperties(propertyClass);
        this.addPropertyAlt(propertyClass, altRepresentations);
        return removed;
    }

    private static <T> List<T> castList(List<?> list, Class<T> castTo) {
        ArrayList<T> casted = new ArrayList<T>(list.size());
        for (Object object : list) {
            casted.add(castTo.cast(object));
        }
        return Collections.unmodifiableList(casted);
    }

    public ValidationWarnings validate(VCardVersion version) {
        ValidationWarnings warnings = new ValidationWarnings();
        if (this.getStructuredName() == null && (version == VCardVersion.V2_1 || version == VCardVersion.V3_0)) {
            warnings.add(null, new Warning(0, new Object[0]));
        }
        if (this.getFormattedName() == null && (version == VCardVersion.V3_0 || version == VCardVersion.V4_0)) {
            warnings.add(null, new Warning(1, new Object[0]));
        }
        for (VCardProperty property : this) {
            List<Warning> propWarnings = property.validate(version, this);
            if (propWarnings.isEmpty()) continue;
            warnings.add(property, propWarnings);
        }
        return warnings;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("version=").append((Object)this.version);
        for (VCardProperty property : this.properties.values()) {
            sb.append(StringUtils.NEWLINE).append(property);
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        int propertiesHash = 1;
        for (VCardProperty property : this.properties.values()) {
            propertiesHash += property.hashCode();
        }
        result = 31 * result + propertiesHash;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VCard other = (VCard)obj;
        if (this.version != other.version) {
            return false;
        }
        if (this.properties.size() != other.properties.size()) {
            return false;
        }
        for (Map.Entry<Class<? extends VCardProperty>, List<VCardProperty>> entry : this.properties) {
            Class<? extends VCardProperty> key = entry.getKey();
            List<VCardProperty> value = entry.getValue();
            List<VCardProperty> otherValue = other.properties.get(key);
            if (value.size() != otherValue.size()) {
                return false;
            }
            ArrayList<VCardProperty> otherValueCopy = new ArrayList<VCardProperty>(otherValue);
            for (VCardProperty property : value) {
                if (otherValueCopy.remove(property)) continue;
                return false;
            }
        }
        return true;
    }

    static <T extends HasAltId> String generateAltId(Collection<T> properties) {
        HashSet<String> altIds = new HashSet<String>();
        for (HasAltId property : properties) {
            String altId = property.getAltId();
            if (altId == null) continue;
            altIds.add(altId);
        }
        int altId = 1;
        while (altIds.contains(Integer.toString(altId))) {
            ++altId;
        }
        return Integer.toString(altId);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VCardPropertyList<T extends VCardProperty>
    extends AbstractList<T> {
        protected final Class<T> propertyClass;
        protected final List<VCardProperty> properties;

        public VCardPropertyList(Class<T> propertyClass) {
            this.propertyClass = propertyClass;
            this.properties = VCard.this.properties.get(propertyClass);
        }

        @Override
        public void add(int index, T value) {
            this.properties.add(index, (VCardProperty)value);
        }

        @Override
        public T remove(int index) {
            VCardProperty removed = this.properties.remove(index);
            return this.cast(removed);
        }

        @Override
        public T get(int index) {
            VCardProperty property = this.properties.get(index);
            return this.cast(property);
        }

        @Override
        public T set(int index, T value) {
            VCardProperty replaced = this.properties.set(index, (VCardProperty)value);
            return this.cast(replaced);
        }

        @Override
        public int size() {
            return this.properties.size();
        }

        private T cast(VCardProperty value) {
            return (T)((VCardProperty)this.propertyClass.cast(value));
        }
    }
}

