/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByExpander;
import org.dmfs.rfc5545.recur.Freq;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.RuleIterator;
import org.dmfs.rfc5545.recur.StaticUtils;

final class ByYearDayExpander
extends ByExpander {
    private final int[] mYearDays;
    private final ByExpander.Scope mScope;
    private final int[] mMonths;

    public ByYearDayExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarMetrics, long start) {
        super(previous, calendarMetrics, start);
        this.mYearDays = StaticUtils.ListToSortedArray(rule.getByPart(RecurrenceRule.Part.BYYEARDAY));
        this.mScope = rule.getFreq() == Freq.WEEKLY || rule.hasPart(RecurrenceRule.Part.BYWEEKNO) ? (rule.hasPart(RecurrenceRule.Part.BYMONTH) ? ByExpander.Scope.WEEKLY_AND_MONTHLY : ByExpander.Scope.WEEKLY) : (rule.getFreq() == Freq.YEARLY && !rule.hasPart(RecurrenceRule.Part.BYMONTH) ? ByExpander.Scope.YEARLY : ByExpander.Scope.MONTHLY);
        this.mMonths = (int[])(this.mScope == ByExpander.Scope.WEEKLY_AND_MONTHLY && rule.hasPart(RecurrenceRule.Part.BYMONTH) ? StaticUtils.ListToArray(rule.getByPart(RecurrenceRule.Part.BYMONTH)) : null);
    }

    @Override
    void expand(long instance, long start) {
        int year = Instance.year((long)instance);
        int month = Instance.month((long)instance);
        int dayOfMonth = Instance.dayOfMonth((long)instance);
        int hour = Instance.hour((long)instance);
        int minute = Instance.minute((long)instance);
        int second = Instance.second((long)instance);
        int yearDays = this.mCalendarMetrics.getDaysPerYear(year);
        int startDayOfYear = this.mCalendarMetrics.getDayOfYear(Instance.year((long)start), Instance.month((long)start), Instance.dayOfMonth((long)start));
        int[] nArray = this.mYearDays;
        int n = nArray.length;
        block6: for (int i = 0; i < n; ++i) {
            int day;
            int actualDay = day = nArray[i];
            if (day < 0) {
                actualDay = day + yearDays + 1;
            }
            switch (this.mScope) {
                case WEEKLY: {
                    int monthAndDay;
                    int prevYearDays = this.mCalendarMetrics.getDaysPerYear(year - 1);
                    int nextYearDays = this.mCalendarMetrics.getDaysPerYear(year + 1);
                    int prevYearDay = day;
                    int nextYearDay = day;
                    if (day < 0) {
                        prevYearDay = day + prevYearDays + 1;
                        nextYearDay = day + nextYearDays + 1;
                    }
                    int oldWeek = this.mCalendarMetrics.getWeekOfYear(year, month, dayOfMonth);
                    int newWeek = this.mCalendarMetrics.getWeekOfYear(year, actualDay);
                    if (0 < actualDay && actualDay <= yearDays && newWeek == oldWeek) {
                        monthAndDay = this.mCalendarMetrics.getMonthAndDayOfYearDay(year, actualDay);
                        this.addInstance(Instance.setMonthAndDayOfMonth((long)year, (int)CalendarMetrics.packedMonth((int)monthAndDay), (int)CalendarMetrics.dayOfMonth((int)monthAndDay)));
                        continue block6;
                    }
                    if (0 < nextYearDay && nextYearDay <= nextYearDays && nextYearDay < 7) {
                        newWeek = this.mCalendarMetrics.getWeekOfYear(year + 1, nextYearDay);
                        if (newWeek != oldWeek) continue block6;
                        monthAndDay = this.mCalendarMetrics.getMonthAndDayOfYearDay(year + 1, nextYearDay);
                        this.addInstance(Instance.make((int)(year + 1), (int)CalendarMetrics.packedMonth((int)monthAndDay), (int)CalendarMetrics.dayOfMonth((int)monthAndDay), (int)hour, (int)minute, (int)second));
                        continue block6;
                    }
                    if (0 >= prevYearDay || prevYearDay > prevYearDays || prevYearDay <= prevYearDays - 7 || (newWeek = this.mCalendarMetrics.getWeekOfYear(year - 1, prevYearDay)) != oldWeek) continue block6;
                    monthAndDay = this.mCalendarMetrics.getMonthAndDayOfYearDay(year - 1, prevYearDay);
                    this.addInstance(Instance.make((int)(year - 1), (int)CalendarMetrics.packedMonth((int)monthAndDay), (int)CalendarMetrics.dayOfMonth((int)monthAndDay), (int)hour, (int)minute, (int)second));
                    continue block6;
                }
                case WEEKLY_AND_MONTHLY: {
                    int newMonth;
                    int monthAndDay;
                    int prevYearDays = this.mCalendarMetrics.getDaysPerYear(year - 1);
                    int nextYearDays = this.mCalendarMetrics.getDaysPerYear(year + 1);
                    int prevYearDay = day;
                    int nextYearDay = day;
                    if (day < 0) {
                        prevYearDay = day + prevYearDays + 1;
                        nextYearDay = day + nextYearDays + 1;
                    }
                    int oldWeek = this.mCalendarMetrics.getWeekOfYear(year, month, dayOfMonth);
                    int newWeek = this.mCalendarMetrics.getWeekOfYear(year, actualDay);
                    if (0 < actualDay && actualDay <= yearDays && newWeek == oldWeek) {
                        monthAndDay = this.mCalendarMetrics.getMonthAndDayOfYearDay(year, actualDay);
                        newMonth = CalendarMetrics.packedMonth((int)monthAndDay);
                        if ((this.mMonths == null || StaticUtils.linearSearch(this.mMonths, newMonth) < 0) && (this.mMonths != null || newMonth != month)) continue block6;
                        this.addInstance(Instance.setMonthAndDayOfMonth((long)year, (int)newMonth, (int)CalendarMetrics.dayOfMonth((int)monthAndDay)));
                        continue block6;
                    }
                    if (0 < nextYearDay && nextYearDay <= nextYearDays && nextYearDay < 7) {
                        newWeek = this.mCalendarMetrics.getWeekOfYear(year + 1, nextYearDay);
                        monthAndDay = this.mCalendarMetrics.getMonthAndDayOfYearDay(year + 1, nextYearDay);
                        newMonth = CalendarMetrics.packedMonth((int)monthAndDay);
                        if ((newWeek != oldWeek || this.mMonths == null || StaticUtils.linearSearch(this.mMonths, newMonth) < 0) && (this.mMonths != null || newMonth != month)) continue block6;
                        this.addInstance(Instance.make((int)(year + 1), (int)newMonth, (int)CalendarMetrics.dayOfMonth((int)monthAndDay), (int)hour, (int)minute, (int)second));
                        continue block6;
                    }
                    if (0 >= prevYearDay || prevYearDay > prevYearDays || prevYearDay <= prevYearDays - 7) continue block6;
                    newWeek = this.mCalendarMetrics.getWeekOfYear(year - 1, prevYearDay);
                    monthAndDay = this.mCalendarMetrics.getMonthAndDayOfYearDay(year - 1, prevYearDay);
                    newMonth = CalendarMetrics.packedMonth((int)monthAndDay);
                    if ((newWeek != oldWeek || this.mMonths == null || StaticUtils.linearSearch(this.mMonths, newMonth) < 0) && (this.mMonths != null || newMonth != month)) continue block6;
                    this.addInstance(Instance.make((int)(year - 1), (int)newMonth, (int)CalendarMetrics.dayOfMonth((int)monthAndDay), (int)hour, (int)minute, (int)second));
                    continue block6;
                }
                case MONTHLY: {
                    int monthAndDay;
                    int newMonth;
                    if (0 >= actualDay || actualDay > yearDays || actualDay < startDayOfYear && year == Instance.year((long)start) || (newMonth = CalendarMetrics.packedMonth((int)(monthAndDay = this.mCalendarMetrics.getMonthAndDayOfYearDay(year, actualDay)))) != month) continue block6;
                    this.addInstance(Instance.setMonthAndDayOfMonth((long)instance, (int)newMonth, (int)CalendarMetrics.dayOfMonth((int)monthAndDay)));
                    continue block6;
                }
                case YEARLY: {
                    if (0 >= actualDay || actualDay > yearDays || actualDay < startDayOfYear && year == Instance.year((long)start)) continue block6;
                    int monthAndDay = this.mCalendarMetrics.getMonthAndDayOfYearDay(year, actualDay);
                    this.addInstance(Instance.setMonthAndDayOfMonth((long)instance, (int)CalendarMetrics.packedMonth((int)monthAndDay), (int)CalendarMetrics.dayOfMonth((int)monthAndDay)));
                }
            }
        }
    }
}

