/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileEmpty;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileKilled;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.sequencediagram.NotePosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionList
implements Instruction {
    private final List<Instruction> all = new ArrayList<Instruction>();
    private boolean killed = false;
    private final Swimlane defaultSwimlane;

    public InstructionList() {
        this(null);
    }

    public boolean isEmpty() {
        return this.all.isEmpty();
    }

    public InstructionList(Swimlane swimlane) {
        this.defaultSwimlane = swimlane;
    }

    @Override
    public void add(Instruction instruction) {
        if (!this.killed) {
            this.all.add(instruction);
        }
    }

    @Override
    public Ftile createFtile(FtileFactory ftileFactory) {
        if (this.all.size() == 0) {
            return new FtileEmpty(ftileFactory.shadowing(), this.defaultSwimlane);
        }
        Ftile ftile = null;
        for (Instruction instruction : this.all) {
            Ftile ftile2 = instruction.createFtile(ftileFactory);
            if (instruction.getInLinkRendering() != null) {
                ftile2 = ftileFactory.decorateIn(ftile2, instruction.getInLinkRendering());
            }
            if (ftile == null) {
                ftile = ftile2;
                continue;
            }
            ftile = ftileFactory.assembly(ftile, ftile2);
        }
        if (this.killed) {
            ftile = new FtileKilled(ftile);
        }
        return ftile;
    }

    @Override
    public final boolean kill() {
        this.killed = true;
        return true;
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.all.iterator().next().getInLinkRendering();
    }

    public Instruction getLast() {
        if (this.all.size() == 0) {
            return null;
        }
        return this.all.get(this.all.size() - 1);
    }

    @Override
    public void addNote(Display display, NotePosition notePosition) {
        this.getLast().addNote(display, notePosition);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return InstructionList.getSwimlanes2(this.all);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.all.get(0).getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getLast().getSwimlaneOut();
    }

    public static Set<Swimlane> getSwimlanes2(List<? extends Instruction> list) {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>();
        for (Instruction instruction : list) {
            hashSet.addAll(instruction.getSwimlanes());
        }
        return Collections.unmodifiableSet(hashSet);
    }
}

