/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.uimacpp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.admin.CASFactory;
import org.apache.uima.cas.impl.CASCompleteSerializer;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CASMgrSerializer;
import org.apache.uima.cas.impl.CASSerializer;
import org.apache.uima.cas.impl.Serialization;
import org.apache.uima.collection.CasConsumer;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.xml.sax.SAXException;

public class CppUimajEngine {
    private String exceptionString = "";
    private AnalysisEngine ae = null;
    private CasConsumer cc = null;
    private boolean requiresTCas = true;
    private CASImpl casImpl = null;
    private int[] heap;
    private int[] indexedFSs;
    private String[] stringSymbolTable;
    private byte[] byteHeapArray;
    private short[] shortHeapArray;
    private long[] longHeapArray;

    private void logException(Exception exc) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exc.printStackTrace(pw);
        this.exceptionString = sw.toString();
        pw.close();
    }

    public int initialize(String config, String dataPath, int[] typeInheritance, int[] typePriorities, int[] featureDefs, int[] featureOffset, String[] typeNames, String[] featureNames, int[] stringSubTypes, String[] stringSubTypeValues, int[] stringSubTypeValuePos, String[] indexIDs, int[] indexKinds, int[] compStarts, int[] compDefs) {
        int result = 0;
        try {
            CASMgrSerializer serializer = new CASMgrSerializer();
            serializer.typeOrder = typePriorities;
            serializer.indexNames = indexIDs;
            serializer.nameToIndexMap = new int[indexIDs.length];
            for (int i = 0; i < serializer.nameToIndexMap.length; ++i) {
                serializer.nameToIndexMap[i] = i;
            }
            serializer.indexingStrategy = indexKinds;
            serializer.comparatorIndex = compStarts;
            serializer.comparators = compDefs;
            serializer.typeNames = typeNames;
            serializer.featureNames = featureNames;
            serializer.typeInheritance = typeInheritance;
            serializer.featDecls = featureDefs;
            serializer.topTypeCode = 1;
            serializer.featureOffsets = featureOffset;
            serializer.stringSubtypes = stringSubTypes;
            serializer.stringSubtypeValues = stringSubTypeValues;
            serializer.stringSubtypeValuePos = stringSubTypeValuePos;
            byte[] bar = config.getBytes("UTF-16");
            ByteArrayInputStream bais = new ByteArrayInputStream(bar);
            XMLInputSource in = new XMLInputSource(bais, null);
            ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
            bais.close();
            ResourceManager resMgr = UIMAFramework.newDefaultResourceManager();
            resMgr.setDataPath(dataPath);
            if (specifier instanceof CasConsumerDescription) {
                this.cc = UIMAFramework.produceCasConsumer(specifier);
                CasConsumerDescription ccdesc = (CasConsumerDescription)specifier;
                Capability[] capabilities = ccdesc.getCasConsumerMetaData().getCapabilities();
                for (int i = 0; i < capabilities.length; ++i) {
                    String[] inputsofas = capabilities[i].getInputSofas();
                    if (inputsofas.length <= 0) continue;
                    this.requiresTCas = false;
                }
            } else {
                this.ae = UIMAFramework.produceAnalysisEngine(specifier, resMgr, null);
            }
            this.casImpl = (CASImpl)CASFactory.createCAS();
            this.casImpl.commitTypeSystem();
            this.casImpl.initCASIndexes();
            this.casImpl.getIndexRepositoryMgr().commit();
            CASCompleteSerializer completeSerializer = new CASCompleteSerializer();
            completeSerializer.setCasMgrSerializer(serializer);
            completeSerializer.setCasSerializer(Serialization.serializeCAS(this.casImpl));
            this.casImpl.getBinaryCasSerDes().reinit(completeSerializer);
        }
        catch (Exception exc) {
            result = 1;
            this.logException(exc);
        }
        return result;
    }

    String stringTableToString(String[] s) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < s.length; ++i) {
            buffer.append(i + ": " + s[i] + ", ");
        }
        return buffer.toString();
    }

    public int process(String doc, int[] heapArray, int[] fsIndex, String[] stringTable, int[] resultSpecTypes, int[] resultSpecFeatures, int sofaNum, byte[] aByteHeapArray, short[] aShortHeapArray, long[] aLongHeapArray) {
        int result = 0;
        try {
            this.casImpl.reset();
            CASSerializer serializer = new CASSerializer();
            serializer.heapArray = heapArray;
            serializer.fsIndex = fsIndex;
            serializer.stringTable = stringTable;
            serializer.byteHeapArray = aByteHeapArray;
            serializer.shortHeapArray = aShortHeapArray;
            serializer.longHeapArray = aLongHeapArray;
            this.casImpl.getBinaryCasSerDes().reinit(serializer);
            if (this.ae != null) {
                int i;
                ResultSpecification rs = this.ae.createResultSpecification(this.casImpl.getTypeSystem());
                for (i = 0; i < resultSpecTypes.length; ++i) {
                    rs.addResultType(this.casImpl.getTypeSystemImpl().ll_getTypeForCode(resultSpecTypes[i]).getName(), false);
                }
                for (i = 0; i < resultSpecFeatures.length; ++i) {
                    rs.addResultFeature(this.casImpl.getTypeSystemImpl().ll_getFeatureForCode(resultSpecFeatures[i]).getName());
                }
                this.ae.process(this.casImpl, rs);
            } else if (this.cc != null) {
                if (this.requiresTCas && sofaNum == 0) {
                    result = 1;
                    this.exceptionString = "This CasConsumer expects a View, but the Sofa from which to construct one is not specified.";
                } else if (sofaNum > 0) {
                    CAS view = this.casImpl.getView(sofaNum);
                    this.cc.processCas(view);
                } else {
                    this.cc.processCas(this.casImpl);
                }
            }
            CASSerializer deSerializer = Serialization.serializeCAS(this.casImpl);
            this.saveSerializedCAS(deSerializer);
        }
        catch (Exception exc) {
            result = 1;
            this.logException(exc);
        }
        return result;
    }

    private void saveSerializedCAS(CASSerializer deSerializer) {
        this.heap = deSerializer.heapArray;
        this.indexedFSs = deSerializer.fsIndex;
        this.stringSymbolTable = deSerializer.stringTable;
        this.byteHeapArray = deSerializer.byteHeapArray;
        this.shortHeapArray = deSerializer.shortHeapArray;
        this.longHeapArray = deSerializer.longHeapArray;
    }

    public int[] getHeap() {
        return this.heap;
    }

    public int[] getIndexedFSs() {
        return this.indexedFSs;
    }

    public String[] getStringTable() {
        return this.stringSymbolTable;
    }

    public byte[] getByteHeap() {
        return this.byteHeapArray;
    }

    public short[] getShortHeap() {
        return this.shortHeapArray;
    }

    public long[] getLongHeap() {
        return this.longHeapArray;
    }

    public int destroy() {
        int result = 0;
        try {
            if (this.ae != null) {
                this.ae.destroy();
                this.ae = null;
            }
        }
        catch (Exception exc) {
            result = 1;
            this.logException(exc);
        }
        return result;
    }

    public int batchProcessComplete() {
        int result = 0;
        try {
            this.cc.batchProcessComplete(null);
        }
        catch (ResourceProcessException e) {
            this.logException(e);
            return 100;
        }
        catch (IOException e) {
            this.logException(e);
            return 100;
        }
        return result;
    }

    public int collectionProcessComplete() {
        int result = 0;
        try {
            this.cc.batchProcessComplete(null);
        }
        catch (ResourceProcessException e) {
            this.logException(e);
            return 100;
        }
        catch (IOException e) {
            this.logException(e);
            return 100;
        }
        return result;
    }

    public String resolveImports(String inDesc, String dataPath) {
        try {
            byte[] bar = inDesc.getBytes("UTF-16");
            ByteArrayInputStream bais = new ByteArrayInputStream(bar);
            XMLInputSource in = new XMLInputSource(bais, null);
            ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
            bais.close();
            ResourceManager resMgr = UIMAFramework.newDefaultResourceManager();
            resMgr.setDataPath(dataPath);
            if (specifier instanceof AnalysisEngineDescription) {
                AnalysisEngineDescription aeSpecifier = (AnalysisEngineDescription)specifier;
                aeSpecifier.getDelegateAnalysisEngineSpecifiers();
                aeSpecifier.getAnalysisEngineMetaData().resolveImports(resMgr);
                StringWriter writer = new StringWriter();
                aeSpecifier.toXML(writer);
                return writer.toString();
            }
            if (specifier instanceof CasConsumerDescription) {
                CasConsumerDescription ccSpecifier = (CasConsumerDescription)specifier;
                ccSpecifier.getCasConsumerMetaData().resolveImports(resMgr);
                StringWriter writer = new StringWriter();
                ccSpecifier.toXML(writer);
                return writer.toString();
            }
        }
        catch (UnsupportedEncodingException e) {
            this.logException(e);
        }
        catch (InvalidXMLException e) {
            this.logException(e);
        }
        catch (IOException e) {
            this.logException(e);
        }
        catch (SAXException e) {
            this.logException(e);
        }
        return null;
    }

    protected void finalize() throws Throwable {
        if (this.ae != null) {
            this.destroy();
        }
    }

    public String getLastExceptionString() {
        return this.exceptionString;
    }

    public static String getVersion() {
        return UIMAFramework.getVersionString();
    }
}

