/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.impl;

import java.util.Map;
import org.apache.uima.ResourceFactory;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.collection.base_cpm.BaseCollectionReader;
import org.apache.uima.resource.Resource;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.impl.ResourceManager_impl;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;

public class CollectionReaderFactory_impl
implements ResourceFactory {
    @Override
    public Resource produceResource(Class<? extends Resource> aResourceClass, ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        if (aSpecifier instanceof CollectionReaderDescription) {
            CollectionReaderDescription desc = (CollectionReaderDescription)aSpecifier;
            String frameworkImpl = desc.getFrameworkImplementation();
            if (frameworkImpl == null || frameworkImpl.length() == 0) {
                throw new ResourceInitializationException("missing_framework_implementation", new Object[]{aSpecifier.getSourceUrlString()});
            }
            if (!frameworkImpl.startsWith("org.apache.uima.java")) {
                throw new ResourceInitializationException("unsupported_framework_implementation", new Object[]{desc.getFrameworkImplementation(), aSpecifier.getSourceUrlString()});
            }
            String className = desc.getImplementationName();
            if (className == null || className.length() == 0) {
                throw new ResourceInitializationException("missing_implementation_class_name", new Object[]{aSpecifier.getSourceUrlString()});
            }
            ResourceManager resourceManager = null;
            if (aAdditionalParams != null) {
                resourceManager = (ResourceManager)aAdditionalParams.get("RESOURCE_MANAGER");
            }
            try {
                Class<?> implClass = ResourceManager_impl.loadUserClassOrThrow(className, resourceManager, aSpecifier);
                if (!BaseCollectionReader.class.isAssignableFrom(implClass)) {
                    throw new ResourceInitializationException("not_a_collection_reader", new Object[]{className, aSpecifier.getSourceUrlString()});
                }
                if (!aResourceClass.isAssignableFrom(implClass)) {
                    throw new ResourceInitializationException("resource_does_not_implement_interface", new Object[]{className, aResourceClass.getName(), aSpecifier.getSourceUrlString()});
                }
                Resource resource = (Resource)implClass.newInstance();
                if (resource.initialize(aSpecifier, aAdditionalParams)) {
                    ((CollectionReader_ImplBase)resource).getCasManager().addMetaData((ProcessingResourceMetaData)resource.getMetaData().clone());
                    return resource;
                }
                throw new ResourceInitializationException("error_initializing_from_descriptor", new Object[]{className, aSpecifier.getSourceUrlString()});
            }
            catch (IllegalAccessException e) {
                throw new ResourceInitializationException("could_not_instantiate", new Object[]{className, aSpecifier.getSourceUrlString()}, e);
            }
            catch (InstantiationException e) {
                throw new ResourceInitializationException("could_not_instantiate", new Object[]{className, aSpecifier.getSourceUrlString()}, e);
            }
        }
        return null;
    }
}

