/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.List;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.admin.FSIndexComparator;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CopyOnWriteIndexPart;
import org.apache.uima.cas.impl.FSIndexComparatorImpl;
import org.apache.uima.cas.impl.FsIndex_singletype;
import org.apache.uima.cas.impl.FsIterator_bag;
import org.apache.uima.cas.impl.FsIterator_bag_pear;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.internal.util.CopyOnWriteObjHashSet;
import org.apache.uima.internal.util.ObjHashSet;
import org.apache.uima.jcas.cas.TOP;

public class FsIndex_bag<T extends FeatureStructure>
extends FsIndex_singletype<T> {
    private final ObjHashSet<TOP> index;

    FsIndex_bag(CASImpl cas, Type type, int initialSize, int indexType, FSIndexComparator comparatorForIndexSpecs) {
        super(cas, type, indexType, FsIndex_bag.cleanUpComparator(comparatorForIndexSpecs, cas));
        this.index = new ObjHashSet<TOP>(initialSize, TOP.class, TOP._singleton);
    }

    private static FSIndexComparator cleanUpComparator(FSIndexComparator comp, CASImpl casImpl) {
        FSIndexComparator newComp;
        if (comp.getNumberOfKeys() > 0) {
            newComp = new FSIndexComparatorImpl();
            newComp.setType(comp.getType());
        } else {
            newComp = comp;
        }
        return newComp;
    }

    @Override
    public void flush() {
        super.flush();
        this.index.clear();
    }

    @Override
    public final void insert(T fs) {
        this.maybeCopy();
        this.index.add((TOP)fs);
    }

    @Override
    public int compare(FeatureStructure fs1, FeatureStructure fs2) {
        return fs1 == fs2 ? 0 : (fs1._id() < fs2._id() ? -1 : 1);
    }

    @Override
    public boolean contains(FeatureStructure fs) {
        return this.index.contains(fs);
    }

    boolean ll_contains(int fsAddr) {
        return this.contains((FeatureStructure)this.casImpl.getFsFromId_checked(fsAddr));
    }

    @Override
    public T find(FeatureStructure fs) {
        int resultAddr = this.index.find((TOP)fs);
        if (resultAddr >= 0) {
            return (T)fs;
        }
        return null;
    }

    @Override
    public int size() {
        return this.index.size();
    }

    @Override
    public boolean deleteFS(T fs) {
        this.maybeCopy();
        return this.index.remove(fs);
    }

    @Override
    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void bulkAddTo(List<T> fss) {
        fss.addAll(this.index);
    }

    @Override
    public LowLevelIterator<T> iterator(boolean orderNotNeeded, boolean ignoreType) {
        CopyOnWriteIndexPart cow_index_wrapper = this.getNonNullCow();
        return this.casImpl.inPearContext() ? new FsIterator_bag_pear(this, this.type, cow_index_wrapper) : new FsIterator_bag(this, this.type, cow_index_wrapper);
    }

    @Override
    protected CopyOnWriteIndexPart createCopyOnWriteIndexPart() {
        return new CopyOnWriteObjHashSet<TOP>(this.index);
    }

    @Override
    public int ll_maxAnnotSpan() {
        return Integer.MAX_VALUE;
    }

    @Override
    public LowLevelIterator<T> iterator() {
        return this.iterator(true, true);
    }
}

