/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.templating.converter;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.Dispatcher;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.exception.OXException;
import com.openexchange.html.HtmlService;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.osgi.SimpleRegistryListener;
import com.openexchange.server.ServiceLookup;
import com.openexchange.session.Session;
import com.openexchange.templating.OXTemplate;
import com.openexchange.templating.TemplateHelperFactory;
import com.openexchange.templating.TemplateService;
import com.openexchange.templating.converter.AssetHelper;
import com.openexchange.templating.converter.Dates;
import com.openexchange.templating.converter.JSONHelper;
import com.openexchange.templating.converter.NativeBuilder;
import com.openexchange.templating.converter.WhitelistedDispatcher;
import com.openexchange.tools.session.ServerSession;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.osgi.framework.ServiceReference;

public class TemplatedResultConverter
implements ResultConverter,
SimpleRegistryListener<TemplateHelperFactory> {
    private final ServiceLookup services;
    private final List<TemplateHelperFactory> helperFactories = new LinkedList<TemplateHelperFactory>();
    private TemplateService templates = null;

    public TemplatedResultConverter(ServiceLookup services, TemplateService templates) {
        this.services = services;
        this.templates = templates;
    }

    public String getInputFormat() {
        return "native";
    }

    public String getOutputFormat() {
        return "template";
    }

    public ResultConverter.Quality getQuality() {
        return ResultConverter.Quality.BAD;
    }

    public void convert(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session, Converter converter) throws OXException {
        OXTemplate template = this.templates.loadTemplate(requestData.getParameter("template"), requestData.getParameter("template"), (Session)session, false);
        HashMap<String, Object> rootObject = new HashMap<String, Object>();
        rootObject.put("templates", this.templates.createHelper(rootObject, (Session)session, false));
        rootObject.put("data", result.getResultObject());
        Locale locale = session.getUser().getLocale();
        StringHelper strings = StringHelper.valueOf((Locale)locale);
        rootObject.put("strings", strings);
        rootObject.put("locale", locale);
        rootObject.put("dates", new Dates(locale));
        rootObject.put("JSON", new JSONHelper());
        rootObject.put("assets", new AssetHelper(requestData.constructURL(null, requestData.getPrefix() + "/templating", false, "action=provide&name=").toString()));
        HashMap<String, Object> helper = new HashMap<String, Object>();
        rootObject.put("helper", helper);
        if (template.getProperty("requires") != null) {
            String requires = template.getProperty("requires");
            for (String require : requires.split(",\\s+")) {
                for (TemplateHelperFactory factory : this.helperFactories) {
                    if (!factory.getName().equalsIgnoreCase(require)) continue;
                    helper.put(require, factory.create(requestData, result, session, converter, rootObject));
                }
            }
        }
        rootObject.put("objects", new NativeBuilderFactory());
        rootObject.put("ox", new WhitelistedDispatcher((Dispatcher)this.services.getService(Dispatcher.class), session, template.isTrusted()));
        if (template.isTrusted()) {
            rootObject.put("session", session.getSessionID());
        }
        rootObject.put("req", requestData);
        StringWriter writer = new StringWriter();
        template.process(rootObject, writer);
        String html = null;
        html = !template.isTrusted() ? ((HtmlService)this.services.getService(HtmlService.class)).sanitize(writer.toString(), "templating", false, null, null) : writer.toString();
        result.setResultObject((Object)html, "template");
        if (template.isTrusted()) {
            result.setHeader("Content-Type", template.getProperty("contentType", "text/html"));
        } else {
            result.setHeader("Content-Type", "text/html");
        }
    }

    public void added(ServiceReference<TemplateHelperFactory> ref, TemplateHelperFactory service) {
        this.helperFactories.add(service);
    }

    public void removed(ServiceReference<TemplateHelperFactory> ref, TemplateHelperFactory service) {
        this.helperFactories.remove(service);
    }

    private static final class NativeBuilderFactory {
        private NativeBuilderFactory() {
        }

        public NativeBuilder build() {
            return new NativeBuilder();
        }
    }
}

