/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl.org.bouncycastle.asn1;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.commons.ssl.org.bouncycastle.asn1.ASN1Encodable;
import org.apache.commons.ssl.org.bouncycastle.asn1.ASN1EncodableVector;
import org.apache.commons.ssl.org.bouncycastle.asn1.ASN1OutputStream;
import org.apache.commons.ssl.org.bouncycastle.asn1.ASN1Sequence;
import org.apache.commons.ssl.org.bouncycastle.asn1.StreamUtil;

public class DERSequence
extends ASN1Sequence {
    private int bodyLength = -1;

    public DERSequence() {
    }

    public DERSequence(ASN1Encodable obj) {
        super(obj);
    }

    public DERSequence(ASN1EncodableVector v) {
        super(v);
    }

    public DERSequence(ASN1Encodable[] array) {
        super(array);
    }

    private int getBodyLength() throws IOException {
        if (this.bodyLength < 0) {
            int length = 0;
            Enumeration e = this.getObjects();
            while (e.hasMoreElements()) {
                Object obj = e.nextElement();
                length += ((ASN1Encodable)obj).toASN1Primitive().toDERObject().encodedLength();
            }
            this.bodyLength = length;
        }
        return this.bodyLength;
    }

    int encodedLength() throws IOException {
        int length = this.getBodyLength();
        return 1 + StreamUtil.calculateBodyLength(length) + length;
    }

    void encode(ASN1OutputStream out) throws IOException {
        ASN1OutputStream dOut = out.getDERSubStream();
        int length = this.getBodyLength();
        out.write(48);
        out.writeLength(length);
        Enumeration e = this.getObjects();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            dOut.writeObject((ASN1Encodable)obj);
        }
    }
}

