/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.RelocationPath;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

class RelocationArg
extends RelocationPath {
    protected final boolean allowSharedFolder;
    protected final boolean autorename;

    public RelocationArg(String fromPath, String toPath, boolean allowSharedFolder, boolean autorename) {
        super(fromPath, toPath);
        this.allowSharedFolder = allowSharedFolder;
        this.autorename = autorename;
    }

    public RelocationArg(String fromPath, String toPath) {
        this(fromPath, toPath, false, false);
    }

    @Override
    public String getFromPath() {
        return this.fromPath;
    }

    @Override
    public String getToPath() {
        return this.toPath;
    }

    public boolean getAllowSharedFolder() {
        return this.allowSharedFolder;
    }

    public boolean getAutorename() {
        return this.autorename;
    }

    public static Builder newBuilder(String fromPath, String toPath) {
        return new Builder(fromPath, toPath);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.allowSharedFolder, this.autorename});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            RelocationArg other = (RelocationArg)obj;
            return !(this.fromPath != other.fromPath && !this.fromPath.equals(other.fromPath) || this.toPath != other.toPath && !this.toPath.equals(other.toPath) || this.allowSharedFolder != other.allowSharedFolder || this.autorename != other.autorename);
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<RelocationArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(RelocationArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("from_path");
            StoneSerializers.string().serialize(value.fromPath, g);
            g.writeFieldName("to_path");
            StoneSerializers.string().serialize(value.toPath, g);
            g.writeFieldName("allow_shared_folder");
            StoneSerializers.boolean_().serialize((Boolean)value.allowSharedFolder, g);
            g.writeFieldName("autorename");
            StoneSerializers.boolean_().serialize((Boolean)value.autorename, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public RelocationArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_autorename;
            Boolean f_allowSharedFolder;
            String f_toPath;
            String f_fromPath;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_fromPath = null;
                f_toPath = null;
                f_allowSharedFolder = false;
                f_autorename = false;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("from_path".equals(field)) {
                        f_fromPath = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("to_path".equals(field)) {
                        f_toPath = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("allow_shared_folder".equals(field)) {
                        f_allowSharedFolder = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("autorename".equals(field)) {
                        f_autorename = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_fromPath == null) {
                    throw new JsonParseException(p, "Required field \"from_path\" missing.");
                }
                if (f_toPath == null) {
                    throw new JsonParseException(p, "Required field \"to_path\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            RelocationArg value = new RelocationArg(f_fromPath, f_toPath, f_allowSharedFolder, f_autorename);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected final String fromPath;
        protected final String toPath;
        protected boolean allowSharedFolder;
        protected boolean autorename;

        protected Builder(String fromPath, String toPath) {
            if (fromPath == null) {
                throw new IllegalArgumentException("Required value for 'fromPath' is null");
            }
            if (!Pattern.matches("(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)", fromPath)) {
                throw new IllegalArgumentException("String 'fromPath' does not match pattern");
            }
            this.fromPath = fromPath;
            if (toPath == null) {
                throw new IllegalArgumentException("Required value for 'toPath' is null");
            }
            if (!Pattern.matches("(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)", toPath)) {
                throw new IllegalArgumentException("String 'toPath' does not match pattern");
            }
            this.toPath = toPath;
            this.allowSharedFolder = false;
            this.autorename = false;
        }

        public Builder withAllowSharedFolder(Boolean allowSharedFolder) {
            this.allowSharedFolder = allowSharedFolder != null ? allowSharedFolder : false;
            return this;
        }

        public Builder withAutorename(Boolean autorename) {
            this.autorename = autorename != null ? autorename : false;
            return this;
        }

        public RelocationArg build() {
            return new RelocationArg(this.fromPath, this.toPath, this.allowSharedFolder, this.autorename);
        }
    }
}

