/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.jsp.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.jsp.ast.ASTJspDirectiveAttribute;
import net.sourceforge.pmd.jsp.rules.AbstractJspRule;
import net.sourceforge.pmd.rules.ImportWrapper;

public class DuplicateJspImports
extends AbstractJspRule {
    private Set<ImportWrapper> imports = new HashSet<ImportWrapper>();

    public void apply(List acus, RuleContext ctx) {
        this.imports.clear();
        super.apply(acus, ctx);
    }

    public Object visit(ASTJspDirectiveAttribute node, Object data) {
        if (!"import".equals(node.getName())) {
            return super.visit(node, data);
        }
        String values = node.getValue();
        StringTokenizer st = new StringTokenizer(values, ",");
        int count = st.countTokens();
        for (int ix = 0; ix < count; ++ix) {
            String token = st.nextToken();
            ImportWrapper wrapper = new ImportWrapper(token, token, node);
            if (this.imports.contains(wrapper)) {
                this.addViolation(data, node, node.getImage());
                continue;
            }
            this.imports.add(wrapper);
        }
        return super.visit(node, data);
    }
}

