/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns.server;

import com.turo.pushy.apns.server.RejectedNotificationException;
import com.turo.pushy.apns.server.RejectionReason;
import com.turo.pushy.apns.server.ValidatingPushNotificationHandler;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class TlsAuthenticationValidatingPushNotificationHandler
extends ValidatingPushNotificationHandler {
    private final Set<String> allowedTopics;
    private static final AsciiString APNS_TOPIC_HEADER = new AsciiString((CharSequence)"apns-topic");

    TlsAuthenticationValidatingPushNotificationHandler(Map<String, Set<String>> deviceTokensByTopic, Map<String, Date> expirationTimestampsByDeviceToken, String baseTopic) {
        super(deviceTokensByTopic, expirationTimestampsByDeviceToken);
        Objects.requireNonNull(baseTopic, "Base topic must not be null for mock server handlers using TLS-based authentication.");
        this.allowedTopics = new HashSet<String>();
        this.allowedTopics.add(baseTopic);
        this.allowedTopics.add(baseTopic + ".voip");
        this.allowedTopics.add(baseTopic + ".complication");
    }

    @Override
    protected void verifyAuthentication(Http2Headers headers) throws RejectedNotificationException {
        String topic;
        CharSequence topicSequence = (CharSequence)headers.get((Object)APNS_TOPIC_HEADER);
        String string = topic = topicSequence != null ? topicSequence.toString() : null;
        if (!this.allowedTopics.contains(topic)) {
            throw new RejectedNotificationException(RejectionReason.BAD_TOPIC);
        }
    }
}

