/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByExpander;
import org.dmfs.rfc5545.recur.Freq;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.RuleIterator;
import org.dmfs.rfc5545.recur.StaticUtils;

final class ByMonthDayExpander
extends ByExpander {
    private final int[] mMonthDays;
    private final ByExpander.Scope mScope;
    private final int[] mMonths;

    public ByMonthDayExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarTools, long start) {
        super(previous, calendarTools, start);
        this.mMonthDays = StaticUtils.ListToSortedArray(rule.getByPart(RecurrenceRule.Part.BYMONTHDAY));
        this.mScope = rule.hasPart(RecurrenceRule.Part.BYWEEKNO) || rule.getFreq() == Freq.WEEKLY ? (rule.hasPart(RecurrenceRule.Part.BYMONTH) || rule.getFreq() == Freq.MONTHLY ? ByExpander.Scope.WEEKLY_AND_MONTHLY : ByExpander.Scope.WEEKLY) : ByExpander.Scope.MONTHLY;
        this.mMonths = (int[])(this.mScope == ByExpander.Scope.WEEKLY_AND_MONTHLY && rule.hasPart(RecurrenceRule.Part.BYMONTH) ? StaticUtils.ListToArray(rule.getByPart(RecurrenceRule.Part.BYMONTH)) : null);
    }

    @Override
    void expand(long instance, long start) {
        CalendarMetrics calendarMetrics = this.mCalendarMetrics;
        int year = Instance.year((long)instance);
        int month = Instance.month((long)instance);
        int startYear = Instance.year((long)start);
        int startMonth = Instance.month((long)start);
        if (year < startYear || year == startYear && month < startMonth) {
            return;
        }
        int dayOfMonth = Instance.dayOfMonth((long)instance);
        int weekOfYear = 0;
        int hour = Instance.hour((long)instance);
        int minute = Instance.minute((long)instance);
        int second = Instance.second((long)instance);
        int prevMonthDays = 0;
        int nextMonthDays = 0;
        if (this.mScope == ByExpander.Scope.WEEKLY || this.mScope == ByExpander.Scope.WEEKLY_AND_MONTHLY) {
            weekOfYear = calendarMetrics.getWeekOfYear(year, month, dayOfMonth);
            prevMonthDays = month == 0 ? calendarMetrics.getDaysPerPackedMonth(year - 1, calendarMetrics.getMonthsPerYear(year - 1) - 1) : calendarMetrics.getDaysPerPackedMonth(year, month - 1);
            nextMonthDays = month == calendarMetrics.getMonthsPerYear(year) - 1 ? calendarMetrics.getDaysPerPackedMonth(year + 1, 0) : calendarMetrics.getDaysPerPackedMonth(year, month + 1);
        }
        int monthDays = calendarMetrics.getDaysPerPackedMonth(year, month);
        int[] nArray = this.mMonthDays;
        int n = nArray.length;
        block5: for (int i = 0; i < n; ++i) {
            int day;
            int actualDay = day = nArray[i];
            if (day < 0) {
                actualDay = day + monthDays + 1;
            }
            switch (this.mScope) {
                case WEEKLY: {
                    int prevMonthDay = day;
                    int nextMonthDay = day;
                    if (day < 0) {
                        prevMonthDay = day + prevMonthDays + 1;
                        nextMonthDay = day + nextMonthDays + 1;
                    }
                    if (0 < actualDay && actualDay <= monthDays && calendarMetrics.getWeekOfYear(year, month, actualDay) == weekOfYear) {
                        this.addInstance(Instance.make((int)year, (int)month, (int)actualDay, (int)hour, (int)minute, (int)second));
                        continue block5;
                    }
                    if (0 < nextMonthDay && nextMonthDay <= nextMonthDays && nextMonthDay < 7) {
                        if (month < calendarMetrics.getMonthsPerYear(year) - 1) {
                            if (calendarMetrics.getWeekOfYear(year, month + 1, nextMonthDay) != weekOfYear) continue block5;
                            this.addInstance(Instance.make((int)year, (int)(month + 1), (int)nextMonthDay, (int)hour, (int)minute, (int)second));
                            continue block5;
                        }
                        if (calendarMetrics.getWeekOfYear(year + 1, 0, nextMonthDay) != weekOfYear) continue block5;
                        this.addInstance(Instance.make((int)(year + 1), (int)0, (int)nextMonthDay, (int)hour, (int)minute, (int)second));
                        continue block5;
                    }
                    if (0 >= prevMonthDay || prevMonthDay > prevMonthDays || prevMonthDay <= prevMonthDays - 7) continue block5;
                    if (month > 0) {
                        if (calendarMetrics.getWeekOfYear(year, month - 1, prevMonthDay) != weekOfYear) continue block5;
                        this.addInstance(Instance.make((int)year, (int)(month - 1), (int)prevMonthDay, (int)hour, (int)minute, (int)second));
                        continue block5;
                    }
                    if (calendarMetrics.getWeekOfYear(year - 1, calendarMetrics.getMonthsPerYear(year - 1) - 1, prevMonthDay) != weekOfYear) continue block5;
                    this.addInstance(Instance.make((int)(year - 1), (int)(calendarMetrics.getMonthsPerYear(year - 1) - 1), (int)prevMonthDay, (int)hour, (int)minute, (int)second));
                    continue block5;
                }
                case WEEKLY_AND_MONTHLY: {
                    int prevMonthDay2 = day;
                    int nextMonthDay2 = day;
                    if (day < 0) {
                        prevMonthDay2 = day + prevMonthDays + 1;
                        nextMonthDay2 = day + nextMonthDays + 1;
                    }
                    if (0 < actualDay && actualDay <= monthDays && calendarMetrics.getWeekOfYear(year, month, actualDay) == weekOfYear) {
                        if (this.mMonths != null && StaticUtils.linearSearch(this.mMonths, month) < 0) continue block5;
                        this.addInstance(Instance.make((int)year, (int)month, (int)actualDay, (int)hour, (int)minute, (int)second));
                        continue block5;
                    }
                    if (0 < nextMonthDay2 && nextMonthDay2 <= nextMonthDays && nextMonthDay2 < 7) {
                        if (month < calendarMetrics.getMonthsPerYear(year) - 1) {
                            if (calendarMetrics.getWeekOfYear(year, month + 1, nextMonthDay2) != weekOfYear || this.mMonths == null || StaticUtils.linearSearch(this.mMonths, month + 1) < 0) continue block5;
                            this.addInstance(Instance.make((int)year, (int)(month + 1), (int)nextMonthDay2, (int)hour, (int)minute, (int)second));
                            continue block5;
                        }
                        if (calendarMetrics.getWeekOfYear(year + 1, 0, nextMonthDay2) != weekOfYear || this.mMonths == null || StaticUtils.linearSearch(this.mMonths, 0) < 0) continue block5;
                        this.addInstance(Instance.make((int)(year + 1), (int)0, (int)nextMonthDay2, (int)hour, (int)minute, (int)second));
                        continue block5;
                    }
                    if (0 >= prevMonthDay2 || prevMonthDay2 > prevMonthDays || prevMonthDay2 <= prevMonthDays - 7) continue block5;
                    if (month > 0) {
                        if (calendarMetrics.getWeekOfYear(year, month - 1, prevMonthDay2) != weekOfYear || this.mMonths == null || StaticUtils.linearSearch(this.mMonths, month - 1) < 0) continue block5;
                        this.addInstance(Instance.make((int)year, (int)(month - 1), (int)prevMonthDay2, (int)hour, (int)minute, (int)second));
                        continue block5;
                    }
                    if (calendarMetrics.getWeekOfYear(year - 1, calendarMetrics.getMonthsPerYear(year - 1) - 1, prevMonthDay2) != weekOfYear || this.mMonths == null || StaticUtils.linearSearch(this.mMonths, calendarMetrics.getMonthsPerYear(year - 1) - 1) < 0) continue block5;
                    this.addInstance(Instance.make((int)(year - 1), (int)(calendarMetrics.getMonthsPerYear(year - 1) - 1), (int)prevMonthDay2, (int)hour, (int)minute, (int)second));
                    continue block5;
                }
                case MONTHLY: {
                    if (0 >= actualDay) continue block5;
                    this.addInstance(Instance.setDayOfMonth((long)instance, (int)actualDay));
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("invalid scope for ByMonthDayExpander: " + (Object)((Object)this.mScope));
                }
            }
        }
    }
}

