/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged;

import org.fishwife.jrugged.RequestCounter;

public class FlowMeter {
    private RequestCounter counter;
    private long lastTotal;
    private long lastSuccesses;
    private long lastFailures;
    private long lastSampleMillis;
    private double[] lastKnownRates = new double[3];

    public FlowMeter(RequestCounter counter) {
        this.counter = counter;
    }

    private double rate(long events, long t) {
        return (double)events / (double)t * 1000.0;
    }

    public synchronized double[] sample() {
        long[] currCounts = this.counter.sample();
        long now = System.currentTimeMillis();
        if (this.lastSampleMillis != 0L) {
            long deltaTime = now - this.lastSampleMillis;
            if (deltaTime == 0L) {
                return this.lastKnownRates;
            }
            this.lastKnownRates[0] = this.rate(currCounts[0] - this.lastTotal, deltaTime);
            this.lastKnownRates[1] = this.rate(currCounts[1] - this.lastSuccesses, deltaTime);
            this.lastKnownRates[2] = this.rate(currCounts[2] - this.lastFailures, deltaTime);
        } else {
            this.lastKnownRates[2] = 0.0;
            this.lastKnownRates[1] = 0.0;
            this.lastKnownRates[0] = 0.0;
        }
        this.lastTotal = currCounts[0];
        this.lastSuccesses = currCounts[1];
        this.lastFailures = currCounts[2];
        this.lastSampleMillis = now;
        return this.lastKnownRates;
    }
}

