/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.fishwife.jrugged.FailureInterpreter;
import org.fishwife.jrugged.WindowedEventCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultFailureInterpreter
implements FailureInterpreter {
    private Set<Class<? extends Throwable>> ignore = new HashSet<Class<? extends Throwable>>();
    private int limit = 0;
    private long windowMillis = 0L;
    private WindowedEventCounter counter;
    private static Class<? extends Throwable>[] defaultIgnore = new Class[0];

    public DefaultFailureInterpreter() {
        this.setIgnore(defaultIgnore);
    }

    public DefaultFailureInterpreter(int limit, long windowMillis) {
        this.setIgnore(defaultIgnore);
        this.setLimit(limit);
        this.setWindowMillis(windowMillis);
        this.initCounter();
    }

    public DefaultFailureInterpreter(Class<? extends Throwable>[] ignore) {
        this.setIgnore(ignore);
    }

    public DefaultFailureInterpreter(Class<? extends Throwable>[] ignore, int limit, long windowMillis) {
        this.setIgnore(ignore);
        this.setLimit(limit);
        this.setWindowMillis(windowMillis);
        this.initCounter();
    }

    private boolean hasWindowConditions() {
        return this.limit > 0 && this.windowMillis > 0L;
    }

    @Override
    public boolean shouldTrip(Throwable cause) {
        for (Class<? extends Throwable> clazz : this.ignore) {
            if (!clazz.isInstance(cause)) continue;
            return false;
        }
        if (this.hasWindowConditions()) {
            this.counter.mark();
            return this.counter.tally() > this.limit;
        }
        return true;
    }

    private void initCounter() {
        if (this.hasWindowConditions()) {
            int capacity = this.limit + 1;
            if (this.counter == null) {
                this.counter = new WindowedEventCounter(capacity, this.windowMillis);
            } else {
                if (capacity != this.counter.getCapacity()) {
                    this.counter.setCapacity(capacity);
                }
                if (this.windowMillis != this.counter.getWindowMillis()) {
                    this.counter.setWindowMillis(this.windowMillis);
                }
            }
        } else {
            this.counter = null;
        }
    }

    public Set<Class<? extends Throwable>> getIgnore() {
        return this.ignore;
    }

    public synchronized void setIgnore(Class<? extends Throwable>[] ignore) {
        this.ignore = new HashSet<Class<? extends Throwable>>(Arrays.asList(ignore));
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
        this.initCounter();
    }

    public long getWindowMillis() {
        return this.windowMillis;
    }

    public void setWindowMillis(long windowMillis) {
        this.windowMillis = windowMillis;
        this.initCounter();
    }
}

