/*
 * Decompiled with CFR 0.152.
 */
package ezvcard;

import ezvcard.VCard;
import ezvcard.io.chain.ChainingHtmlParser;
import ezvcard.io.chain.ChainingHtmlStringParser;
import ezvcard.io.chain.ChainingHtmlWriter;
import ezvcard.io.chain.ChainingJsonParser;
import ezvcard.io.chain.ChainingJsonStringParser;
import ezvcard.io.chain.ChainingJsonWriter;
import ezvcard.io.chain.ChainingTextParser;
import ezvcard.io.chain.ChainingTextStringParser;
import ezvcard.io.chain.ChainingTextWriter;
import ezvcard.io.chain.ChainingXmlMemoryParser;
import ezvcard.io.chain.ChainingXmlParser;
import ezvcard.io.chain.ChainingXmlWriter;
import ezvcard.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Ezvcard {
    public static final String VERSION;
    public static final String GROUP_ID;
    public static final String ARTIFACT_ID;
    public static final String URL;

    public static ChainingTextStringParser parse(String str) {
        return new ChainingTextStringParser(str);
    }

    public static ChainingTextParser<ChainingTextParser<?>> parse(File file) {
        return new ChainingTextParser(file);
    }

    public static ChainingTextParser<ChainingTextParser<?>> parse(InputStream in) {
        return new ChainingTextParser(in);
    }

    public static ChainingTextParser<ChainingTextParser<?>> parse(Reader reader) {
        return new ChainingTextParser(reader);
    }

    public static ChainingXmlMemoryParser parseXml(String xml) {
        return new ChainingXmlMemoryParser(xml);
    }

    public static ChainingXmlParser<ChainingXmlParser<?>> parseXml(File file) {
        return new ChainingXmlParser(file);
    }

    public static ChainingXmlParser<ChainingXmlParser<?>> parseXml(InputStream in) {
        return new ChainingXmlParser(in);
    }

    public static ChainingXmlParser<ChainingXmlParser<?>> parseXml(Reader reader) {
        return new ChainingXmlParser(reader);
    }

    public static ChainingXmlMemoryParser parseXml(Document document) {
        return new ChainingXmlMemoryParser(document);
    }

    public static ChainingHtmlStringParser parseHtml(String html) {
        return new ChainingHtmlStringParser(html);
    }

    public static ChainingHtmlParser<ChainingHtmlParser<?>> parseHtml(File file) {
        return new ChainingHtmlParser(file);
    }

    public static ChainingHtmlParser<ChainingHtmlParser<?>> parseHtml(InputStream in) {
        return new ChainingHtmlParser(in);
    }

    public static ChainingHtmlParser<ChainingHtmlParser<?>> parseHtml(Reader reader) {
        return new ChainingHtmlParser(reader);
    }

    public static ChainingHtmlParser<ChainingHtmlParser<?>> parseHtml(URL url) {
        return new ChainingHtmlParser(url);
    }

    public static ChainingJsonStringParser parseJson(String json) {
        return new ChainingJsonStringParser(json);
    }

    public static ChainingJsonParser<ChainingJsonParser<?>> parseJson(File file) {
        return new ChainingJsonParser(file);
    }

    public static ChainingJsonParser<ChainingJsonParser<?>> parseJson(InputStream in) {
        return new ChainingJsonParser(in);
    }

    public static ChainingJsonParser<ChainingJsonParser<?>> parseJson(Reader reader) {
        return new ChainingJsonParser(reader);
    }

    public static ChainingTextWriter write(VCard ... vcards) {
        return Ezvcard.write(Arrays.asList(vcards));
    }

    public static ChainingTextWriter write(Collection<VCard> vcards) {
        return new ChainingTextWriter(vcards);
    }

    public static ChainingXmlWriter writeXml(VCard ... vcards) {
        return Ezvcard.writeXml(Arrays.asList(vcards));
    }

    public static ChainingXmlWriter writeXml(Collection<VCard> vcards) {
        return new ChainingXmlWriter(vcards);
    }

    public static ChainingHtmlWriter writeHtml(VCard ... vcards) {
        return Ezvcard.writeHtml(Arrays.asList(vcards));
    }

    public static ChainingHtmlWriter writeHtml(Collection<VCard> vcards) {
        return new ChainingHtmlWriter(vcards);
    }

    public static ChainingJsonWriter writeJson(VCard ... vcards) {
        return Ezvcard.writeJson(Arrays.asList(vcards));
    }

    public static ChainingJsonWriter writeJson(Collection<VCard> vcards) {
        return new ChainingJsonWriter(vcards);
    }

    private Ezvcard() {
    }

    static {
        InputStream in = null;
        Properties props = new Properties();
        try {
            in = Ezvcard.class.getResourceAsStream("ez-vcard.properties");
            props.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
        VERSION = props.getProperty("version");
        GROUP_ID = props.getProperty("groupId");
        ARTIFACT_ID = props.getProperty("artifactId");
        URL = props.getProperty("url");
    }
}

