/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.log4j.Logger;

public final class FileLocator {
    private static final Logger LOGGER = Logger.getLogger((String)"FileLocator");
    private static final String CTAKES_HOME = "CTAKES_HOME";

    private FileLocator() {
    }

    public static InputStream getAsStream(String location) throws FileNotFoundException {
        return FileLocator.getAsStream(FileLocator.class, location);
    }

    public static InputStream getAsStream(Class<?> clazz, String location) throws FileNotFoundException {
        try {
            InputStream is = clazz.getClassLoader().getResourceAsStream(location);
            if (is != null) {
                return is;
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)e.getMessage());
        }
        File file = FileLocator.locateFile(clazz, location);
        return new FileInputStream(file);
    }

    public static File locateFile(String location) throws FileNotFoundException {
        return FileLocator.locateFile(FileLocator.class, location);
    }

    public static File locateFile(Class<?> clazz, String location) throws FileNotFoundException {
        String fullPath = FileLocator.getFullPath(clazz, location);
        File file = new File(fullPath);
        if (!file.exists()) {
            throw new FileNotFoundException("No File at " + location);
        }
        return file;
    }

    private static String createDiscoveredPath(String relativePath, File file, String locationText) {
        try {
            LOGGER.debug((Object)(relativePath + " discovered " + locationText + " as: " + file.getCanonicalPath()));
            return file.getCanonicalPath();
        }
        catch (IOException ioE) {
            LOGGER.debug((Object)(relativePath + " discovered " + locationText + " as: " + file.getPath()));
            return file.getPath();
        }
    }

    public static String getFullPath(String relativePath) throws FileNotFoundException {
        return FileLocator.getFullPathQuiet(FileLocator.class, relativePath);
    }

    public static String getFullPath(Class<?> clazz, String relativePath) throws FileNotFoundException {
        URL[] classpathUrls;
        String fullPath = FileLocator.getFullPathQuiet(clazz, relativePath);
        if (fullPath != null && !fullPath.isEmpty()) {
            return fullPath;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Could not find ").append(relativePath).append("\nas absolute or in $CLASSPATH :\n");
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        for (URL url : classpathUrls = ((URLClassLoader)classLoader).getURLs()) {
            sb.append(url.getFile()).append("\n");
        }
        String cwd = System.getProperty("user.dir");
        sb.append("or in working directory : ").append(cwd).append("\n");
        sb.append("or in any parent thereof (with or without /ctakes/)\n");
        String cTakesHome = System.getenv(CTAKES_HOME);
        sb.append("or in $CTAKES_HOME : ").append(cTakesHome);
        LOGGER.error((Object)sb.toString());
        throw new FileNotFoundException("No File exists at " + relativePath);
    }

    public static String getFullPathQuiet(String relativePath) {
        return FileLocator.getFullPathQuiet(FileLocator.class, relativePath);
    }

    public static String getFullPathQuiet(Class<?> clazz, String relativePath) {
        File file = new File(relativePath);
        if (file.exists()) {
            return FileLocator.createDiscoveredPath(relativePath, file, "without adjustment");
        }
        try {
            file = FileLocator.locateOnClasspath(clazz, relativePath);
            if (file.exists()) {
                return FileLocator.createDiscoveredPath(relativePath, file, "under Classpath");
            }
        }
        catch (FileNotFoundException | URISyntaxException exception) {
            // empty catch block
        }
        String cwd = System.getProperty("user.dir");
        file = new File(cwd, relativePath);
        if (file.exists()) {
            return FileLocator.createDiscoveredPath(relativePath, file, "under Working Directory");
        }
        file = new File(cwd, "resources/" + relativePath);
        if (file.exists()) {
            return FileLocator.createDiscoveredPath(relativePath, file, "under Working Directory resources");
        }
        String cTakesHome = System.getenv(CTAKES_HOME);
        if (cTakesHome != null && !cTakesHome.isEmpty()) {
            file = new File(cTakesHome, relativePath);
            if (file.exists()) {
                return FileLocator.createDiscoveredPath(relativePath, file, "under $CTAKES_HOME");
            }
            file = new File(cTakesHome, "resources/" + relativePath);
            if (file.exists()) {
                return FileLocator.createDiscoveredPath(relativePath, file, "under $CTAKES_HOME resources");
            }
        }
        File cwdDerived = new File(cwd);
        while (cwdDerived.getParentFile() != null) {
            file = new File(cwdDerived = cwdDerived.getParentFile(), relativePath);
            if (file.exists()) {
                return FileLocator.createDiscoveredPath(relativePath, file, "above Working Directory");
            }
            file = new File(cwdDerived, "ctakes/" + relativePath);
            if (!file.exists()) continue;
            return FileLocator.createDiscoveredPath(relativePath, file, "above Working Directory /ctakes");
        }
        return "";
    }

    private static File locateOnClasspath(Class<?> clazz, String relativePath) throws FileNotFoundException, URISyntaxException {
        ClassLoader classLoader = clazz.getClassLoader();
        URL indexUrl = classLoader.getResource(relativePath);
        if (indexUrl == null) {
            throw new FileNotFoundException(relativePath);
        }
        URI indexUri = new URI(indexUrl.toExternalForm());
        if (indexUri.isOpaque()) {
            throw new FileNotFoundException(relativePath);
        }
        return new File(indexUri);
    }
}

