/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.knowtator;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KnowtatorAnnotation {
    public String id;
    public List<Span> spans = new ArrayList<Span>();
    public String spannedText;
    public String type;
    public Map<String, String> stringSlots = new HashMap<String, String>();
    public Map<String, Boolean> booleanSlots = new HashMap<String, Boolean>();
    public Map<String, KnowtatorAnnotation> annotationSlots = new HashMap<String, KnowtatorAnnotation>();

    public Span getCoveringSpan() {
        int begin = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        for (Span span : this.spans) {
            if (span.begin < begin) {
                begin = span.begin;
            }
            if (span.end <= end) continue;
            end = span.end;
        }
        return new Span(begin, end);
    }

    void addSpan(int begin, int end) {
        this.spans.add(new Span(begin, end));
    }

    KnowtatorAnnotation() {
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.spans, this.spannedText, this.type, this.stringSlots, this.booleanSlots, this.annotationSlots});
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        KnowtatorAnnotation that = (KnowtatorAnnotation)obj;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal(this.spans, that.spans) && Objects.equal((Object)this.spannedText, (Object)that.spannedText) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal(this.stringSlots, that.stringSlots) && Objects.equal(this.booleanSlots, that.booleanSlots) && Objects.equal(this.annotationSlots, that.annotationSlots);
    }

    public String toString() {
        Objects.ToStringHelper builder = Objects.toStringHelper((Object)this);
        builder.add("id", (Object)this.id);
        builder.add("spans", this.spans);
        builder.add("spannedText", (Object)this.spannedText);
        builder.add("type", (Object)this.type);
        builder.add("stringSlots", this.stringSlots);
        builder.add("booleanSlots", this.booleanSlots);
        builder.add("mentionSlots", this.annotationSlots);
        return builder.toString();
    }

    public static class Span {
        public int begin;
        public int end;

        Span(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.begin, this.end});
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Span that = (Span)obj;
            return this.begin == that.begin && this.end == that.end;
        }

        public String toString() {
            Objects.ToStringHelper builder = Objects.toStringHelper((Object)this);
            builder.add("begin", (Object)this.begin);
            builder.add("end", (Object)this.end);
            return builder.toString();
        }
    }
}

