/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.internal.util.MsgLocalizationClassLoader;

public class I18nUtil {
    private static final ThreadLocal<Map<Bid, ResourceBundle>> b_cache = ThreadLocal.withInitial(() -> new HashMap());

    public static String localizeMessage(String aResourceBundleName, String aMessageKey, Object[] aArguments) {
        return I18nUtil.localizeMessage(aResourceBundleName, Locale.getDefault(), aMessageKey, aArguments, null);
    }

    public static String localizeMessage(String aResourceBundleName, String aMessageKey, Object[] aArguments, ClassLoader aLoader) {
        return I18nUtil.localizeMessage(aResourceBundleName, Locale.getDefault(), aMessageKey, aArguments, aLoader);
    }

    public static String localizeMessage(String aResourceBundleName, Locale aLocale, String aMessageKey, Object[] aArguments) {
        return I18nUtil.localizeMessage(aResourceBundleName, aLocale, aMessageKey, aArguments, null);
    }

    public static String localizeMessage(String aResourceBundleName, Locale aLocale, String aMessageKey, Object[] aArguments, ClassLoader aLoader) {
        try {
            String message;
            boolean is_stack_climbing_loader;
            if (aLoader == null) {
                aLoader = MsgLocalizationClassLoader.getMsgLocalizationClassLoader();
            }
            boolean bl = is_stack_climbing_loader = aLoader == MsgLocalizationClassLoader.getMsgLocalizationClassLoader();
            if (aResourceBundleName == null) {
                message = "Null ResourceBundle, key = \"" + aMessageKey + "\"";
            } else {
                ClassLoader[] cls = is_stack_climbing_loader ? Misc.getCallingClass_classLoaders() : null;
                ClassLoader final_aLoader = aLoader;
                Bid cache_key = new Bid(aResourceBundleName, aLocale, aLoader, cls);
                ResourceBundle bundle = b_cache.get().computeIfAbsent(cache_key, bid -> ResourceBundle.getBundle(aResourceBundleName, aLocale, final_aLoader));
                message = bundle.getString(aMessageKey);
            }
            if (aArguments != null && aArguments.length > 0) {
                MessageFormat fmt = new MessageFormat(message);
                fmt.setLocale(aLocale);
                return fmt.format(aArguments);
            }
            return message;
        }
        catch (Exception e) {
            return "MESSAGE LOCALIZATION FAILED: The key " + aMessageKey + " may be missing in the properties file " + e.getMessage();
        }
    }

    public static void setTccl(ClassLoader tccl) {
        MsgLocalizationClassLoader.CallClimbingClassLoader.original_thread_context_class_loader.set(tccl);
    }

    public static void removeTccl() {
        MsgLocalizationClassLoader.CallClimbingClassLoader.original_thread_context_class_loader.remove();
    }

    static class Bid {
        final String bundleName;
        final Locale locale;
        final ClassLoader loader;
        final ClassLoader[] loaders;

        public Bid(String bundleName, Locale locale, ClassLoader loader, ClassLoader[] loaders) {
            this.bundleName = bundleName;
            this.locale = locale;
            this.loader = loaders != null ? null : loader;
            this.loaders = loaders;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bundleName == null ? 0 : this.bundleName.hashCode());
            result = 31 * result + (this.loader == null ? 0 : this.loader.hashCode());
            result = 31 * result + (this.loaders == null ? 0 : Arrays.hashCode(this.loaders));
            result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Bid other = (Bid)obj;
            if (this.bundleName == null ? other.bundleName != null : !this.bundleName.equals(other.bundleName)) {
                return false;
            }
            if (this.loader == null ? other.loader != null : !this.loader.equals(other.loader)) {
                return false;
            }
            if (this.locale == null ? other.locale != null : this.locale != other.locale) {
                return false;
            }
            return !(this.loaders == null ? other.loaders != null : !Arrays.equals(this.loaders, other.loaders));
        }
    }
}

