/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.cas.FSIndexRepository;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.FeatureStructureImplC;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.util.AutoCloseableNoException;

abstract class FSsTobeAddedback
implements AutoCloseableNoException {
    static final boolean SHOW = false;
    static final AtomicInteger removes = new AtomicInteger(0);

    FSsTobeAddedback() {
    }

    @Override
    public void close() {
        this.addback();
    }

    protected void logPart(FSIndexRepository view) {
        System.out.format("%,d tobeReindexed: view: %s", removes.incrementAndGet(), view);
    }

    protected void log(FSIndexRepositoryImpl view, int count) {
    }

    private void logPart(FeatureStructureImplC fs, FSIndexRepositoryImpl view) {
        this.log(view);
        System.out.format(",  fs_id = %,d", fs._id);
    }

    protected void log(FeatureStructureImplC fs, FSIndexRepositoryImpl view, int count) {
    }

    protected void log(FSIndexRepositoryImpl view) {
    }

    protected void log(FeatureStructureImplC fs, FSIndexRepositoryImpl view) {
    }

    void recordRemove(FSIndexRepositoryImpl view) {
        throw new UnsupportedOperationException();
    }

    void recordRemove(FSIndexRepositoryImpl view, int count) {
        if (count != 1) {
            throw new UnsupportedOperationException();
        }
        this.recordRemove(view);
    }

    void recordRemove(TOP fs, FSIndexRepositoryImpl view) {
        throw new UnsupportedOperationException();
    }

    void recordRemove(TOP fs, FSIndexRepositoryImpl view, int count) {
        if (count != 1) {
            throw new UnsupportedOperationException();
        }
        this.recordRemove(fs, view);
    }

    void addback() {
        throw new UnsupportedOperationException();
    }

    void addback(TOP fs) {
        throw new UnsupportedOperationException();
    }

    abstract void clear();

    public static FSsTobeAddedback createSingle() {
        return new FSsTobeAddedbackSingle();
    }

    public static FSsTobeAddedback createMultiple(CASImpl cas) {
        return new FSsTobeAddedbackMultiple(cas);
    }

    static class FSsTobeAddedbackMultiple
    extends FSsTobeAddedback {
        final Map<TOP, List<?>> fss2views = new HashMap();
        final CASImpl cas;

        FSsTobeAddedbackMultiple(CASImpl cas) {
            this.cas = cas;
        }

        @Override
        void recordRemove(TOP fs, FSIndexRepositoryImpl view) {
            this.log(fs, view);
            List<?> irList = this.fss2views.get(fs);
            if (null == irList) {
                irList = new ArrayList();
                this.fss2views.put(fs, irList);
            }
            irList.add(view);
        }

        @Override
        void addback() {
            for (Map.Entry<TOP, List<?>> e : this.fss2views.entrySet()) {
                TOP fs = e.getKey();
                List<?> views = e.getValue();
                for (FSIndexRepositoryImpl ir : views) {
                    ir.addback(fs);
                }
            }
            this.clear();
            this.cas.dropProtectIndexesLevel();
        }

        @Override
        void clear() {
            this.fss2views.clear();
        }
    }

    static class FSsTobeAddedbackSingle
    extends FSsTobeAddedback {
        final List<FSIndexRepositoryImpl> views = new ArrayList<FSIndexRepositoryImpl>();

        FSsTobeAddedbackSingle() {
        }

        @Override
        void recordRemove(FSIndexRepositoryImpl view) {
            this.log(view);
            this.views.add(view);
        }

        @Override
        void recordRemove(TOP fs, FSIndexRepositoryImpl view) {
            this.recordRemove(view);
        }

        @Override
        void recordRemove(TOP fs, FSIndexRepositoryImpl view, int count) {
            if (count != 1) {
                throw new RuntimeException("internal error");
            }
            this.recordRemove(view);
        }

        @Override
        void addback(TOP fs) {
            for (FSIndexRepositoryImpl ir : this.views) {
                ir.addback(fs);
            }
            this.clear();
        }

        @Override
        void clear() {
            this.views.clear();
        }
    }
}

